/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.Provider;
import oracle.security.pki.OraclePKIDebug;

public final class OraclePKIProvider
extends Provider {
    public OraclePKIProvider() {
        super("OraclePKI", 1.0, "Oracle PKI provider v1.0, implements KeyStore interface for Oracle Wallets, and support for JSSE 1.4 and later");
        OraclePKIDebug.debug("Using OraclePKI Provider");
        this.put("KeyStore.PKCS12", "oracle.security.pki.OracleKeyStoreSpi");
        this.put("KeyStore.SSO", "oracle.security.pki.OracleSSOKeyStoreSpi");
        try {
            Class.forName("javax.net.ssl.TrustManagerFactory");
            OraclePKIDebug.debug("javax.net.ssl.TrustManagerFactory supported");
            this.put("TrustManagerFactory.OracleX509", "oracle.security.pki.ssl.OracleSSLX509TrustManagerFactory14");
        }
        catch (ClassNotFoundException classNotFoundException) {
            OraclePKIDebug.debug("javax.net.ssl.TrustManagerFactory not supported");
        }
        try {
            Class.forName("javax.net.ssl.KeyManagerFactory");
            OraclePKIDebug.debug("javax.net.ssl.KeyManagerFactory supported");
            this.put("KeyManagerFactory.OracleX509", "oracle.security.pki.ssl.OracleSSLX509KeyManagerFactory14");
        }
        catch (ClassNotFoundException classNotFoundException) {
            OraclePKIDebug.debug("javax.net.ssl.KeyManagerFactory not supported");
        }
    }
}

