/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Vector;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OracleKSEntry;
import oracle.security.pki.OracleLocalKeyId;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPrivateKey;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.pkcs12.PKCS12Bag;
import oracle.security.pki.internal.pkcs12.PKCS12CertBag;
import oracle.security.pki.internal.pkcs12.PKCS12KeyBag;
import oracle.security.pki.internal.pkcs12.PKCS12SecretBag;
import oracle.security.pki.internal.pkcs12.PKCS12ShroudedKeyBag;
import oracle.security.pki.internal.pqc.keys.OraclePKIMLDSAPrivateKey;
import oracle.security.pki.internal.pqc.keys.OraclePKISLHDSAPrivateKey;
import oracle.security.pki.textui.OraclePKIGenFunc;

class OracleKSIdentityEntry
extends OracleKSEntry {
    private PKCS12Bag c;
    private Certificate[] d;
    private CertificateRequest e;
    int b = -1;

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Certificate[] certificateArray) {
        this.c = pKCS12Bag;
        this.d = certificateArray;
    }

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Vector vector) {
        byte[] byArray;
        if (!(pKCS12Bag instanceof PKCS12SecretBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.c = null;
        ASN1Object aSN1Object = ((PKCS12SecretBag)pKCS12Bag).f();
        if (aSN1Object instanceof ASN1OctetString) {
            try {
                byArray = ((ASN1OctetString)aSN1Object).b();
                this.e = new CertificateRequest(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byArray = pKCS12Bag.c();
        this.b = OracleLocalKeyId.l(byArray);
        Vector<OraclePKIX509CertImpl> vector2 = new Vector<OraclePKIX509CertImpl>(vector.size());
        byte[] byArray2 = OracleLocalKeyId.c(OracleLocalKeyId.k(byArray), OracleLocalKeyId.l(byArray));
        for (int i = 0; i < vector.size(); ++i) {
            PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
            if (!this.a(pKCS12CertBag.c(), byArray2)) continue;
            vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.e()));
            vector.removeElementAt(i);
            if (!OraclePKIDebug.getDebugFlag()) break;
            try {
                OraclePKIDebug.debug("Found certificate " + pKCS12CertBag.e());
            }
            catch (Exception exception) {
                OraclePKIDebug.debug("Found certificate - Cannot be converted to string");
            }
            break;
        }
        if (vector2.size() == 0) {
            OraclePKIDebug.debug("No certificate found for cert req " + byArray);
            this.d = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector2.lastElement();
            while (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    PKCS12CertBag pKCS12CertBag = (PKCS12CertBag)vector.elementAt(i);
                    if (!x509Certificate.getIssuerDN().equals(pKCS12CertBag.e().m())) continue;
                    bl = true;
                    vector2.addElement(new OraclePKIX509CertImpl(pKCS12CertBag.e()));
                    x509Certificate = (X509Certificate)vector2.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.debug("Cert chain incomplete for key " + this.c);
                break;
            }
            OraclePKIDebug.debug("Cert chain determined");
            this.d = new Certificate[vector2.size()];
            this.d = vector2.toArray(this.d);
        }
    }

    OracleKSIdentityEntry(PKCS12Bag pKCS12Bag, Vector vector, Vector vector2) throws IOException {
        Object object;
        PKCS12Bag pKCS12Bag2;
        int n;
        Signature signature;
        if (!(pKCS12Bag instanceof PKCS12KeyBag) && !(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) {
            throw new IllegalArgumentException("Incorrect bag type" + pKCS12Bag);
        }
        this.c = pKCS12Bag;
        byte[] byArray = this.c.c();
        this.b = OracleLocalKeyId.l(byArray);
        byte[] byArray2 = "abcxyz".getBytes();
        byte[] byArray3 = null;
        String string = null;
        PrivateKey privateKey = pKCS12Bag instanceof PKCS12KeyBag ? ((PKCS12KeyBag)pKCS12Bag).e() : ((PKCS12ShroudedKeyBag)pKCS12Bag).g();
        if (privateKey == null) {
            throw new IOException("Invalid private key in keybag");
        }
        string = privateKey.getAlgorithm();
        if (string == null) {
            throw new IOException("Key algorithm is null");
        }
        if (string.equals("RSA")) {
            try {
                signature = JCEUtil.getSignatureInstance("SHA256withRSA");
                signature.initSign(privateKey);
                signature.update(byArray2, 0, byArray2.length);
                byArray3 = signature.sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                OraclePKIDebug.debug("Failure in RSA signature signing " + generalSecurityException.getMessage());
                throw new IOException(generalSecurityException.getLocalizedMessage());
            }
        }
        if (string.equals("EC")) {
            try {
                signature = JCEUtil.getSignatureInstance("SHA256withECDSA");
                signature.initSign(privateKey);
                signature.update(byArray2, 0, byArray2.length);
                byArray3 = signature.sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                OraclePKIDebug.debug("Failure in EC signature signing " + generalSecurityException.getMessage());
                throw new IOException(generalSecurityException.getMessage());
            }
        }
        if (string.equals("ML-DSA")) {
            try {
                signature = JCEUtil.getSignatureInstance("ML-DSA");
                signature.initSign(privateKey);
                signature.update(byArray2, 0, byArray2.length);
                byArray3 = signature.sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                OraclePKIDebug.debug("Failure in ML-DSA signature signing " + generalSecurityException.getMessage());
                throw new IOException(generalSecurityException.getMessage());
            }
        }
        if (string.contains("SLH-DSA")) {
            try {
                signature = JCEUtil.getSignatureInstance("SLH-DSA");
                signature.initSign(privateKey);
                signature.update(byArray2, 0, byArray2.length);
                byArray3 = signature.sign();
            }
            catch (GeneralSecurityException generalSecurityException) {
                OraclePKIDebug.debug("Failure in SLH-DSA signature signing");
                throw new IOException(generalSecurityException.getMessage());
            }
        }
        Vector<OraclePKIX509CertImpl> vector3 = new Vector<OraclePKIX509CertImpl>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            n = 0;
            pKCS12Bag2 = (PKCS12CertBag)vector.elementAt(i);
            PublicKey publicKey = ((PKCS12CertBag)pKCS12Bag2).e().b();
            String string2 = publicKey.getAlgorithm();
            if (string.equals(string2)) {
                if (string2.equals("RSA")) {
                    try {
                        signature = JCEUtil.getSignatureInstance("SHA256withRSA");
                        signature.initVerify(publicKey);
                        signature.update(byArray2, 0, byArray2.length);
                        n = signature.verify(byArray3) ? 1 : 0;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        OraclePKIDebug.debug("Failure in RSA signature verification.");
                    }
                } else if (string2.equals("EC")) {
                    try {
                        signature = JCEUtil.getSignatureInstance("SHA256withECDSA");
                        signature.initVerify(publicKey);
                        signature.update(byArray2, 0, byArray2.length);
                        n = signature.verify(byArray3) ? 1 : 0;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        OraclePKIDebug.debug("Failure in EC signature verification");
                    }
                } else if (string2.equals("ML-DSA")) {
                    try {
                        signature = JCEUtil.getSignatureInstance("ML-DSA");
                        signature.initVerify(publicKey);
                        signature.update(byArray2, 0, byArray2.length);
                        n = signature.verify(byArray3) ? 1 : 0;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        OraclePKIDebug.debug("Failure in ML-DSA signature verification.");
                    }
                } else if (string2.contains("SLH-DSA")) {
                    try {
                        signature = JCEUtil.getSignatureInstance("SLH-DSA");
                        signature.initVerify(publicKey);
                        signature.update(byArray2, 0, byArray2.length);
                        n = signature.verify(byArray3) ? 1 : 0;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        OraclePKIDebug.debug("Failure in SLH-DSA signature verification");
                    }
                }
            }
            if (this.a(pKCS12Bag2.c(), byArray) && n != 0) {
                vector3.addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).e()));
                vector.removeElementAt(i);
                if (!OraclePKIDebug.getDebugFlag()) break;
                try {
                    OraclePKIDebug.debug("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).e());
                }
                catch (Exception exception) {
                    OraclePKIDebug.debug("Found certificate - Cannot be converted to string");
                }
                break;
            }
            if (!OracleLocalKeyId.j(byArray)) {
                if (n == 0) continue;
                vector3.addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).e()));
                vector.removeElementAt(i);
                if (!OraclePKIDebug.getDebugFlag()) break;
                try {
                    OraclePKIDebug.debug("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).e());
                }
                catch (Exception exception) {
                    OraclePKIDebug.debug("Found certificate - Cannot be converted to string");
                }
                break;
            }
            if (OracleLocalKeyId.d(pKCS12Bag2.c()) || n == 0) continue;
            vector3.addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)pKCS12Bag2).e()));
            vector.removeElementAt(i);
            if (!OraclePKIDebug.getDebugFlag()) break;
            try {
                OraclePKIDebug.debug("Found certificate " + ((PKCS12CertBag)pKCS12Bag2).e());
            }
            catch (Exception exception) {
                OraclePKIDebug.debug("Found certificate - Cannot be converted to string");
            }
            break;
        }
        byte[] byArray4 = OracleLocalKeyId.d(OracleLocalKeyId.k(byArray), OracleLocalKeyId.l(byArray));
        for (n = 0; n < vector2.size(); ++n) {
            ASN1Object aSN1Object;
            pKCS12Bag2 = (PKCS12SecretBag)vector2.elementAt(n);
            if (!this.a(pKCS12Bag2.c(), byArray4) || !((aSN1Object = ((PKCS12SecretBag)pKCS12Bag2).f()) instanceof ASN1OctetString)) continue;
            try {
                object = ((ASN1OctetString)aSN1Object).b();
                this.e = new CertificateRequest((byte[])object);
                vector2.removeElementAt(n);
                OraclePKIDebug.debug("Found cert req " + this.e);
                break;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (vector3.size() == 0) {
            OraclePKIDebug.debug("No certificate found for key " + this.c.c());
            this.d = null;
        } else {
            X509Certificate x509Certificate = (X509Certificate)vector3.lastElement();
            while (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
                boolean bl = false;
                for (int i = 0; i < vector.size(); ++i) {
                    object = (PKCS12CertBag)vector.elementAt(i);
                    if (!x509Certificate.getIssuerDN().equals(((PKCS12CertBag)object).e().m())) continue;
                    bl = true;
                    vector3.addElement(new OraclePKIX509CertImpl(((PKCS12CertBag)object).e()));
                    x509Certificate = (X509Certificate)vector3.lastElement();
                    break;
                }
                if (bl) continue;
                OraclePKIDebug.debug("Cert chain incomplete for key " + this.c);
                break;
            }
            OraclePKIDebug.debug("Cert chain determined");
            this.d = new Certificate[vector3.size()];
            this.d = vector3.toArray(this.d);
        }
    }

    String a(byte[] byArray) {
        return new String("personaNum:" + OracleLocalKeyId.k(byArray) + "  componentNum:" + OracleLocalKeyId.l(byArray));
    }

    Key g() {
        String string;
        PrivateKey privateKey = null;
        if (this.c instanceof PKCS12KeyBag) {
            privateKey = ((PKCS12KeyBag)this.c).e();
        } else if (this.c instanceof PKCS12ShroudedKeyBag) {
            privateKey = ((PKCS12ShroudedKeyBag)this.c).g();
        }
        if (privateKey == null) {
            OraclePKIDebug.debug("No private key found");
        }
        if (OraclePKIGenFunc.isNullOrEmpty(string = privateKey.getAlgorithm())) {
            OraclePKIDebug.debug("No algorithm specified");
        }
        if (privateKey instanceof RSAPrivateCrtKey) {
            return new OraclePKIRSAPrivateKey((RSAPrivateCrtKey)privateKey, this.e);
        }
        if (privateKey instanceof ECPrivateKey) {
            return new OraclePKIECPrivateKey((ECPrivateKey)privateKey, this.e);
        }
        if (string.contains("ML-DSA")) {
            return new OraclePKIMLDSAPrivateKey(privateKey, this.e);
        }
        if (string.contains("SLH-DSA")) {
            return new OraclePKISLHDSAPrivateKey(privateKey, this.e);
        }
        if (this.e != null && this.c == null) {
            return new OraclePKIRSAPrivateKey(null, this.e);
        }
        return null;
    }

    @Override
    Certificate f() {
        if (this.d == null) {
            return null;
        }
        return this.d[0];
    }

    @Override
    Certificate[] e() {
        if (this.d == null) {
            return null;
        }
        return (Certificate[])this.d.clone();
    }

    @Override
    boolean d() {
        return true;
    }

    @Override
    String b() {
        String string = null;
        Certificate certificate = this.f();
        if (certificate instanceof X509Certificate) {
            OraclePKIDebug.debug("Certificate for private key is " + certificate);
            X500Name x500Name = new X500Name(((X509Certificate)certificate).getSubjectDN().getName());
            string = "CN=" + x500Name.f();
            if (x500Name.f() == null) {
                string = "OU=" + x500Name.e();
            }
            return string;
        }
        return "";
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        if (byArray == null | byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    byte[] h() {
        if (this.c == null) {
            return null;
        }
        return this.c.c();
    }

    int i() {
        return this.b;
    }
}

