/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.internal.asn1.ASN1Constructed;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1TaggedObject;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.cert.CRL;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.Utils;

public class PKCS7
implements Externalizable,
ASN1Object {
    private ArrayList<X509> b;
    private ArrayList<CRL> c;
    private X500Name d;
    private BigInteger e;
    private RSAPublicKey f;
    private Signature g;
    private byte[] h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private byte[] l;
    private AlgorithmIdentifier m;
    private ASN1Sequence n;
    protected static final int[] a = new int[]{1, 2, 840, 113549, 1, 7};

    public PKCS7() {
    }

    public PKCS7(List<X509> list, List<CRL> list2) {
        ArrayList<Object> arrayList = list == null ? null : (this.b = list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<X509>(list));
        this.c = list2 == null ? null : (list2 instanceof ArrayList ? (ArrayList<Object>)list2 : new ArrayList<CRL>(list2));
    }

    public PKCS7(X509 x509) {
        this.b = new ArrayList();
        this.b.add(x509);
    }

    public PKCS7(CRL cRL) {
        this.c = new ArrayList();
        this.c.add(cRL);
    }

    public PKCS7(X509Certificate x509Certificate, RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this();
        this.a(x509Certificate, rSAPrivateKey, algorithmIdentifier, byArray);
    }

    public PKCS7(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public PKCS7(ASN1Sequence aSN1Sequence) throws IOException {
        this.a(aSN1Sequence);
    }

    public ArrayList<X509> a() {
        return this.b;
    }

    public ArrayList<CRL> b() {
        return this.c;
    }

    public void a(X509 x509) {
        if (this.b == null) {
            this.b = new ArrayList();
        }
        this.b.add(x509);
    }

    public void a(CRL cRL) {
        if (this.c == null) {
            this.c = new ArrayList();
        }
        this.c.add(cRL);
    }

    public X500Name c() {
        return this.d;
    }

    public BigInteger d() {
        return this.e;
    }

    public void a(RSAPublicKey rSAPublicKey) {
        this.f = rSAPublicKey;
        try {
            this.g = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(PKCS7.b(this.m)));
            this.g.initVerify(this.f);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalStateException(invalidKeyException);
        }
    }

    public void b(X509 x509) {
    }

    public void a(X509Certificate x509Certificate) {
        if (this.d == null) {
            this.d = X500Name.a(x509Certificate.getIssuerX500Principal());
        } else if (!this.d.equals(x509Certificate.getIssuerX500Principal())) {
            throw new RuntimeException("The issuer is " + this.d + ", which is not " + x509Certificate.getIssuerX500Principal());
        }
        if (this.e == null) {
            this.e = x509Certificate.getSerialNumber();
        } else if (!this.e.equals(x509Certificate.getSerialNumber())) {
            throw new RuntimeException("The serial number is " + this.e + ", which is not " + x509Certificate.getSerialNumber());
        }
        this.a((RSAPublicKey)x509Certificate.getPublicKey());
    }

    public void a(byte[] byArray) {
        if (this.f == null) {
            throw new IllegalStateException("The public key is not set");
        }
        this.l = byArray;
    }

    public void a(X509Certificate x509Certificate, RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this.d = X500Name.a(x509Certificate.getIssuerX500Principal());
        this.e = x509Certificate.getSerialNumber();
        if (!x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.f = (RSAPublicKey)x509Certificate.getPublicKey();
        this.m = PKCS7.a(algorithmIdentifier);
        try {
            this.g = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(algorithmIdentifier));
            this.g.initSign(rSAPrivateKey);
            this.g.update(byArray);
            this.k = this.g.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
    }

    public boolean e() throws AuthException {
        if (this.h == null) {
            try {
                this.g.update(this.l);
                return this.g.verify(this.k);
            }
            catch (SignatureException signatureException) {
                throw new AuthException(signatureException);
            }
        }
        try {
            this.g.update(this.l);
            MessageDigest messageDigest = JCEUtil.getMessageDigestInstance(CryptoUtils.getDigestAlg(this.m));
            messageDigest.update(this.l);
            this.j = messageDigest.digest();
            return this.g.verify(this.k) && Utils.areEqual(this.j, this.i);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new AuthException(signatureException);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.g().output(outputStream);
    }

    private ASN1Sequence g() {
        if (this.n != null) {
            return this.n;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.a(new ASN1ObjectID(a, 2));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.a(new ASN1Integer(1L));
        aSN1Sequence2.a(new ASN1Set());
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        aSN1Sequence3.a(new ASN1ObjectID(a, 1));
        aSN1Sequence2.a(aSN1Sequence3);
        if (this.b != null) {
            aSN1Sequence2.a(new ASN1GenericConstructed(this.b, 0));
        }
        if (this.c != null) {
            aSN1Sequence2.a(new ASN1GenericConstructed(this.c, 1));
        }
        if (this.g == null) {
            aSN1Sequence2.a(new ASN1Set());
        } else {
            aSN1Sequence3 = new ASN1Sequence();
            aSN1Sequence3.a(new ASN1Integer(1L));
            ASN1Sequence aSN1Sequence4 = new ASN1Sequence();
            aSN1Sequence4.a(this.d);
            aSN1Sequence4.a(new ASN1Integer(this.e));
            aSN1Sequence3.a(aSN1Sequence4);
            aSN1Sequence3.a(this.m);
            aSN1Sequence3.a(AlgID.e);
            aSN1Sequence3.a(new ASN1OctetString(this.k));
            aSN1Sequence2.a(new ASN1Set(aSN1Sequence3));
        }
        aSN1Sequence.a(new ASN1GenericConstructed(aSN1Sequence2, 0));
        this.n = aSN1Sequence;
        return aSN1Sequence;
    }

    private static AlgorithmIdentifier a(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.a().equals(AlgID.w.a())) {
            return AlgID.M;
        }
        if (algorithmIdentifier.a().equals(AlgID.x.a())) {
            return AlgID.K;
        }
        if (algorithmIdentifier.a().equals(AlgID.y.a())) {
            return AlgID.N;
        }
        throw new IllegalStateException("Unsupported signature algorithm identifier");
    }

    private static AlgorithmIdentifier b(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.a().equals(AlgID.M.a())) {
            return AlgID.w;
        }
        if (algorithmIdentifier.a().equals(AlgID.K.a())) {
            return AlgID.x;
        }
        if (algorithmIdentifier.a().equals(AlgID.N.a()) || algorithmIdentifier.a().equals(AlgID.O.a())) {
            return AlgID.y;
        }
        throw new IllegalStateException("Unsupported message digest algorithm identifier");
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a(new ASN1Sequence(inputStream));
    }

    public void a(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1Constructed aSN1Constructed;
            this.n = aSN1Sequence;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.a(0);
            if (!aSN1ObjectID.a(a, 2)) {
                throw new IOException("contentType has to be signedData");
            }
            if (aSN1Sequence.b().size() < 2) {
                throw new IOException("No content");
            }
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1GenericConstructed)aSN1Sequence.a(1)).a(0);
            this.b = null;
            this.c = null;
            int n = 3;
            while (!(aSN1Sequence2.a(n) instanceof ASN1Set)) {
                aSN1Constructed = (ASN1GenericConstructed)aSN1Sequence2.a(n);
                switch (((ASN1GenericConstructed)aSN1Constructed).d()) {
                    case 0: {
                        int n2;
                        this.b = new ArrayList();
                        int n3 = ((ASN1GenericConstructed)aSN1Constructed).c();
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.b.add(new X509(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).a(n2))));
                        }
                        break;
                    }
                    case 1: {
                        int n2;
                        this.c = new ArrayList();
                        int n3 = ((ASN1GenericConstructed)aSN1Constructed).c();
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.c.add(new CRL(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).a(n2))));
                        }
                        break;
                    }
                }
                ++n;
            }
            aSN1Constructed = (ASN1Set)aSN1Sequence2.a(n);
            if (((ASN1Set)aSN1Constructed).b().size() > 0) {
                n = 0;
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((ASN1Set)aSN1Constructed).a(0);
                int n4 = ++n;
                ASN1TaggedObject aSN1TaggedObject = (ASN1Sequence)aSN1Sequence3.a(n4);
                this.d = new X500Name((ASN1Sequence)((ASN1Sequence)aSN1TaggedObject).a(0));
                this.e = ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).a(1)).c();
                int n5 = ++n;
                this.m = new AlgorithmIdentifier(Utils.toStream((ASN1Sequence)aSN1Sequence3.a(n5)));
                if (aSN1Sequence3.a(++n) instanceof ASN1GenericConstructed) {
                    aSN1TaggedObject = new ASN1Set(((ASN1GenericConstructed)aSN1Sequence3.a(n++)).b());
                    this.h = Utils.toBytes(aSN1TaggedObject);
                    this.i = null;
                    ArrayList<ASN1Object> arrayList = ((ASN1Set)aSN1TaggedObject).b();
                    int n6 = arrayList.size();
                    for (int i = 0; i < n6; ++i) {
                        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)arrayList.get(i);
                        ASN1ObjectID aSN1ObjectID2 = (ASN1ObjectID)aSN1Sequence4.a(0);
                        if (!aSN1ObjectID2.a(ASN1Utils.e, 9, 4)) continue;
                        this.i = ((ASN1OctetString)((ASN1Set)aSN1Sequence4.a(1)).a(0)).b();
                    }
                    if (this.i == null) {
                        throw new IOException("No message digest found in authenticatedAttributes");
                    }
                }
                if (!((ASN1ObjectID)(aSN1TaggedObject = (ASN1ObjectID)((ASN1Sequence)aSN1Sequence3.a(n++)).a(0))).equals(AlgID.e.a())) {
                    throw new IOException("Unsupported encryption algorithm " + aSN1TaggedObject);
                }
                this.k = ((ASN1OctetString)aSN1Sequence3.a(n++)).b();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public int length() {
        return this.g().length();
    }

    public byte[] f() {
        return Utils.toBytes(this.g());
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

