/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.Attribute;
import oracle.security.pki.internal.cert.AttributeSet;
import oracle.security.pki.internal.cert.PKIX;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509ExtensionSet;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.KeyWrapper;
import oracle.security.pki.util.Utils;

public class CertificateRequest
implements Externalizable,
ASN1Object {
    private X500Name a;
    private PublicKey b;
    private AttributeSet c;
    private ASN1Sequence d;
    private PrivateKey e;
    private AlgorithmIdentifier f;
    private byte[] g;
    private boolean h;
    private ASN1Sequence i = null;

    public CertificateRequest() {
    }

    public CertificateRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) {
        this(x500Name, publicKey, privateKey, false);
    }

    public CertificateRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey, boolean bl) {
        this.a = x500Name;
        this.b = publicKey;
        this.e = privateKey;
        this.h = bl;
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair) {
        this(x500Name, keyPair, false);
    }

    public CertificateRequest(X500Name x500Name, KeyPair keyPair, boolean bl) {
        this.a = x500Name;
        this.b = keyPair.getPublic();
        this.e = keyPair.getPrivate();
        this.h = bl;
    }

    public CertificateRequest(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public CertificateRequest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray));
    }

    public void a() throws SignatureException {
        this.k();
        try {
            if (this.f == null) {
                if (this.e.getAlgorithm().equals("RSA")) {
                    this.f = AlgID.A;
                } else if (this.e.getAlgorithm().equals("DSA")) {
                    this.f = AlgID.D;
                } else if (this.e.getAlgorithm().equals("EC")) {
                    int n = ((ECPrivateKey)this.e).getParams().getCurve().getField().getFieldSize();
                    switch (n) {
                        case 256: {
                            this.f = AlgID.H;
                            break;
                        }
                        case 384: {
                            this.f = AlgID.I;
                            break;
                        }
                        case 512: {
                            this.f = AlgID.J;
                            break;
                        }
                        default: {
                            this.f = AlgID.G;
                        }
                    }
                }
            }
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.f));
            signature.initSign(this.e);
            signature.update(Utils.toBytes(this.d));
            this.g = signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
        this.l();
    }

    public byte[] b() throws SignatureException {
        if (this.g == null) {
            this.a();
        }
        return this.g;
    }

    private ASN1Sequence k() {
        if (this.d == null) {
            this.d = new ASN1Sequence();
            this.d.a(new ASN1Integer(0L));
            this.d.a(this.a);
            KeyWrapper keyWrapper = null;
            try {
                keyWrapper = new KeyWrapper();
                keyWrapper.initialize("Public", this.b);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.d.a(CryptoUtils.subjectPublicKeyInfo(keyWrapper));
            if (this.c != null) {
                this.d.a(new ASN1GenericConstructed(this.c.d().b(), 0));
            } else if (!this.h) {
                this.d.a(new ASN1GenericConstructed(new ArrayList(), 0));
            }
        }
        return this.d;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.m();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.d = new ASN1Sequence(aSN1SequenceInputStream);
        this.f = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.g = ASN1BitString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
        aSN1SequenceInputStream = new ASN1SequenceInputStream(Utils.toStream(this.d));
        int n = ASN1Integer.b(aSN1SequenceInputStream).intValue();
        if (n != 0) {
            throw new ASN1FormatException("Expected version 0, got " + n);
        }
        this.a = new X500Name(aSN1SequenceInputStream);
        this.b = CryptoUtils.inputSPKI(aSN1SequenceInputStream);
        if (aSN1SequenceInputStream.a()) {
            if (aSN1SequenceInputStream.d() == 0) {
                aSN1SequenceInputStream.a(17);
                this.c = new AttributeSet(aSN1SequenceInputStream);
            } else {
                throw new ASN1FormatException("Expected tag 0, got " + aSN1SequenceInputStream.d());
            }
        }
        aSN1SequenceInputStream.b();
        try {
            this.c();
        }
        catch (AuthException authException) {
            throw new IOException(authException);
        }
    }

    public boolean c() throws AuthException, IOException {
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.f));
            signature.initVerify(this.b);
            signature.update(Utils.toBytes(this.d));
            return signature.verify(this.g);
        }
        catch (SignatureException signatureException) {
            throw new AuthException(signatureException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthException(invalidKeyException);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.d().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException);
        }
    }

    @Override
    public int length() {
        try {
            return this.d().length();
        }
        catch (SignatureException signatureException) {
            return 0;
        }
    }

    ASN1Sequence d() throws SignatureException {
        if (this.i == null) {
            this.b();
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.d);
            aSN1Sequence.a(this.f);
            aSN1Sequence.a(new ASN1BitString(this.g));
            this.i = aSN1Sequence;
        }
        return this.i;
    }

    private void l() {
        this.i = null;
    }

    private void m() {
        this.l();
        this.d = null;
        this.g = null;
    }

    public void a(X500Name x500Name) {
        this.a = x500Name;
        this.m();
    }

    public X500Name e() {
        return this.a;
    }

    public PublicKey f() {
        return this.b;
    }

    public void a(PublicKey publicKey) {
        this.b = publicKey;
        this.m();
    }

    public void a(PrivateKey privateKey) {
        this.a(privateKey, null);
    }

    public void a(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.e = privateKey;
        this.a(algorithmIdentifier);
    }

    public void a(AlgorithmIdentifier algorithmIdentifier) {
        this.f = algorithmIdentifier;
        this.m();
    }

    public AlgorithmIdentifier g() {
        return this.f;
    }

    public Attribute a(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.a(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public Attribute a(Attribute attribute) {
        this.m();
        if (this.c == null) {
            this.c = new AttributeSet();
        }
        return this.c.a(attribute);
    }

    public Attribute a(ASN1ObjectID aSN1ObjectID) {
        return this.c != null ? this.c.a(aSN1ObjectID) : null;
    }

    public AttributeSet h() {
        return this.c;
    }

    public X509Extension a(X509Extension x509Extension) {
        X509ExtensionSet x509ExtensionSet = this.i();
        if (x509ExtensionSet == null) {
            x509ExtensionSet = new X509ExtensionSet();
        }
        X509Extension x509Extension2 = x509ExtensionSet.a(x509Extension.b());
        x509ExtensionSet.a(x509Extension);
        this.a(x509ExtensionSet);
        return x509Extension2;
    }

    public X509ExtensionSet a(X509ExtensionSet x509ExtensionSet) {
        Attribute attribute = this.a(PKIX.j, x509ExtensionSet);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream(attribute.b().get(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    public X509ExtensionSet i() {
        Attribute attribute = this.a(PKIX.j);
        if (attribute != null) {
            try {
                return new X509ExtensionSet(Utils.toStream(attribute.b().get(0)));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return null;
    }

    public void a(boolean bl) {
        this.h = bl;
        this.m();
    }

    public boolean j() {
        return this.h;
    }

    public String toString() {
        return "subject = " + this.a + ", pubKey = " + this.b;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

