/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.exception.AuthException;
import oracle.security.pki.internal.asn1.ASN1BitString;
import oracle.security.pki.internal.asn1.ASN1ConstructedInputStream;
import oracle.security.pki.internal.asn1.ASN1Date;
import oracle.security.pki.internal.asn1.ASN1GenericConstructed;
import oracle.security.pki.internal.asn1.ASN1Integer;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.RevokedCertificate;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.internal.cert.X509ExtensionSet;
import oracle.security.pki.internal.core.AlgID;
import oracle.security.pki.internal.core.AlgorithmIdentifier;
import oracle.security.pki.util.CryptoUtils;
import oracle.security.pki.util.StreamableOutputException;
import oracle.security.pki.util.Utils;

public class CRL
implements Externalizable,
ASN1Object {
    private ASN1Sequence b = null;
    private AlgorithmIdentifier c = null;
    private byte[] d = null;
    private X500Name e;
    private Date f = new Date();
    private Date g = null;
    private LinkedHashMap<BigInteger, RevokedCertificate> h = null;
    private X509ExtensionSet i = null;
    private PrivateKey j;
    private PublicKey k;
    private X509Certificate l;
    private int m;
    private ASN1Sequence n = null;
    X509CRLImpl a = new X509CRLImpl();

    public CRL() {
    }

    public CRL(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public CRL(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public CRL(URL uRL) throws IOException {
        this(uRL.openStream());
    }

    public static CRL a(X509CRL x509CRL) {
        if (x509CRL instanceof X509CRLImpl) {
            return ((X509CRLImpl)x509CRL).a();
        }
        try {
            return new CRL(new ByteArrayInputStream(x509CRL.getEncoded()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        catch (CRLException cRLException) {
            throw new RuntimeException(cRLException);
        }
    }

    public void a(X500Name x500Name) {
        this.e = x500Name;
        this.E();
    }

    public void a(X509Certificate x509Certificate) {
        this.l = x509Certificate;
        if (this.e == null) {
            if (x509Certificate instanceof X509.X509CertificateImpl) {
                this.a(((X509.X509CertificateImpl)x509Certificate).a().n());
            } else {
                this.a(X500Name.a(x509Certificate.getIssuerX500Principal()));
            }
        }
        this.a(this.l.getPublicKey());
    }

    public X500Name a() {
        return this.e;
    }

    public void a(PublicKey publicKey) {
        this.k = publicKey;
    }

    public void a(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.j = privateKey;
        this.a(algorithmIdentifier);
    }

    public void a(AlgorithmIdentifier algorithmIdentifier) {
        this.c = algorithmIdentifier;
        this.E();
    }

    public Date b() {
        return this.f;
    }

    public Date c() {
        return this.g;
    }

    public ArrayList<RevokedCertificate> d() {
        return this.h == null ? null : new ArrayList<RevokedCertificate>(this.h.values());
    }

    public Map<BigInteger, RevokedCertificate> e() {
        return this.h;
    }

    public Enumeration<BigInteger> f() {
        return this.h != null ? new Vector<BigInteger>(this.h.keySet()).elements() : new Vector().elements();
    }

    public void a(List<? extends RevokedCertificate> list) {
        if (list != null && list.size() > 0) {
            this.h = new LinkedHashMap();
            for (RevokedCertificate revokedCertificate : list) {
                this.h.put(revokedCertificate.a(), revokedCertificate);
            }
            this.E();
        }
    }

    public void a(Date date) {
        this.f = date;
        this.E();
    }

    public void a(Date date, Date date2) {
        this.f = date;
        this.g = date2;
        this.E();
    }

    public void a(int n) {
        this.a(new Date(), Utils.daysFromNow(n));
    }

    public void a(BigInteger bigInteger) {
        this.a(bigInteger, new Date());
    }

    public void a(BigInteger bigInteger, Date date) {
        this.a(new RevokedCertificate(bigInteger, date));
    }

    public void a(RevokedCertificate revokedCertificate) {
        if (this.h == null) {
            this.h = new LinkedHashMap();
        }
        this.h.put(revokedCertificate.a(), revokedCertificate);
        this.E();
    }

    public X509ExtensionSet g() {
        return this.i;
    }

    public X509Extension a(ASN1ObjectID aSN1ObjectID) {
        return this.i != null ? this.i.a(aSN1ObjectID) : null;
    }

    public void a(X509ExtensionSet x509ExtensionSet) {
        this.i = x509ExtensionSet;
        this.E();
    }

    public void a(X509Extension x509Extension) {
        if (this.i == null) {
            this.i = new X509ExtensionSet();
        }
        this.i.a(x509Extension);
        this.E();
    }

    public RevokedCertificate b(BigInteger bigInteger) {
        return this.h != null ? this.h.get(bigInteger) : null;
    }

    public Date c(BigInteger bigInteger) {
        RevokedCertificate revokedCertificate = this.b(bigInteger);
        return revokedCertificate != null ? revokedCertificate.getRevocationDate() : null;
    }

    public boolean d(BigInteger bigInteger) {
        return this.b(bigInteger) != null;
    }

    public boolean h() {
        if (this.i != null && this.i.d()) {
            return true;
        }
        if (this.h != null) {
            for (RevokedCertificate revokedCertificate : this.h.values()) {
                X509ExtensionSet x509ExtensionSet;
                if (revokedCertificate == null || (x509ExtensionSet = revokedCertificate.b()) == null || !x509ExtensionSet.d()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean i() throws AuthException, IOException {
        if (this.h()) {
            return false;
        }
        if (!this.j()) {
            return false;
        }
        return this.k();
    }

    public boolean j() {
        Date date = new Date();
        if (date.before(this.f)) {
            return false;
        }
        return this.g == null || !date.after(this.g);
    }

    public boolean k() throws AuthException, IOException {
        ASN1Sequence aSN1Sequence = this.C();
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.c));
            signature.initVerify(this.k);
            signature.update(Utils.toBytes(aSN1Sequence));
            return signature.verify(this.u());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AuthException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new AuthException(signatureException);
        }
    }

    public void l() throws SignatureException {
        ASN1Sequence aSN1Sequence = this.C();
        try {
            Signature signature = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(this.c));
            signature.initSign(this.j);
            signature.update(Utils.toBytes(aSN1Sequence));
            this.d = signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new SignatureException(signatureException);
        }
        finally {
            this.F();
        }
    }

    public byte[] m() throws SignatureException {
        if (this.d == null) {
            this.l();
        }
        return this.d;
    }

    private ASN1Sequence C() {
        if (this.b == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.i != null && this.i.c() > 0) {
                aSN1Sequence.a(new ASN1Integer(1L));
            } else if (this.h != null && this.h.size() > 0) {
                for (RevokedCertificate object2 : this.h.values()) {
                    if (object2.c() == null || object2.c().size() <= 0) continue;
                    aSN1Sequence.a(new ASN1Integer(1L));
                    break;
                }
            }
            if (this.c == null && this.j != null) {
                if (this.j.getAlgorithm().equals("RSA")) {
                    this.c = AlgID.A;
                } else if (this.j.getAlgorithm().equals("DSA")) {
                    this.c = AlgID.D;
                } else if (this.j.getAlgorithm().equals("EC")) {
                    int n = ((ECPrivateKey)this.j).getParams().getCurve().getField().getFieldSize();
                    switch (n) {
                        case 256: {
                            this.c = AlgID.H;
                            break;
                        }
                        case 384: {
                            this.c = AlgID.I;
                            break;
                        }
                        case 512: {
                            this.c = AlgID.J;
                            break;
                        }
                        default: {
                            this.c = AlgID.G;
                        }
                    }
                }
            }
            aSN1Sequence.a(this.c);
            aSN1Sequence.a(this.e);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.f);
            aSN1Sequence.a(new ASN1Date(this.f, calendar.get(1) > 2049));
            if (this.g != null) {
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(this.g);
                aSN1Sequence.a(new ASN1Date(this.g, calendar2.get(1) > 2049));
            }
            if (this.h != null && this.h.size() > 0) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                for (RevokedCertificate revokedCertificate : this.h.values()) {
                    aSN1Sequence2.a(revokedCertificate);
                }
                aSN1Sequence.a(aSN1Sequence2);
            }
            if (this.i != null && this.i.c() > 0) {
                aSN1Sequence.a(new ASN1GenericConstructed(this.i, 0));
            }
            this.b = aSN1Sequence;
        }
        return this.b;
    }

    private ASN1Sequence D() throws SignatureException {
        if (this.n == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(this.C());
            aSN1Sequence.a(this.c);
            aSN1Sequence.a(new ASN1BitString(this.m()));
            this.n = aSN1Sequence;
        }
        return this.n;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.D().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new IOException(signatureException.toString());
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1ConstructedInputStream aSN1ConstructedInputStream;
        Serializable serializable;
        this.E();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.b = new ASN1Sequence(aSN1SequenceInputStream);
        this.c = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.d = ASN1BitString.a(aSN1SequenceInputStream);
        aSN1SequenceInputStream.b();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.b));
        if (aSN1SequenceInputStream2.d() == 2) {
            serializable = ASN1Integer.b(aSN1SequenceInputStream2);
            this.m = ((BigInteger)serializable).intValue() + 1;
        }
        if (!((AlgorithmIdentifier)(serializable = new AlgorithmIdentifier(aSN1SequenceInputStream2))).equals(this.c)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        X500Name x500Name = new X500Name(aSN1SequenceInputStream2);
        if (this.e == null) {
            this.e = x500Name;
        } else if (!this.e.equals(x500Name)) {
            throw new IOException("Expected issuer {" + this.e + "}, got issuer {" + x500Name + "}");
        }
        this.f = ASN1Date.a(aSN1SequenceInputStream2);
        this.g = aSN1SequenceInputStream2.d() == 23 || aSN1SequenceInputStream2.d() == 24 ? ASN1Date.a(aSN1SequenceInputStream2) : null;
        if (aSN1SequenceInputStream2.d() == 16) {
            aSN1ConstructedInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
            this.h = new LinkedHashMap();
            while (aSN1ConstructedInputStream.a()) {
                RevokedCertificate revokedCertificate = new RevokedCertificate(aSN1ConstructedInputStream);
                this.h.put(revokedCertificate.a(), revokedCertificate);
            }
            aSN1ConstructedInputStream.b();
        } else {
            this.h = null;
        }
        if (aSN1SequenceInputStream2.d() == 0) {
            aSN1ConstructedInputStream = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.i = new X509ExtensionSet(aSN1ConstructedInputStream);
            aSN1ConstructedInputStream.b();
        } else {
            this.i = null;
        }
        aSN1SequenceInputStream2.b();
    }

    private void E() {
        this.F();
        this.b = null;
        this.d = null;
    }

    private void F() {
        this.n = null;
    }

    @Override
    public int length() {
        try {
            return this.D().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CRL) {
            return this.a((CRL)object);
        }
        return false;
    }

    private boolean a(CRL cRL) {
        return Utils.areEqual(Utils.toBytes(this), Utils.toBytes(cRL));
    }

    public String toString() {
        String string = "issuer = " + this.e + ", thisUpdate = " + this.f;
        if (this.g != null) {
            string = string + ", nextUpdate = " + this.g;
        }
        string = string + ", revokedCertificates = {";
        if (this.h != null) {
            Iterator<RevokedCertificate> iterator = this.h.values().iterator();
            while (iterator.hasNext()) {
                RevokedCertificate revokedCertificate = iterator.next();
                string = string + "(" + revokedCertificate + ")";
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
        }
        string = string + "}";
        if (this.i != null && this.i.c() > 0) {
            string = string + ", extensions = " + this.i;
        }
        return string;
    }

    public byte[] n() {
        try {
            return Utils.toBytes(this.D());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public Principal o() {
        return this.p();
    }

    public X500Principal p() {
        return this.a().g();
    }

    public Date q() {
        return this.c();
    }

    public X509CRLEntry b(X509Certificate x509Certificate) {
        return null;
    }

    public String r() {
        return CryptoUtils.getSignatureAlg(this.c);
    }

    public String s() {
        return this.c.a().d();
    }

    public byte[] t() {
        return Utils.toBytes(this.c.b());
    }

    public byte[] u() {
        try {
            return this.m();
        }
        catch (SignatureException signatureException) {
            throw new RuntimeException(signatureException);
        }
    }

    public byte[] v() throws CRLException {
        return Utils.toBytes(this.C());
    }

    public Date w() {
        return this.b();
    }

    public int x() {
        return this.m;
    }

    public int hashCode() {
        return Arrays.hashCode(Utils.toBytes(this));
    }

    public void a(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null && !TransitionMode.isFIPS140ModeEnabled() ? Signature.getInstance(this.r(), string) : JCEUtil.getSignatureInstance(this.r());
        signature.initVerify(publicKey);
        signature.update(this.v());
        boolean bl = signature.verify(this.u());
        if (!bl) {
            throw new SignatureException("Public key does not match");
        }
    }

    public void b(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.a(publicKey, null);
    }

    public boolean a(Certificate certificate) {
        BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
        return bigInteger != null && this.h.containsKey(bigInteger);
    }

    public Set<String> y() {
        return this.i.getCriticalExtensionOIDs();
    }

    public byte[] a(String string) {
        return this.i.getExtensionValue(string);
    }

    public Set<String> z() {
        return this.i.getNonCriticalExtensionOIDs();
    }

    public boolean A() {
        return this.h();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }

    public X509CRL B() {
        return this.a;
    }

    class X509CRLImpl
    extends X509CRL {
        X509CRLImpl() {
        }

        @Override
        public boolean equals(Object object) {
            return CRL.this.equals(object);
        }

        @Override
        public byte[] getEncoded() {
            return CRL.this.n();
        }

        @Override
        public Principal getIssuerDN() {
            return CRL.this.o();
        }

        @Override
        public X500Principal getIssuerX500Principal() {
            return CRL.this.p();
        }

        @Override
        public Date getNextUpdate() {
            return CRL.this.q();
        }

        @Override
        public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
            return CRL.this.b(bigInteger);
        }

        @Override
        public X509CRLEntry getRevokedCertificate(X509Certificate x509Certificate) {
            return CRL.this.b(x509Certificate);
        }

        @Override
        public Set<? extends X509CRLEntry> getRevokedCertificates() {
            return new LinkedHashSet<RevokedCertificate>(CRL.this.d());
        }

        @Override
        public String getSigAlgName() {
            return CRL.this.r();
        }

        @Override
        public String getSigAlgOID() {
            return CRL.this.s();
        }

        @Override
        public byte[] getSigAlgParams() {
            return CRL.this.t();
        }

        @Override
        public byte[] getSignature() {
            return CRL.this.u();
        }

        @Override
        public byte[] getTBSCertList() {
            try {
                return CRL.this.v();
            }
            catch (CRLException cRLException) {
                cRLException.printStackTrace();
                return null;
            }
        }

        @Override
        public Date getThisUpdate() {
            return CRL.this.w();
        }

        @Override
        public int getVersion() {
            return CRL.this.x();
        }

        @Override
        public int hashCode() {
            return CRL.this.hashCode();
        }

        @Override
        public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            CRL.this.a(publicKey, string);
        }

        @Override
        public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            CRL.this.b(publicKey);
        }

        @Override
        public boolean isRevoked(Certificate certificate) {
            return CRL.this.a(certificate);
        }

        @Override
        public String toString() {
            return CRL.this.toString();
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return CRL.this.y();
        }

        @Override
        public byte[] getExtensionValue(String string) {
            return CRL.this.a(string);
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return CRL.this.z();
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return CRL.this.A();
        }

        public CRL a() {
            return CRL.this;
        }
    }
}

