/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.pki.JCEUtil;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.TransitionMode;
import oracle.security.pki.internal.OraclePKIRSAKeyHelper;
import oracle.security.pki.internal.cert.CertificateRequest;
import oracle.security.pki.internal.cert.X500Name;
import oracle.security.pki.internal.cert.X509;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.Utils;

public class OracleWalletJks
extends OracleWallet {
    private byte[] w = null;
    private char[] x = null;
    static ResourceBundle v = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public OracleWalletJks() {
        this.b();
    }

    @Override
    public void create(char[] cArray) throws IOException {
        this.b();
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(v.getString("PKI-01002"));
        }
        if (cArray != null) {
            this.x = new char[cArray.length];
            System.arraycopy(cArray, 0, this.x, 0, cArray.length);
        }
        this.w = null;
        KeyStore keyStore = this.getKeyStore();
        try {
            keyStore.load(null, this.x);
            super.a(keyStore);
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Could not create empty jks store.");
            throw (IOException)iOException.initCause(exception);
        }
    }

    @Override
    public synchronized void open(String string, char[] cArray) throws IOException {
        this.b();
        if (cArray != null) {
            this.x = new char[cArray.length];
            System.arraycopy(cArray, 0, this.x, 0, cArray.length);
        }
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        KeyStore keyStore = this.getKeyStore();
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            keyStore.load(fileInputStream, this.x);
            this.setKeyStore(keyStore);
        }
    }

    @Override
    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("jks");
            if (this.w != null) {
                keyStore.load(new ByteArrayInputStream(this.w), this.x);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(v.getString("PKI-03005"));
            throw (IOException)iOException.initCause(exception);
        }
        return keyStore;
    }

    @Override
    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (keyStore == null) {
            throw new IOException("KeyStore should not be null.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        keyStore.store(byteArrayOutputStream, this.x);
        this.w = byteArrayOutputStream.toByteArray();
    }

    @Override
    public synchronized void saveAs(String string) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.w);
        fileOutputStream.close();
    }

    @Override
    public boolean exists(String string) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        File file = new File(string);
        return file.exists();
    }

    @Override
    public void changePassword(char[] cArray) throws IOException {
        Object object;
        if (cArray == null) {
            throw new IOException("Password cannot be null string.");
        }
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(v.getString("PKI-01002"));
        }
        KeyStore keyStore = this.getKeyStore();
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (!keyStore.isKeyEntry((String)object)) continue;
                Key key = keyStore.getKey((String)object, this.x);
                Certificate[] certificateArray = keyStore.getCertificateChain((String)object);
                keyStore.setKeyEntry((String)object, key, cArray, certificateArray);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
        try {
            this.x = cArray;
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            object = new IOException();
            throw (IOException)((Throwable)object).initCause(exception);
        }
    }

    @Override
    public InputStream getWalletArray(boolean bl) throws IOException {
        return new ByteArrayInputStream(this.w);
    }

    @Override
    public byte[] getWalletArrayB(boolean bl) throws IOException {
        return this.w;
    }

    @Override
    public void setWalletArray(InputStream inputStream, char[] cArray) throws IOException {
        this.b();
        if (inputStream == null) {
            throw new IOException("InputStream is null");
        }
        if (cArray != null) {
            this.x = new char[cArray.length];
            System.arraycopy(cArray, 0, this.x, 0, cArray.length);
        }
        int n = inputStream.available();
        this.w = new byte[n];
        inputStream.read(this.w);
        KeyStore keyStore = this.getKeyStore();
        try {
            keyStore.load(new ByteArrayInputStream(this.w), this.x);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Create jks store failed.");
            throw (IOException)iOException.initCause(exception);
        }
    }

    @Override
    public void setWalletArray(byte[] byArray, char[] cArray) throws IOException {
        this.setWalletArray(new ByteArrayInputStream(byArray), cArray);
    }

    @Override
    public void addCertRequest(X500Principal x500Principal, int n, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        BigInteger bigInteger = new BigInteger("7");
        int n2 = 3650;
        this.a(x500Principal, n, n2, null, null, bigInteger, oracleCertExtension, string);
    }

    @Override
    public void createSelfSigned(X500Principal x500Principal, int n, int n2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n, n2, null, null, bigInteger, oracleCertExtension, string);
    }

    private void a(X500Principal x500Principal, int n, int n2, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        OraclePKIRSAKeyHelper.validateKeysize(n);
        KeyStore keyStore = this.getKeyStore();
        try {
            if (keyStore.containsAlias(string)) {
                throw new IOException(v.getString("PKI-04008") + string);
            }
        }
        catch (KeyStoreException keyStoreException) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(keyStoreException);
        }
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = JCEUtil.getKeyPairGeneratorInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(noSuchAlgorithmException.getLocalizedMessage());
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
        keyPairGenerator.initialize(n);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        X500Name x500Name = new X500Name(x500Principal.toString());
        X509 x509 = null;
        try {
            x509 = n2 == 0 ? new X509(x500Name, publicKey, x500Name, privateKey, bigInteger, date, date2, null) : new X509(x500Name, publicKey, x500Name, privateKey, bigInteger, n2, null);
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509.g()));
            Certificate[] certificateArray = new Certificate[]{x509Certificate};
            keyStore.setKeyEntry(string, privateKey, this.x, certificateArray);
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException(v.getString("PKI-03005"));
            throw (IOException)iOException.initCause(exception);
        }
    }

    @Override
    public String exportCertReqB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (string == null) {
            throw new IOException("alias not specified.");
        }
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException(v.getString("PKI-04017"));
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, this.x);
        CertificateRequest certificateRequest = new CertificateRequest(new X500Name(x509Certificate.getSubjectDN().toString()), rSAPublicKey, privateKey);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.output(byteArrayOutputStream);
        string2 = Utils.getBase64EncodedCert(byteArrayOutputStream.toByteArray(), "-----BEGIN NEW CERTIFICATE REQUEST-----", "-----END NEW CERTIFICATE REQUEST-----");
        return string2;
    }

    @Override
    public void importCert(InputStream inputStream, boolean bl, String string, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        if (bl) {
            if (keyStore.containsAlias(string)) {
                throw new IOException("A trusted certificate entry with alias='" + string + "' already exists in keystore.");
            }
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImplArray[i].getX509().g()));
                keyStore.setCertificateEntry(string, x509Certificate);
            }
        } else if (oraclePKIX509CertImplArray.length > 1) {
            Object object;
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            Certificate[] certificateArray = new Certificate[oraclePKIX509CertImplArray2.length];
            int n = oraclePKIX509CertImplArray2.length - 1;
            int n2 = 0;
            while (n > -1) {
                object = JCEUtil.getCertificateFactoryInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImplArray2[n].getEncoded()));
                certificateArray[n2] = x509Certificate;
                --n;
                ++n2;
            }
            RSAPrivateCrtKey rSAPrivateCrtKey = null;
            try {
                rSAPrivateCrtKey = (RSAPrivateCrtKey)keyStore.getKey(string, this.x);
            }
            catch (Exception exception) {
                object = new IOException("getKey failed.");
                ((Throwable)object).initCause(exception);
                throw object;
            }
            if (rSAPrivateCrtKey == null) {
                throw new IOException(v.getString("PKI-04009") + string);
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)certificateArray[0].getPublicKey();
            if (!rSAPrivateCrtKey.getPublicExponent().equals(rSAPublicKey.getPublicExponent()) || !rSAPrivateCrtKey.getModulus().equals(rSAPublicKey.getModulus())) {
                throw new IOException(v.getString("PKI-04018"));
            }
            keyStore.setKeyEntry(string, rSAPrivateCrtKey, this.x, certificateArray);
        } else {
            try {
                Certificate[] certificateArray;
                if (string == null || !keyStore.isKeyEntry(string)) {
                    throw new IOException("Entry specified by alias is not a key entry");
                }
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)keyStore.getKey(string, this.x);
                CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance("X.509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(oraclePKIX509CertImplArray[0].getEncoded()));
                RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
                if (!rSAPrivateCrtKey.getPublicExponent().equals(rSAPublicKey.getPublicExponent()) || !rSAPrivateCrtKey.getModulus().equals(rSAPublicKey.getModulus())) {
                    throw new IOException(v.getString("PKI-04018"));
                }
                Enumeration<String> enumeration = keyStore.aliases();
                Vector<Certificate> vector = new Vector<Certificate>(keyStore.size());
                while (enumeration.hasMoreElements()) {
                    certificateArray = enumeration.nextElement();
                    if (!keyStore.isCertificateEntry((String)certificateArray)) continue;
                    vector.addElement(keyStore.getCertificate((String)certificateArray));
                }
                certificateArray = this.a(vector, x509Certificate);
                keyStore.setKeyEntry(string, rSAPrivateCrtKey, this.x, certificateArray);
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getLocalizedMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }
        this.setKeyStore(keyStore);
    }

    X509Certificate[] a(Vector vector, X509Certificate x509Certificate) throws IOException {
        X509Certificate[] x509CertificateArray = null;
        Vector<X509Certificate> vector2 = new Vector<X509Certificate>(vector.size() + 1);
        boolean bl = false;
        vector2.addElement(x509Certificate);
        block0: do {
            bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (!((X509Certificate)vector.get(i)).getSubjectDN().equals(((X509Certificate)vector2.lastElement()).getIssuerDN())) continue;
                bl = true;
                vector2.addElement((X509Certificate)vector.get(i));
                vector.remove(i);
                continue block0;
            }
        } while (bl);
        X509Certificate x509Certificate2 = (X509Certificate)vector2.lastElement();
        if (!x509Certificate2.getSubjectX500Principal().equals(x509Certificate2.getIssuerX500Principal())) {
            throw new IOException("Could not make chain for user cert.");
        }
        x509CertificateArray = new X509Certificate[vector2.size()];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)vector2.get(i);
        }
        return x509CertificateArray;
    }

    @Override
    public String exportCertB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException("Entry specified by alias is not a key entry");
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        if (x509Certificate != null) {
            byte[] byArray = x509Certificate.getEncoded();
            string2 = Utils.getBase64EncodedCert(byArray, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
        }
        return string2;
    }

    @Override
    public X500Principal[] getCertReqDNs(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || !(x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)).getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
            vector.add(new X500Principal(x509Certificate.getSubjectDN().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n2] = (X500Principal)enumeration2.nextElement();
            ++n2;
        }
        return x500PrincipalArray;
    }

    @Override
    public int getCertReqCount(int n, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IOException("Not implemented.");
    }

    @Override
    public int getCertReqCount(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n2 = 0;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || !(x509Certificate = (X509Certificate)keyStore.getCertificate(string)).getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public String[] getCertReqAliases(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || !(x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)).getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n2 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n2] = (String)enumeration2.nextElement();
            ++n2;
        }
        return stringArray;
    }

    @Override
    public ArrayList getCertReqDNalias(int n) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) continue;
            arrayList2.add(x509Certificate.getSubjectDN().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    public String[] getCertReqInfo(int n, int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN()) && n2 == n3) {
                stringArray[0] = x509Certificate.getSubjectDN().toString();
                RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
                stringArray[1] = new Integer(rSAPublicKey.getModulus().intValue() * 8).toString();
                stringArray[2] = new String(x509Certificate.getPublicKey().getAlgorithm());
                stringArray[3] = new String(string);
                break;
            }
            ++n3;
        }
        return stringArray;
    }

    @Override
    public String[] getCertReqInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[3];
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            return stringArray;
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        stringArray[0] = x509Certificate.getSubjectDN().toString();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        stringArray[1] = new Integer(rSAPublicKey.getModulus().intValue() * 8).toString();
        stringArray[2] = new String(x509Certificate.getPublicKey().getAlgorithm());
        return stringArray;
    }

    @Override
    public String[] getCertInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            return stringArray;
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        X509 x509 = new X509(x509Certificate.getEncoded());
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
        stringArray[0] = oraclePKIX509CertImpl.getSubjectDN().toString();
        stringArray[1] = oraclePKIX509CertImpl.getIssuerDN().toString();
        stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
        stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
        stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
        stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
        stringArray[6] = new Integer(((RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
        stringArray[7] = super.a(oraclePKIX509CertImpl.getKeyUsage());
        stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
        stringArray[9] = TransitionMode.isFIPS140ModeEnabled() ? oraclePKIX509CertImpl.getSHA256Digest() : oraclePKIX509CertImpl.getMD5Digest();
        stringArray[10] = oraclePKIX509CertImpl.getSHADigest();
        stringArray[11] = null;
        return stringArray;
    }

    @Override
    public String[] getTrustpointInfo(int n, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isCertificateEntry(string)) {
            return stringArray;
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        X509 x509 = new X509(x509Certificate.getEncoded());
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
        stringArray[0] = oraclePKIX509CertImpl.getSubjectDN().toString();
        stringArray[1] = oraclePKIX509CertImpl.getIssuerDN().toString();
        stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
        stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
        stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
        stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
        stringArray[6] = new Integer(((RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
        stringArray[7] = null;
        stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
        stringArray[9] = TransitionMode.isFIPS140ModeEnabled() ? oraclePKIX509CertImpl.getSHA256Digest() : oraclePKIX509CertImpl.getMD5Digest();
        stringArray[10] = oraclePKIX509CertImpl.getSHADigest();
        stringArray[11] = null;
        return stringArray;
    }

    @Override
    public void removeTrustpoint(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isCertificateEntry(string)) {
            throw new IOException("Entry with input alias is not trusted cert.");
        }
        keyStore.deleteEntry(string);
        this.setKeyStore(keyStore);
    }

    @Override
    public void removeTrustpoints() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            keyStore.deleteEntry(string);
        }
        this.setKeyStore(keyStore);
    }

    @Override
    public void deleteCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException("Entry with input alias is not user cert.");
        }
        keyStore.deleteEntry(string);
        this.setKeyStore(keyStore);
    }

    @Override
    public void deleteCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore keyStore = this.getKeyStore();
        if (!keyStore.isKeyEntry(string)) {
            throw new IOException("Entry with input alias is not user cert.");
        }
        keyStore.deleteEntry(string);
        this.setKeyStore(keyStore);
    }

    @Override
    public Enumeration listAliases() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = this.getKeyStore();
        return keyStore.aliases();
    }

    @Override
    public void createSSO() throws IOException {
        throw new IOException();
    }

    @Override
    public synchronized void saveSSO() throws IOException {
        throw new IOException();
    }

    @Override
    public void saveLSSO() throws IOException {
        throw new IOException();
    }

    @Override
    public synchronized OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        throw new IOException();
    }

    @Override
    public synchronized void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        throw new IOException();
    }

    @Override
    public boolean isAutoLoginOnly() throws IOException {
        throw new IOException();
    }

    @Override
    public Enumeration getWalletPersonas() {
        return null;
    }

    @Override
    public void Pkcs11AddCertReq(String string, String string2, String string3, String string4, int n, String string5) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, Exception {
        throw new IOException();
    }

    @Override
    public boolean containsPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public String[] getPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public void addP11CertLbl(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public void addP11Lib(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public void addP11TokenLabel(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public void addP11TokenPwd(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public X509Certificate getSSLCert(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IOException();
    }

    @Override
    public String getSSLCertAlias(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        throw new IOException();
    }

    @Override
    public String trustpointNeededB64(String string, String string2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    @Override
    public boolean isTrustedCertUsedInChain(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        throw new IOException();
    }

    private void b() {
        this.x = null;
        this.w = null;
    }
}

