/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.ECPublicKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.util.Utils;
import oracle.security.pki.OracleCRL;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIX509CrlFileStore;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.ldap.ConnectionUtil;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.SignatureAlgorithms;

public class OracleCRLTextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static final String b = "-----BEGIN X509 CRL-----";
    private static final String c = "-----END X509 CRL-----";

    public static int command(String[] stringArray) {
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        if (stringArray[0].equals("hash")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            n = OracleCRLTextUI.hashName(stringArray2);
        } else if (stringArray[0].equals("upload")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            n = OracleCRLTextUI.upload(stringArray3);
        } else if (stringArray[0].equals("delete")) {
            String[] stringArray4 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray4, 0, stringArray4.length);
            n = OracleCRLTextUI.delete(stringArray4);
        } else if (stringArray[0].equals("list")) {
            String[] stringArray5 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray5, 0, stringArray5.length);
            n = OracleCRLTextUI.list(stringArray5);
        } else if (stringArray[0].equals("display")) {
            String[] stringArray6 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray6, 0, stringArray6.length);
            n = OracleCRLTextUI.display(stringArray6);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray7 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray7, 0, stringArray7.length);
            n = OracleCRLTextUI.createCRL(stringArray7);
        } else if (stringArray[0].equals("revoke")) {
            String[] stringArray8 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray8, 0, stringArray8.length);
            n = OracleCRLTextUI.revokeCertificate(stringArray8);
        } else if (stringArray[0].equals("verify")) {
            String[] stringArray9 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray9, 0, stringArray9.length);
            n = OracleCRLTextUI.verify(stringArray9);
        } else if (stringArray[0].equals("status")) {
            String[] stringArray10 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray10, 0, stringArray10.length);
            n = OracleCRLTextUI.revocationStatus(stringArray10);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        return n;
    }

    public static int createCRL(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        int n2 = 0;
        String string7 = null;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n2 = -1;
            return n2;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-crl")) {
                    boolean bl2;
                    if (!(bl2 = new File(string = stringArray[++i]).exists())) continue;
                    System.out.println(a.getString("PKI-05007"));
                    return -1;
                }
                if (stringArray[i].equals("-issuer")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuersissuer")) {
                    string5 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-nextupdate")) {
                    n = Integer.parseInt(stringArray[++i].trim());
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-sign_alg")) {
                    if (!SignatureAlgorithms.c(stringArray[++i])) {
                        System.out.println("Unsupported Signature Algorithm - " + stringArray[i]);
                        return -1;
                    }
                    string7 = stringArray[i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n2 = -1;
                return n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n2 = -1;
            return n2;
        }
        try {
            CRL cRL;
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string2, string3, bl);
            if (string7 != null) {
                oracleWallet.setCRLSignAlgorithm(string7);
            }
            if ((cRL = oracleWallet.createCRL(string4, string5, string6, n)) == null) {
                System.out.println("Could not create CRL.");
                n2 = -1;
                return n2;
            }
            byte[] byArray = cRL.getEncoded();
            String string8 = "-----BEGIN X509 CRL-----\n" + Utils.toBase64((byte[])byArray) + c + "\n";
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(new String(string8));
            fileWriter.close();
            System.out.println("Created CRL at : " + string);
        }
        catch (Exception exception) {
            System.out.println("Could not create CRL : " + exception.getLocalizedMessage());
            n2 = -1;
        }
        return n2;
    }

    public static int revokeCertificate(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n = 0;
        String string5 = null;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-wallet")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-sign_alg")) {
                    if (!SignatureAlgorithms.c(stringArray[++i])) {
                        System.out.println("Unsupported Signature Algorithm - " + stringArray[i]);
                        return -1;
                    }
                    string5 = stringArray[i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            InputStream inputStream;
            OracleWallet oracleWallet = OraclePKIGenFunc.openAWallet(string3, string4, bl);
            if (string5 != null) {
                oracleWallet.setCRLSignAlgorithm(string5);
            }
            try {
                inputStream = new URL(string2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            CRL cRL = OraclePKIGenFunc.readCRLAt(string);
            CRL cRL2 = oracleWallet.revokeCertificate(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), cRL);
            byte[] byArray = cRL2.getEncoded();
            String string6 = "-----BEGIN X509 CRL-----\n" + Utils.toBase64((byte[])byArray) + c + "\n";
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(new String(string6));
            fileWriter.close();
            System.out.println("Revoked certificate and updated the CRL at : " + string);
        }
        catch (Exception exception) {
            System.out.println("Could not revoke a certificate : " + exception.getLocalizedMessage());
            n = -1;
        }
        return n;
    }

    public static int verify(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            InputStream inputStream;
            try {
                inputStream = new URL(string2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            CRL cRL = OraclePKIGenFunc.readCRLAt(string);
            boolean bl = OracleWallet.verifyCRLSignature(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), cRL);
            if (bl) {
                System.out.println("Successfully verified CRL signature.");
            } else {
                System.out.println("Failed to Verify CRL signature.");
                n = -1;
            }
        }
        catch (Exception exception) {
            System.out.println("Could not verify CRL signature : " + exception.getLocalizedMessage());
            n = -1;
        }
        return n;
    }

    public static int revocationStatus(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-cert")) {
                    string2 = stringArray[++i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            InputStream inputStream;
            try {
                inputStream = new URL(string2).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string2);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = inputStream.read();
            while (n2 != -1) {
                byteArrayOutputStream.write((byte)n2);
                n2 = inputStream.read();
            }
            CRL cRL = OraclePKIGenFunc.readCRLAt(string);
            boolean bl = OracleWallet.getRevocationStatus(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), cRL);
            if (bl) {
                System.out.println("The certificate has been revoked.");
            } else {
                System.out.println("The certificate is not revoked.");
                n = -1;
            }
        }
        catch (Exception exception) {
            System.out.println("Failed with exception : " + exception.getLocalizedMessage());
            n = -1;
        }
        return n;
    }

    public static int hashName(String[] stringArray) {
        CRL cRL;
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        String string4 = null;
        boolean bl3 = false;
        int n2 = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n2 = -1;
            return n2;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-symlink")) {
                    ++i;
                    bl = true;
                    bl2 = false;
                    if (n == -1) {
                        n = 0;
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-copy")) {
                    ++i;
                    bl2 = true;
                    bl = false;
                    if (n == -1) {
                        n = 0;
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    n = 1;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n2 = -1;
                return n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n2 = -1;
            return n2;
        }
        Object var11_13 = null;
        try {
            cRL = OraclePKIGenFunc.readCRLAt(string);
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-05001") + string);
            n2 = -1;
            return n2;
        }
        String string5 = OraclePKIX509CrlFileStore.hashName(cRL.getIssuer());
        if (n != 0) {
            System.out.println(a.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
            System.out.println(a.getString("GEN_HASH_OUT") + string5);
        }
        try {
            n2 = OracleCRLTextUI.a(string2, cRL, string4, bl3);
        }
        catch (Exception exception) {
            n2 = -1;
            return n2;
        }
        if (bl2 || bl) {
            File file = new File(string3);
            if (!file.exists()) {
                System.out.println(a.getString("PKI-02006") + string3);
                n2 = -1;
                return n2;
            }
            if (!file.isDirectory()) {
                System.out.println(a.getString("PKI-02007") + string3);
                n2 = -1;
                return n2;
            }
            File file2 = new File(file, string5);
            if (bl) {
                Path path = Paths.get(string, new String[0]).toAbsolutePath().normalize();
                Path path2 = file2.toPath().toAbsolutePath().normalize();
                try {
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    if (Files.exists(path2, LinkOption.NOFOLLOW_LINKS)) {
                        Files.delete(path2);
                    }
                    Files.createSymbolicLink(path2, path, new FileAttribute[0]);
                }
                catch (Exception exception) {
                    System.out.println(a.getString("PKI-05005"));
                    exception.printStackTrace();
                    n2 = -1;
                    return n2;
                }
            }
            if (bl2) {
                try {
                    file2.createNewFile();
                    cRL.output((OutputStream)new FileOutputStream(file2));
                }
                catch (IOException iOException) {
                    System.out.println(a.getString("PKI-05002"));
                    n2 = -1;
                    return n2;
                }
            }
        }
        return n2;
    }

    public static int upload(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "389";
        char[] cArray = null;
        boolean bl = false;
        String string6 = null;
        boolean bl2 = false;
        InputStream inputStream = null;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    try {
                        inputStream = new URL(string).openStream();
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        try {
                            inputStream = new FileInputStream(string);
                            continue;
                        }
                        catch (IOException iOException) {
                            System.out.println("File not found : " + string);
                            n = -1;
                            return n;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println("Found valid URL but invalid CRL there.");
                        n = -1;
                        return n;
                    }
                }
                if (stringArray[i].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i].indexOf(58)) > 0) {
                        string2 = stringArray[i].substring(0, n2);
                        string5 = stringArray[i].substring(n2 + 1);
                        continue;
                    }
                    string2 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-ldappwd")) {
                    cArray = stringArray[++i].toCharArray();
                    continue;
                }
                if (stringArray[i].equals("-user")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string6 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        if (cArray == null) {
            cArray = OraclePKIGenFunc.getPassword("LDAP_PASSWORD_PROMPT");
        }
        try {
            char[] cArray2 = null;
            if (string6 != null) {
                cArray2 = string6.toCharArray();
            }
            OracleCRL.uploadCRL(string3, cArray2, bl2, inputStream, string2, string5, string4, cArray, bl);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Could not upload CRL to the directory.");
            n = -1;
        }
        return n;
    }

    private static BasicAttributes a(String string) {
        BasicAttribute basicAttribute = new BasicAttribute("objectclass");
        basicAttribute.add("orclPKICRL");
        basicAttribute.add("cRLDistributionPoint");
        basicAttribute.add("top");
        BasicAttributes basicAttributes = new BasicAttributes(true);
        basicAttributes.put(basicAttribute);
        basicAttributes.put(new BasicAttribute("x509issuer", string));
        return basicAttributes;
    }

    public static int list(String[] stringArray) {
        Object var1_1 = null;
        String string = null;
        Object var3_3 = null;
        Object var4_4 = null;
        String string2 = "389";
        boolean bl = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i].indexOf(58)) > 0) {
                        string = stringArray[i].substring(0, n2);
                        string2 = stringArray[i].substring(n2 + 1);
                        continue;
                    }
                    string = stringArray[i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            InitialLdapContext initialLdapContext = null;
            try {
                initialLdapContext = ConnectionUtil.getDefaultDirCtx(string, string2, "", "");
            }
            catch (Exception exception) {
                initialLdapContext = ConnectionUtil.getSSLDirCtx(string, string2, "", "");
            }
            BasicAttributes basicAttributes = OracleCRLTextUI.a(null);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
            if (!namingEnumeration.hasMore()) {
                System.out.println(a.getString("CRLS_NOT_PRESENT") + string + ":" + string2);
                n = -1;
                return n;
            }
            System.out.println();
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                System.out.println(a.getString("GEN_ISSUER_OUT") + attributes.get("x509issuer").get());
                System.out.println(a.getString("GEN_LOCATION_OUT") + "ldap://" + string + ":" + string2 + "/" + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext" + "?certificaterevocationlist?one?x509issuer=" + attributes.get("x509issuer").get());
                System.out.println();
            }
        }
        catch (javax.naming.AuthenticationException authenticationException) {
            System.out.println(a.getString("PKI-07001"));
            n = -1;
            return n;
        }
        catch (NameNotFoundException nameNotFoundException) {
            System.out.println(a.getString("PKI-07002") + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext");
            n = -1;
            return n;
        }
        catch (NoPermissionException noPermissionException) {
            System.out.println(a.getString("PKI-07003"));
            n = -1;
            return n;
        }
        catch (NamingException namingException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + namingException);
            n = -1;
            return n;
        }
        return n;
    }

    public static int delete(String[] stringArray) {
        String string = null;
        String string2 = null;
        String string3 = "389";
        String string4 = null;
        boolean bl = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-issuer")) {
                    string4 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-ldap")) {
                    int n2;
                    if ((n2 = stringArray[++i].indexOf(58)) > 0) {
                        string = stringArray[i].substring(0, n2);
                        string3 = stringArray[i].substring(n2 + 1);
                        continue;
                    }
                    string = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-user")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            InitialLdapContext initialLdapContext = ConnectionUtil.getSSLDirCtx(string, string3, string2, new String(OraclePKIGenFunc.getPassword("LDAP_PASSWORD_PROMPT")));
            BasicAttributes basicAttributes = OracleCRLTextUI.a(string4);
            NamingEnumeration<SearchResult> namingEnumeration = initialLdapContext.search("cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext", (Attributes)basicAttributes);
            if (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                String string5 = searchResult.getName() + "," + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext";
                BasicAttributes basicAttributes2 = new BasicAttributes();
                initialLdapContext.unbind(string5);
                if (bl) {
                    System.out.println(a.getString("LDAP_CRL_DELETED") + string5);
                }
            } else if (bl) {
                System.out.println(a.getString("PKI-05004") + string4);
            }
        }
        catch (javax.naming.AuthenticationException authenticationException) {
            System.out.println(a.getString("PKI-07001"));
            n = -1;
            return n;
        }
        catch (NameNotFoundException nameNotFoundException) {
            System.out.println(a.getString("PKI-07002") + "cn=CRLValidation,cn=Validation,cn=PKI,cn=Products,cn=OracleContext");
            n = -1;
        }
        catch (NoPermissionException noPermissionException) {
            System.out.println(a.getString("PKI-07003"));
            n = -1;
            return n;
        }
        catch (NamingException namingException) {
            System.out.println(a.getString("GEN_UNKNOWN_ERROR") + namingException);
            n = -1;
            return n;
        }
        return n;
    }

    public static int display(String[] stringArray) {
        CRL cRL;
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        boolean bl3 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-crl")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-complete")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl3 = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(a.getString("CRL_USE_STRING"));
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(a.getString("CRL_USE_STRING"));
            n = -1;
            return n;
        }
        Object var10_12 = null;
        try {
            cRL = OraclePKIGenFunc.readCRLAt(string);
        }
        catch (ServiceUnavailableException serviceUnavailableException) {
            System.out.println("Please check the port, could not display CRL for ssl-port.");
            n = -1;
            return n;
        }
        catch (Exception exception) {
            System.out.println(a.getString("PKI-05001") + string);
            n = -1;
            return n;
        }
        if (bl && bl2) {
            bl = false;
        }
        System.out.println(a.getString("GEN_ISSUER_OUT") + cRL.getIssuer());
        System.out.println(a.getString("GEN_DATE_OUT") + cRL.getDate());
        System.out.println(a.getString("CRL_NEXT_DATE_OUT") + cRL.getNextDate());
        if (bl) {
            ArrayList arrayList = null;
            X509ExtensionSet x509ExtensionSet = cRL.getExtensionSet();
            if (x509ExtensionSet != null) {
                System.out.println("\nCRL Extensions:");
                arrayList = x509ExtensionSet.getExtensionsAsList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.out.println("    " + arrayList.get(i).toString());
                }
            }
            if (!cRL.revokedSerialNos().hasMoreElements()) {
                System.out.println("\nThere are no Revoked Certificates.");
            } else {
                Enumeration enumeration = cRL.revokedSerialNos();
                System.out.println("\nRevoked Certificates:");
                while (enumeration.hasMoreElements()) {
                    BigInteger bigInteger = new BigInteger(enumeration.nextElement().toString());
                    byte[] byArray = bigInteger.toByteArray();
                    System.out.print("  Serial Number: ");
                    for (int i = 0; i < byArray.length; ++i) {
                        System.out.print(Integer.toHexString(byArray[i] & 0xFF));
                        if (i >= byArray.length - 1) continue;
                        System.out.print(":");
                    }
                    System.out.println("\n    Revocation Date: " + cRL.revocationDate(bigInteger).toString());
                }
            }
        }
        try {
            n = OracleCRLTextUI.a(string2, cRL, string3, bl3);
        }
        catch (Exception exception) {
            n = -1;
            return n;
        }
        return n;
    }

    private static int a(CRL cRL, OracleWallet oracleWallet) throws AuthenticationException {
        OraclePKIPrincipalImpl oraclePKIPrincipalImpl = new OraclePKIPrincipalImpl(cRL.getIssuer());
        KeyStore keyStore = null;
        Enumeration<String> enumeration = null;
        int n = 0;
        if (!cRL.verifyDate()) {
            throw new AuthenticationException("CRL expired/not yet valid");
        }
        try {
            keyStore = oracleWallet.getKeyStore();
            enumeration = keyStore.aliases();
        }
        catch (Exception exception) {
            throw new AuthenticationException();
        }
        while (enumeration.hasMoreElements()) {
            try {
                Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
                if (!(certificate instanceof X509Certificate) || !oraclePKIPrincipalImpl.equals(((X509Certificate)certificate).getSubjectDN())) continue;
                if (certificate.getPublicKey().getAlgorithm().equals("RSA")) {
                    cRL.setPublicKey((PublicKey)new RSAPublicKey(certificate.getPublicKey().getEncoded()));
                } else {
                    if (!certificate.getPublicKey().getAlgorithm().equals("EC")) continue;
                    cRL.setPublicKey((PublicKey)new ECPublicKey(certificate.getPublicKey().getEncoded()));
                }
                if (!cRL.verify()) continue;
                return n;
            }
            catch (KeyStoreException keyStoreException) {
                break;
            }
            catch (IOException iOException) {
                // empty catch block
                break;
            }
        }
        throw new AuthenticationException(a.getString("PKI-05006"));
    }

    private static int a(String string, CRL cRL, String string2, boolean bl) throws Exception {
        int n = 0;
        if (string != null) {
            OracleWallet oracleWallet;
            try {
                oracleWallet = OraclePKIGenFunc.openAWallet(string, string2, bl);
            }
            catch (Exception exception) {
                System.out.println(a.getString("PKI-02003") + string);
                throw exception;
            }
            try {
                OracleCRLTextUI.a(cRL, oracleWallet);
                System.out.println(a.getString("CRL_VERIFY_OK"));
            }
            catch (AuthenticationException authenticationException) {
                System.out.println(a.getString("PKI-05003"));
                throw authenticationException;
            }
        }
        return n;
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "oracle.security.pki");
    }
}

