/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ResourceBundle;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;

public class OracleSecretStoreTextUI {
    private static char[] a = null;
    private static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");

    public static void main(String[] stringArray) {
        Object object;
        int n;
        String string = null;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-nologo") && !stringArray[n].equals("-use_jce") && !stringArray[n].equals("-jsafe") && !stringArray[n].equals("-use_jce_only") && !stringArray[n].equals("-fips140_mode") && !stringArray[n].equals("-compat_v11")) continue;
            if (stringArray[n].equals("-nologo")) {
                bl = true;
            } else if (stringArray[n].equals("-use_jce")) {
                TransitionMode.enableJCEUse();
            } else if (stringArray[n].equals("-jsafe")) {
                TransitionMode.enableJCEUse();
                try {
                    JCEUtil.registerJsafeJCE();
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    System.out.println("Unable to register Crypto-J JsafeJCE provider");
                    n2 = 1;
                    System.exit(n2);
                }
            } else if (stringArray[n].equals("-use_jce_only")) {
                TransitionMode.disableOSDTCrypto();
            } else if (stringArray[n].equals("-fips140_mode")) {
                TransitionMode.enableFIPS140Mode();
            } else if (stringArray[n].equals("-compat_v11")) {
                bl2 = true;
            }
            int n3 = stringArray.length - (n + 1);
            object = new String[stringArray.length - 1];
            if (stringArray.length > 1) {
                System.arraycopy(stringArray, 0, object, 0, n);
                System.arraycopy(stringArray, n + 1, object, n, n3);
            }
            stringArray = object;
            --n;
        }
        if (!bl) {
            System.out.println(OraclePKIGenFunc.copyrightVersionBanner("Oracle Secret Store Tool"));
            System.out.println();
        }
        if (stringArray.length == 0 || stringArray[0].equals("-help")) {
            System.out.println(b.getString("USE_STRING"));
            if (stringArray.length < 2) {
                System.exit(0);
            }
        }
        if (TransitionMode.isFIPS140ModeEnabled()) {
            if (bl2) {
                System.out.println(b.getString("PKI-01005"));
                n2 = 1;
                System.exit(n2);
            }
            try {
                JCEUtil.getJCEProvider();
            }
            catch (GeneralSecurityException generalSecurityException) {
                System.out.println("Unable to get FIPS 140 cryptographic module: " + generalSecurityException.getMessage());
                n2 = 1;
                System.exit(n2);
            }
            try {
                if (!JCEUtil.isUnlimitedStrengthCryptoEnabled()) {
                    System.out.println("Unlimited Strength policy files are not installed; they are required in FIPS 140 mode");
                    n2 = 1;
                    System.exit(n2);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("Unable to perform crypto operations " + noSuchAlgorithmException.getMessage());
                n2 = 1;
                System.exit(n2);
            }
        }
        n = 0;
        try {
            for (n = 0; n < stringArray.length && !stringArray[n].equals("-wrl"); ++n) {
            }
            if (n + 1 >= stringArray.length) {
                System.out.println(b.getString("NO_WRL_ERROR"));
                System.out.println(b.getString("USE_STRING"));
                System.exit(-1);
            }
            string = stringArray[n + 1];
            OraclePKIDebug.a("main: Using wallet in " + string);
            OracleWallet oracleWallet = new OracleWallet();
            for (n = 0; n < stringArray.length; ++n) {
                OracleSecretStore oracleSecretStore;
                Object object2;
                Object object3;
                Object object4;
                if (stringArray[n].equals("-wrl")) {
                    ++n;
                    continue;
                }
                if (stringArray[n].equals("-create")) {
                    a = OraclePKIGenFunc.getCreatePassword();
                    OraclePKIDebug.a("main: Creating wallet in " + string);
                    if (bl2) {
                        oracleWallet.create(a, (byte)4);
                    } else {
                        oracleWallet.create(a);
                    }
                    if (oracleWallet.exists(string)) {
                        System.out.println(b.getString("PKI-02001") + string);
                        continue;
                    }
                    if (bl2) {
                        oracleWallet.saveAs(string, (byte)4);
                        oracleWallet.saveSSO((byte)4);
                        continue;
                    }
                    oracleWallet.saveAs(string);
                    oracleWallet.saveSSO();
                    continue;
                }
                if (stringArray[n].equals("-createSSO")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Creating SSO wallet in " + string);
                    oracleWallet.open(string, a);
                    if (bl2) {
                        oracleWallet.saveSSO((byte)4);
                        continue;
                    }
                    oracleWallet.saveSSO();
                    continue;
                }
                if (stringArray[n].equals("-createLSSO")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Creating LSSO wallet in " + string);
                    oracleWallet.open(string, a);
                    if (bl2) {
                        oracleWallet.saveLSSO((byte)4);
                        continue;
                    }
                    oracleWallet.saveLSSO();
                    continue;
                }
                if (stringArray[n].equals("-createALO")) {
                    OraclePKIDebug.a("main: Creating ALO wallet in " + string);
                    if (bl2) {
                        oracleWallet.createSSO((byte)4);
                        oracleWallet.saveAs(string, (byte)4);
                        continue;
                    }
                    oracleWallet.createSSO();
                    oracleWallet.saveAs(string);
                    continue;
                }
                if (stringArray[n].equals("-deleteSSO")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Deleting SSO wallet for " + string);
                    oracleWallet.open(string, a);
                    oracleWallet.deleteSSOWallet();
                    continue;
                }
                if (stringArray[n].equals("-delete")) {
                    OracleSecretStoreTextUI.a();
                    OraclePKIDebug.a("main: Deleting  wallet in " + string);
                    oracleWallet.open(string, a);
                    oracleWallet.deleteWallet();
                    continue;
                }
                if (stringArray[n].equals("-list")) {
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    OraclePKIDebug.a("main: Listing Identifiers in " + string);
                    object = oracleWallet.getSecretStore().a();
                    System.out.println(b.getString("ENTRIES_LIST"));
                    while (object.hasMoreElements()) {
                        System.out.println(object.nextElement());
                    }
                    continue;
                }
                if (stringArray[n].equals("-listUnsorted")) {
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    OraclePKIDebug.a("main: Listing Identifiers in " + string);
                    object = oracleWallet.getSecretStore().internalAliasesU();
                    System.out.println(b.getString("ENTRIES_LIST"));
                    while (object.hasMoreElements()) {
                        System.out.println(object.nextElement());
                    }
                    continue;
                }
                if (stringArray[n].equals("-viewEntry")) {
                    object = stringArray[++n];
                    OraclePKIDebug.a("main: Contents of entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object4 = oracleWallet.getSecretStore();
                    object3 = ((OracleSecretStore)object4).getSecret((String)object);
                    if (object3 == null) {
                        throw new OracleSecretStoreException(b.getString("PKI-03002") + (String)object);
                    }
                    System.out.println((String)object + " = " + new String((char[])object3));
                    continue;
                }
                if (stringArray[n].equals("-createEntry")) {
                    object = stringArray[++n];
                    try {
                        object4 = stringArray[n + 1].toCharArray();
                        ++n;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object4 = OracleSecretStoreTextUI.b();
                    }
                    OraclePKIDebug.a("main: Create entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object3 = oracleWallet.getSecretStore();
                    if (((OracleSecretStore)object3).containsAlias((String)object)) {
                        throw new OracleSecretStoreException(b.getString("PKI-03001") + (String)object);
                    }
                    ((OracleSecretStore)object3).setSecret((String)object, (char[])object4);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object3, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object3);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-modifyEntry")) {
                    object = stringArray[++n];
                    try {
                        object4 = stringArray[n + 1].toCharArray();
                        ++n;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object4 = OracleSecretStoreTextUI.b();
                    }
                    OraclePKIDebug.a("main: Modify entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object3 = oracleWallet.getSecretStore();
                    if (!((OracleSecretStore)object3).containsAlias((String)object)) {
                        throw new OracleSecretStoreException(b.getString("PKI-03002") + (String)object);
                    }
                    ((OracleSecretStore)object3).setSecret((String)object, (char[])object4);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object3, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object3);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-deleteEntry")) {
                    object = stringArray[++n];
                    OraclePKIDebug.a("main: Contents of entry " + (String)object + " in " + string);
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object4 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object4).deleteSecret((String)object);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object4, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object4);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-createCredential")) {
                    object = stringArray[++n].toCharArray();
                    object4 = stringArray[n + 1].toCharArray();
                    try {
                        object3 = stringArray[n + 2].toCharArray();
                        n += 2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        ++n;
                        object3 = OracleSecretStoreTextUI.b();
                    }
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Create credential " + new String((char[])object) + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object2 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object2).createCredential((char[])object, (char[])object4, (char[])object3);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object2, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object2);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-modifyCredential")) {
                    object = stringArray[++n].toCharArray();
                    object4 = stringArray[n + 1].toCharArray();
                    try {
                        object3 = stringArray[n + 2].toCharArray();
                        n += 2;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        ++n;
                        object3 = OracleSecretStoreTextUI.b();
                    }
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Modify credential " + new String((char[])object) + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object2 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object2).modifyCredential((char[])object, (char[])object4, (char[])object3);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object2, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object2);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-deleteCredential")) {
                    object = stringArray[++n].toCharArray();
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Delete credential " + new String((char[])object) + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object4 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object4).deleteCredential((char[])object);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object4, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object4);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-listCredential")) {
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    OraclePKIDebug.a("main: List credential  in " + string);
                    object = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object).listCredential();
                    continue;
                }
                if (stringArray[n].equals("-createUserCredential")) {
                    object = stringArray[++n];
                    object4 = stringArray[++n];
                    object3 = stringArray[++n];
                    try {
                        object2 = stringArray[++n].toCharArray();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object2 = OracleSecretStoreTextUI.b();
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    oracleSecretStore = oracleWallet.getSecretStore();
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Create credential for map " + (String)object + "key" + (String)object4 + " in " + string);
                    }
                    oracleSecretStore.createUserCredential((String)object, (String)object4, (String)object3, (char[])object2);
                    if (bl2) {
                        oracleWallet.setSecretStore(oracleSecretStore, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore(oracleSecretStore);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-modifyUserCredential")) {
                    object = stringArray[++n];
                    object4 = stringArray[++n];
                    object3 = stringArray[++n];
                    try {
                        object2 = stringArray[++n].toCharArray();
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object2 = OracleSecretStoreTextUI.b();
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    oracleSecretStore = oracleWallet.getSecretStore();
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Modify credential for map " + (String)object + "key" + (String)object4 + " in " + string);
                    }
                    oracleSecretStore.modifyUserCredential((String)object, (String)object4, (String)object3, (char[])object2);
                    if (bl2) {
                        oracleWallet.setSecretStore(oracleSecretStore, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore(oracleSecretStore);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-deleteUserCredential")) {
                    object = stringArray[++n];
                    object4 = stringArray[++n];
                    if (OraclePKIDebug.getDebugFlag()) {
                        OraclePKIDebug.a("main: Delete credential  for map " + (String)object + "key" + (String)object4 + " in " + string);
                    }
                    OracleSecretStoreTextUI.a(string, oracleWallet);
                    object3 = oracleWallet.getSecretStore();
                    ((OracleSecretStore)object3).deleteUserCredential((String)object, (String)object4);
                    if (bl2) {
                        oracleWallet.setSecretStore((OracleSecretStore)object3, (byte)4);
                        oracleWallet.save((byte)4);
                        continue;
                    }
                    oracleWallet.setSecretStore((OracleSecretStore)object3);
                    oracleWallet.save();
                    continue;
                }
                if (stringArray[n].equals("-help")) {
                    System.out.println(b.getString("USE_STRING"));
                    continue;
                }
                System.out.println("test invalid");
                System.out.println(b.getString("INVALID_COMMAND_ERROR") + stringArray[n]);
                n2 = -1;
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                System.out.println(iOException.getMessage());
                n2 = -1;
            } else {
                System.out.println(b.getString("UNKNOWN_ERROR") + iOException);
                n2 = -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b.getString("PKI-01001") + stringArray[n - 1]);
            n2 = -1;
        }
        catch (OracleSecretStoreException oracleSecretStoreException) {
            System.out.println(b.getString("SECRET_STORE_ERROR") + oracleSecretStoreException);
            n2 = -1;
        }
        System.exit(n2);
    }

    private static void a(String string, OracleWallet oracleWallet) throws OracleSecretStoreException, IOException {
        boolean bl = false;
        try {
            oracleWallet.open(string, null);
            bl = oracleWallet.isAutoLoginOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!bl) {
            OracleSecretStoreTextUI.a();
            oracleWallet.open(string, a);
        }
    }

    private static void a() {
        if (a == null) {
            a = OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT");
        }
    }

    private static char[] b() {
        System.out.print(b.getString("SECRET_MISSING") + "\n");
        return OraclePKIGenFunc.getSecret();
    }
}

