/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.core.ECPublicKey;
import oracle.security.crypto.core.MD5;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SHA;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIECPublicKey;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIRSAPublicKey;

public final class OraclePKIX509CertImpl
extends X509Certificate {
    private final X509 a;

    public OraclePKIX509CertImpl(X509 x509) {
        this.a = x509;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.a.getNotAfterDate().compareTo(date) < 0) {
            OraclePKIDebug.a("Certificate expired on " + this.a.getNotAfterDate());
            throw new CertificateExpiredException();
        }
        if (this.a.getNotBeforeDate().compareTo(date) > 0) {
            OraclePKIDebug.a("Certificate not valid until " + this.a.getNotBeforeDate());
            throw new CertificateNotYetValidException();
        }
    }

    @Override
    public int getVersion() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getVersion();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return 0;
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.a.getSerialNo();
    }

    public String getHexSerialNumber() {
        return this.a(this.a.getSerialNo().toByteArray());
    }

    @Override
    public Principal getIssuerDN() {
        return new OraclePKIPrincipalImpl(this.a.getIssuer());
    }

    @Override
    public Principal getSubjectDN() {
        return new OraclePKIPrincipalImpl(this.a.getSubject());
    }

    @Override
    public Date getNotBefore() {
        return this.a.getNotBeforeDate();
    }

    @Override
    public Date getNotAfter() {
        return this.a.getNotAfterDate();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getTBSCertificate();
        }
        catch (Throwable throwable) {
            throw new CertificateEncodingException();
        }
    }

    @Override
    public byte[] getSignature() {
        try {
            return this.a.getSigBytes();
        }
        catch (SignatureException signatureException) {
            return null;
        }
    }

    @Override
    public String getSigAlgName() {
        return this.a.getSigAlgString();
    }

    @Override
    public String getSigAlgOID() {
        return this.a.getSigAlgOID().toStringCompact();
    }

    @Override
    public byte[] getSigAlgParams() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getSigAlgParams();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getIssuerUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getSubjectUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        try {
            KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.a.getExtension(PKIX.id_ce_keyUsage);
            if (keyUsageExtension == null) {
                return null;
            }
            return new boolean[]{keyUsageExtension.hasUsageFlag(0), keyUsageExtension.hasUsageFlag(1), keyUsageExtension.hasUsageFlag(2), keyUsageExtension.hasUsageFlag(3), keyUsageExtension.hasUsageFlag(4), keyUsageExtension.hasUsageFlag(5), keyUsageExtension.hasUsageFlag(6), keyUsageExtension.hasUsageFlag(7), keyUsageExtension.hasUsageFlag(8)};
        }
        catch (ClassCastException classCastException) {
            System.out.println("Error Msg in getKeyUsage()  is :  " + classCastException.getMessage());
            classCastException.printStackTrace();
            return null;
        }
    }

    @Override
    public int getBasicConstraints() {
        BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.a.getExtension(PKIX.id_ce_basicConstraints);
        if (basicConstraintsExtension == null) {
            return -1;
        }
        if (!basicConstraintsExtension.getCA()) {
            return -1;
        }
        BigInteger bigInteger = basicConstraintsExtension.getPathLen();
        if (bigInteger == null) {
            return Integer.MAX_VALUE;
        }
        return bigInteger.intValue();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.a.getEncoded();
    }

    public String getMD5Digest() throws CertificateEncodingException {
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = null;
        if (TransitionMode.isJCEUseEnabled()) {
            try {
                MessageDigest messageDigest = JCEUtil.getMessageDigestInstance((String)"MD5");
                byArray2 = messageDigest.digest(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (OraclePKIDebug.getDebugFlag()) {
                    noSuchAlgorithmException.printStackTrace();
                }
            }
        } else {
            MD5 mD5 = new MD5();
            byArray2 = mD5.computeDigest(byArray);
        }
        return this.a(byArray2);
    }

    public String getSHADigest() throws CertificateEncodingException {
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = null;
        if (TransitionMode.isJCEUseEnabled()) {
            try {
                MessageDigest messageDigest = JCEUtil.getMessageDigestInstance((String)"SHA-1");
                byArray2 = messageDigest.digest(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (OraclePKIDebug.getDebugFlag()) {
                    noSuchAlgorithmException.printStackTrace();
                }
            }
        } else {
            SHA sHA = new SHA();
            byArray2 = sHA.computeDigest(byArray);
        }
        return this.a(byArray2);
    }

    public String getSHA256Digest() throws CertificateEncodingException {
        byte[] byArray;
        block2: {
            byte[] byArray2 = this.getEncoded();
            byArray = null;
            try {
                MessageDigest messageDigest = JCEUtil.getMessageDigestInstance((String)"SHA-256");
                byArray = messageDigest.digest(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (!OraclePKIDebug.getDebugFlag()) break block2;
                noSuchAlgorithmException.printStackTrace();
            }
        }
        return this.a(byArray);
    }

    String a(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        n = byArray.length * 2 + (byArray.length - 1);
        byte[] byArray2 = new byte[n];
        String string = "0123456789ABCDEF";
        byte[] byArray3 = string.getBytes();
        String string2 = ":";
        byte[] byArray4 = string2.getBytes();
        for (n2 = 0; n2 < n - 2; n2 += 3) {
            by = byArray[n2 / 3];
            byArray2[n2] = byArray3[(by & 0xF0) >> 4];
            byArray2[n2 + 1] = byArray3[by & 0xF];
            byArray2[n2 + 2] = byArray4[0];
        }
        by = byArray[n / 3];
        n2 = n - 2;
        byArray2[n2] = byArray3[(by & 0xF0) >> 4];
        byArray2[n2 + 1] = byArray3[by & 0xF];
        return new String(byArray2);
    }

    @Override
    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        throw new CertificateException("Not implemented");
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, java.security.SignatureException {
        throw new CertificateException("Not implemented");
    }

    @Override
    public String toString() {
        return this.a.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        oracle.security.crypto.core.PublicKey publicKey = this.a.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            return new OraclePKIRSAPublicKey((RSAPublicKey)publicKey);
        }
        if (publicKey instanceof ECPublicKey) {
            return new OraclePKIECPublicKey((ECPublicKey)publicKey);
        }
        return null;
    }

    public int getPublicKeyLength() {
        oracle.security.crypto.core.PublicKey publicKey = this.a.getPublicKey();
        if (publicKey instanceof RSAPublicKey || publicKey instanceof ECPublicKey) {
            return publicKey.getBitLength();
        }
        return 0;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.a.getExtensionSet().hasUnrecognizedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    public Set getNonCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = JCEUtil.getCertificateFactoryInstance((String)"X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    @Override
    public byte[] getExtensionValue(String string) {
        X509Extension x509Extension = this.a.getExtension(new ASN1ObjectID(string));
        if (x509Extension == null) {
            OraclePKIDebug.a("No Extension present");
            return null;
        }
        byte[] byArray = x509Extension.getValue();
        if (byArray != null && byArray.length > 0) {
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
            try {
                ASN1OctetString.outputValue((OutputStream)unsyncByteArrayOutputStream, (byte[])byArray);
            }
            catch (IOException iOException) {
                OraclePKIDebug.a("Error in getting ASN output of Extension");
                return null;
            }
            return unsyncByteArrayOutputStream.toByteArray();
        }
        OraclePKIDebug.a("Error in getting byte array from  Extension");
        return null;
    }

    public X509 getX509() {
        return this.a;
    }

    public String getPublicKeyType() {
        oracle.security.crypto.core.PublicKey publicKey = this.a.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            return "RSA";
        }
        if (publicKey instanceof ECPublicKey) {
            return "EC";
        }
        return "";
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() {
        ArrayList<List> arrayList = null;
        try {
            SubjectAltNameExtension subjectAltNameExtension = (SubjectAltNameExtension)this.a.getExtension(PKIX.id_ce_subjectAltName);
            if (subjectAltNameExtension == null) {
                return null;
            }
            arrayList = new ArrayList<List>();
            for (GeneralName generalName : subjectAltNameExtension.getSubjectAltName()) {
                arrayList.add(generalName.getTypeAndValue());
            }
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
        }
        return arrayList;
    }
}

