/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.util.Date;
import java.util.ResourceBundle;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.pki.util.SignatureAlgorithms;

public class OracleCertTextUI {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static String b = "cert:\ndisplay [-cert [url|filename]] <-summary> <-complete>\ncreate [-wallet [wallet]] [-request [url|filename]] [-cert [filename]]\n       [-serial_file <file_loc> | -serial_num <serial_num>]\n       [-validity [days]] | [-valid_from [[mm/dd/yyyy]|[yymmdd-hhmmss-z]] -valid_until [[mm/dd/yyyy]|[yymmdd-hhmmss-z]]]\n       <-summary> [-pwd <pwd>] [-sign_alg <md5|sha1|sha256|sha384|sha512|ecdsasha1|ecdsasha256|ecdsasha384|ecdsasha512>]\n       [-issuer_subject_dn <subject_dn_of_issuer_certificate>]\n       [-issuer_issuer_dn <issuer_dn_of_issuer_certificate>]\n       [-issuer_serial_num <serial_number_of_issuer_certificate>]\nhelp\n";

    public static int command(String[] stringArray) {
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (stringArray[0].equals("help")) {
            System.out.println(b);
            n = -1;
            return n;
        }
        if (stringArray[0].equals("display")) {
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            n = OracleCertTextUI.display(stringArray2);
        } else if (stringArray[0].equals("create")) {
            String[] stringArray3 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray3, 0, stringArray3.length);
            n = OracleCertTextUI.create(stringArray3);
        } else {
            System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[0]);
            System.out.println(b);
            n = -1;
            return n;
        }
        return n;
    }

    public static int create(String[] stringArray) {
        String string = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Date date = null;
        Date date2 = null;
        String string7 = null;
        boolean bl2 = false;
        String string8 = null;
        String string9 = null;
        BigInteger bigInteger = null;
        boolean bl3 = false;
        int n = 0;
        int n2 = 0;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        BigInteger bigInteger2 = null;
        if (stringArray.length == 0) {
            System.out.println(b);
            n2 = -1;
            return n2;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-cert")) {
                    boolean bl4;
                    if (!(bl4 = new File(string = stringArray[++i]).exists())) continue;
                    System.out.println(a.getString("PKI-04020"));
                    return -1;
                }
                if (stringArray[i].equals("-request")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-wallet")) {
                    string3 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-validity")) {
                    string4 = stringArray[++i];
                    try {
                        n = Integer.parseInt(string4);
                        if (n <= 0) {
                            throw new NumberFormatException("");
                        }
                        if (n <= 182500) continue;
                        System.out.println("Validity should not be more than 182500 days.");
                        n2 = -1;
                        return n2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Validity must be a positive integer");
                        n2 = -1;
                        return n2;
                    }
                }
                if (stringArray[i].equals("-valid_from")) {
                    if ((date = OraclePKIGenFunc.CalculateDateFromString(string5 = stringArray[++i], "-valid_from")) != null) continue;
                    n2 = -1;
                    return n2;
                }
                if (stringArray[i].equals("-valid_until")) {
                    if ((date2 = OraclePKIGenFunc.CalculateDateFromString(string6 = stringArray[++i], "-valid_until")) != null) continue;
                    n2 = -1;
                    return n2;
                }
                if (stringArray[i].equals("-issuer_subject_dn")) {
                    string11 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer_issuer_dn")) {
                    string11 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-issuer_serial_num")) {
                    String string13 = stringArray[++i];
                    try {
                        bigInteger2 = OraclePKIGenFunc.calculateSerialNumber(string13);
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println(a.getString("PKI-04022"));
                        n2 = -1;
                        return n2;
                    }
                }
                if (stringArray[i].equals("-summary")) {
                    bl = true;
                    continue;
                }
                if (stringArray[i].equals("-pwd")) {
                    string7 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-obpwd")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-serial_file")) {
                    if ((bigInteger = OraclePKIGenFunc.getSerialNum(string8 = stringArray[++i])) == null) {
                        n2 = -1;
                        return n2;
                    }
                    bigInteger = bigInteger.add(BigInteger.ONE);
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-serial_num")) {
                    string9 = stringArray[++i];
                    try {
                        bigInteger = OraclePKIGenFunc.calculateSerialNumber(string9);
                    }
                    catch (Exception exception) {
                        System.out.println(a.getString("PKI-04022"));
                        n2 = -1;
                        return n2;
                    }
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-sign_alg")) {
                    if (!SignatureAlgorithms.c(stringArray[++i])) {
                        System.out.println("Unsupported Signature Algorithm - " + stringArray[i]);
                        return -1;
                    }
                    string10 = stringArray[i];
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n2 = -1;
                return n2;
            }
            if (string == null) {
                System.out.println("\nError :Unable to save certificate at null\n");
                System.out.println("Specify Ceritificate Path \n");
                return -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n2 = -1;
            return n2;
        }
        if (bl3 && bigInteger == null) {
            System.out.println("Serial number should not be null....");
            n2 = -1;
            return n2;
        }
        if (!OraclePKIGenFunc.ValidateExpiryPeriodEntry(string5, string6, string4)) {
            System.out.println("Please specify [-validity] alone OR both [-valid_from] and [-valid_until]");
            n2 = -1;
            return n2;
        }
        OracleWallet oracleWallet = null;
        KeyStore keyStore = null;
        CertificateRequest certificateRequest = null;
        try {
            oracleWallet = OraclePKIGenFunc.openAWallet(string3, string7, bl2);
            keyStore = oracleWallet.getKeyStore();
        }
        catch (Exception exception) {
            try {
                oracleWallet = new OracleWallet();
                oracleWallet.open(string3, null);
                keyStore = oracleWallet.getKeyStore();
                if (oracleWallet.isAutoLoginOnly()) {
                    System.out.println("Found Auto Login Only (ALO) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                } else {
                    System.out.println("Found Auto Login (AL) wallet.");
                    System.out.println("Option -pwd is not recognized and ignored.");
                }
            }
            catch (Exception exception2) {
                System.out.println(OraclePKIGenFunc.a(a.getString("PKI-02003") + string3, exception2));
                if (OraclePKIDebug.getDebugFlag()) {
                    exception2.printStackTrace();
                }
                n2 = -1;
                return n2;
            }
        }
        try {
            certificateRequest = OraclePKIGenFunc.readCertRequestAt(string2);
        }
        catch (Exception exception) {
            System.out.println("Unable to read certificate request at " + string2);
            n2 = -1;
            return n2;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = null;
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            if (string10 != null) {
                oracleWallet.setCertSignAlgorithm(string10);
            }
            byteArrayInputStream = n == 0 ? (!bl3 ? (ByteArrayInputStream)oracleWallet.createCert((InputStream)byteArrayInputStream2, date, date2, string11, string12, bigInteger2) : (ByteArrayInputStream)oracleWallet.createCert(byteArrayInputStream2, date, date2, bigInteger, string11, string12, bigInteger2)) : (!bl3 ? (ByteArrayInputStream)oracleWallet.createCert(byteArrayInputStream2, n, string11, string12, bigInteger2) : (ByteArrayInputStream)oracleWallet.createCert((InputStream)byteArrayInputStream2, n, bigInteger, string11, string12, bigInteger2));
            int n3 = byteArrayInputStream.available();
            byte[] byArray2 = new byte[n3];
            byteArrayInputStream.read(byArray2);
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(new String(byArray2));
            fileWriter.close();
            if (string8 != null) {
                OraclePKIGenFunc.updateSerialNum(string8, bigInteger);
            }
        }
        catch (IOException iOException) {
            System.out.println("Unable to save certificate at " + string);
            System.out.println(iOException.toString());
            n2 = -1;
            return n2;
        }
        catch (Exception exception) {
            if (OraclePKIDebug.getDebugFlag()) {
                exception.printStackTrace();
            }
            System.out.println(exception.toString());
            n2 = -1;
            return n2;
        }
        System.out.println(a.getString("SUCCESSFUL_OPERATION"));
        return n2;
    }

    public static int display(String[] stringArray) {
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        if (stringArray.length == 0) {
            System.out.println(b);
            n = -1;
            return n;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-cert")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-summary")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-complete")) {
                    bl = true;
                    continue;
                }
                System.out.println(a.getString("INVALID_COMMAND_ERROR") + stringArray[i]);
                System.out.println(b);
                n = -1;
                return n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(b);
            n = -1;
            return n;
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = null;
        try {
            oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found at " + string);
            if (OraclePKIDebug.getDebugFlag()) {
                fileNotFoundException.printStackTrace();
            }
            n = -1;
            return n;
        }
        catch (IOException iOException) {
            System.out.println("Found invalid certificate at " + string);
            if (OraclePKIDebug.getDebugFlag()) {
                iOException.printStackTrace();
            }
            n = -1;
            return n;
        }
        if (bl) {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                System.out.println(oraclePKIX509CertImplArray[i]);
            }
        } else {
            for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                System.out.println("Subject:        " + oraclePKIX509CertImplArray[i].getSubjectDN());
                System.out.println(a.getString("GEN_ISSUER_OUT") + oraclePKIX509CertImplArray[i].getIssuerDN());
                System.out.println("Valid Until:    " + oraclePKIX509CertImplArray[i].getNotAfter());
            }
        }
        return n;
    }
}

