/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.security.crypto.provider.TransitionMode;

public class OraclePKIRSAKeyHelper {
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    static final Set<Integer> b = new HashSet<Integer>(Arrays.asList(512, 768, 1024));
    static final Set<Integer> c = new HashSet<Integer>(Arrays.asList(2048, 4096));
    static final Set<Integer> d = new HashSet<Integer>(Arrays.asList(8192, 16384));
    static final Set<Integer> e = new HashSet<Integer>();

    public static void validateKeysize(int n) throws IOException {
        if (!OraclePKIRSAKeyHelper.getKeySizes().contains(n)) {
            throw new IOException(MessageFormat.format(a.getString("PKI-07008"), OraclePKIRSAKeyHelper.a()));
        }
    }

    public static Set<Integer> getKeySizes() {
        if (TransitionMode.isFIPS140ModeEnabled()) {
            return c;
        }
        return e;
    }

    static String a() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = " or ";
        for (Integer n : OraclePKIRSAKeyHelper.getKeySizes()) {
            stringBuilder.append(n);
            stringBuilder.append(string);
        }
        return stringBuilder.substring(0, stringBuilder.length() - string.length());
    }

    static {
        e.addAll(b);
        e.addAll(c);
        e.addAll(d);
    }
}

