/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.textui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.naming.ServiceUnavailableException;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.X509;
import oracle.security.pki.Checksum;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OraclePKIX509CrlHelper;
import oracle.security.pki.OracleWallet;
import oracle.security.pki.internal.OraclePKIX509CertHelper;
import oracle.security.pki.internal.OraclePKIX509CertReqHelper;
import oracle.security.pki.textui.OraclePKIGenFunc$ConsoleEraser;

public class OraclePKIGenFunc {
    private static BufferedReader c = new BufferedReader(new InputStreamReader(System.in));
    static ResourceBundle a = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    public static final int RETRY_COUNT = 2;
    public static final int MAX_VALIDITY = 182500;
    static final String b = "ewallet.p12";

    public static char[] getPassword(String string, boolean bl, String string2) {
        String string3 = null;
        if (string != null) {
            if (bl) {
                try {
                    string3 = OraclePKIGenFunc.b(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            } else {
                string3 = string;
            }
            return string3.toCharArray();
        }
        return OraclePKIGenFunc.getPassword(string2);
    }

    public static char[] getPassword(String string) {
        char[] cArray = null;
        try {
            System.out.print(a.getString(string) + "  ");
            cArray = OraclePKIGenFunc.a();
        }
        catch (IOException iOException) {
            System.out.print(a.getString("UNKNOWN_ERROR") + iOException);
            return null;
        }
        return cArray;
    }

    public static char[] getCreatePassword(String string, boolean bl) {
        String string2 = null;
        if (string != null) {
            if (bl) {
                try {
                    string2 = OraclePKIGenFunc.b(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            } else {
                string2 = string;
            }
            return string2.toCharArray();
        }
        return OraclePKIGenFunc.getCreatePassword();
    }

    public static char[] getCreatePassword() {
        return OraclePKIGenFunc.a("ENTER_PASSWORD", "ENTER_PASSWORD_AGAIN", "PKI-01003", true);
    }

    public static char[] getSecret() {
        return OraclePKIGenFunc.a("ENTER_SECRET", "ENTER_SECRET_AGAIN", "PKI-03003", false);
    }

    private static char[] a(String string, String string2, String string3) {
        return OraclePKIGenFunc.a(string, string2, string3, true);
    }

    private static char[] a(String string, String string2, String string3, boolean bl) {
        int n = 0;
        while (true) {
            if (n >= 2) {
                System.exit(1);
            }
            char[] cArray = OraclePKIGenFunc.getPassword(string);
            if (bl && !OracleWallet.isValidPassword(cArray)) {
                System.out.println(a.getString("PKI-01002"));
                ++n;
                continue;
            }
            char[] cArray2 = OraclePKIGenFunc.getPassword(string2);
            boolean bl2 = cArray.length == cArray2.length;
            for (int i = 0; i < cArray.length && bl2; ++i) {
                bl2 = cArray[i] == cArray2[i];
            }
            if (bl2) {
                return cArray;
            }
            System.out.println(a.getString(string3));
        }
    }

    private static char[] a() throws IOException {
        Console console = System.console();
        if (console != null) {
            return console.readPassword();
        }
        char[] cArray = new char[1024];
        OraclePKIGenFunc$ConsoleEraser oraclePKIGenFunc$ConsoleEraser = new OraclePKIGenFunc$ConsoleEraser();
        oraclePKIGenFunc$ConsoleEraser.start();
        String string = c.readLine();
        oraclePKIGenFunc$ConsoleEraser.interrupt();
        try {
            oraclePKIGenFunc$ConsoleEraser.join();
            cArray = string.toCharArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println();
        return cArray;
    }

    public static OracleWallet openAWallet(String string, String string2, boolean bl, boolean bl2) throws IOException {
        OracleWallet oracleWallet = new OracleWallet();
        String string3 = null;
        if (string2 != null) {
            string3 = bl ? OraclePKIGenFunc.b(string2) : string2;
            oracleWallet.open(string, string3.toCharArray());
            return oracleWallet;
        }
        try {
            oracleWallet.open(string, null);
            if (bl2 && !oracleWallet.canModify()) {
                System.out.println("Cannot modify auto-login (sso) wallet");
                throw new IOException();
            }
            return oracleWallet;
        }
        catch (IOException iOException) {
            File file = new File(string);
            file = file.isDirectory() ? new File(file, b) : new File(file.getParentFile(), b);
            if (!file.exists()) {
                throw new IOException("ewallet.p12 not present at " + string);
            }
            oracleWallet.open(string, OraclePKIGenFunc.getPassword("WALLET_PASSWORD_PROMPT"));
            return oracleWallet;
        }
    }

    public static OracleWallet openAWallet(String string, String string2, boolean bl) throws IOException {
        return OraclePKIGenFunc.openAWallet(string, string2, bl, false);
    }

    private static String b(String string) throws IOException {
        String string2 = null;
        try {
            byte[] byArray = OraclePKIGenFunc.c(string);
            byte[] byArray2 = Checksum.SHA(byArray, null);
            string2 = new String(byArray2);
            return string2;
        }
        catch (Exception exception) {
            System.out.println("Deobfuscation exception: " + exception.toString());
            throw new IOException("deobfuscation error");
        }
    }

    private static byte[] c(String string) {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            byArray[i] = (byte)(OraclePKIGenFunc.a(cArray[2 * i]) << 4 & 0xF0 | OraclePKIGenFunc.a(cArray[2 * i + 1]) & 0xF);
        }
        return byArray;
    }

    private static byte a(char c) {
        if ('0' <= c && c <= '9') {
            return (byte)((byte)c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (byte)((byte)c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (byte)((byte)c - 65 + 10);
        }
        return -1;
    }

    public static CRL readCRLAt(String string) throws IOException, ServiceUnavailableException {
        try {
            return new CRL(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new CRL(new File(string));
            }
            catch (IOException iOException) {
                return OraclePKIX509CrlHelper.readB64CRLFrom(new FileReader(string));
            }
        }
        catch (IOException iOException) {
            if (iOException.toString().indexOf("javax.naming.ServiceUnavailableException") != -1) {
                throw new ServiceUnavailableException(iOException.toString());
            }
            return OraclePKIX509CrlHelper.readB64CRLFrom(new InputStreamReader(new URL(string).openStream()));
        }
    }

    public static CertificateRequest readCertRequestAt(String string) throws IOException {
        try {
            return new CertificateRequest(new URL(string).openStream());
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new CertificateRequest((InputStream)new FileInputStream(string));
            }
            catch (IOException iOException) {
                return OraclePKIX509CertReqHelper.readB64CertReqFrom(new FileReader(string));
            }
        }
        catch (IOException iOException) {
            return OraclePKIX509CertReqHelper.readB64CertReqFrom(new InputStreamReader(new URL(string).openStream()));
        }
    }

    public static OraclePKIX509CertImpl[] readCertsAt(String string) throws IOException {
        Vector vector = null;
        try {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new URL(string)));
            return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
        }
        catch (MalformedURLException malformedURLException) {
            try {
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new File(string)));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException) {
                try {
                    OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new FileReader(string)));
                    return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
                }
                catch (IOException iOException2) {
                    try {
                        vector = new PKCS7((InputStream)new FileInputStream(string)).getCertificates();
                    }
                    catch (IOException iOException3) {
                        vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new FileReader(string));
                    }
                }
            }
        }
        catch (IOException iOException) {
            try {
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new InputStreamReader(new URL(string).openStream())));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException4) {
                try {
                    vector = new PKCS7(new URL(string).openStream()).getCertificates();
                }
                catch (IOException iOException5) {
                    vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new InputStreamReader(new URL(string).openStream()));
                }
            }
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[vector.size()];
        for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
            oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl((X509)vector.elementAt(i));
        }
        return oraclePKIX509CertImplArray;
    }

    public static OraclePKIX509CertImpl[] readCertsAt(InputStream inputStream) throws IOException {
        Vector vector = null;
        try {
            OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(inputStream));
            return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
        }
        catch (ASN1FormatException aSN1FormatException) {
            try {
                inputStream.reset();
                OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(OraclePKIX509CertHelper.readB64X509CertFrom(new InputStreamReader(inputStream)));
                return new OraclePKIX509CertImpl[]{oraclePKIX509CertImpl};
            }
            catch (IOException iOException) {
                try {
                    inputStream.reset();
                    vector = new PKCS7(inputStream).getCertificates();
                }
                catch (IOException iOException2) {
                    try {
                        inputStream.reset();
                        vector = OraclePKIX509CertHelper.readB64X509PKCS7From(new InputStreamReader(inputStream));
                    }
                    catch (IOException iOException3) {
                        throw new IOException(a.getString("PKI-04001"));
                    }
                }
                OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[vector.size()];
                for (int i = 0; i < oraclePKIX509CertImplArray.length; ++i) {
                    oraclePKIX509CertImplArray[i] = new OraclePKIX509CertImpl((X509)vector.elementAt(i));
                }
                return oraclePKIX509CertImplArray;
            }
        }
    }

    public static BigInteger getSerialNum(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            if (OraclePKIGenFunc.isNullOrEmpty(string2)) {
                System.out.println(a.getString("PKI-04027"));
                return null;
            }
            BigInteger bigInteger = OraclePKIGenFunc.calculateSerialNumber(string2);
            return bigInteger;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(a.getString("PKI-02006") + string);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(a.getString("PKI-04022"));
            return null;
        }
        catch (Exception exception) {
            System.out.println("Exception in getSerialNum : " + exception);
            return null;
        }
    }

    public static void updateSerialNum(String string, BigInteger bigInteger) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            String string2 = bigInteger.toString();
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in updateSerialNum : " + exception);
        }
    }

    public static BigInteger calculateSerialNumber(String string) {
        if (null != string && !string.isEmpty()) {
            if (string.matches(".*[a-fA-F]+.*")) {
                return new BigInteger(string, 16);
            }
            if (string.startsWith("0x") || string.startsWith("0X")) {
                return new BigInteger(string.substring(2), 16);
            }
            return new BigInteger(string);
        }
        return null;
    }

    protected static ArrayList<GeneralName> a(String string) {
        GeneralName generalName = null;
        ArrayList<GeneralName> arrayList = null;
        try {
            String[] stringArray;
            if (null != string && !string.isEmpty() && null != (stringArray = string.split(",")) && stringArray.length > 0) {
                arrayList = new ArrayList<GeneralName>();
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = stringArray[i].split(":", 2);
                    if (null == stringArray2 || stringArray2.length <= 0) continue;
                    if (null != stringArray2[0] && !stringArray2[0].isEmpty()) {
                        byte[] byArray;
                        if (stringArray2[0].contains("DNS")) {
                            generalName = new GeneralName(GeneralName.Type.DNS_NAME, (ASN1Object)new ASN1String(stringArray2[1]));
                        } else if (stringArray2[0].contains("IPV4Address")) {
                            byArray = GeneralName.stringToIPv4Bytes((String)stringArray2[1]);
                            generalName = new GeneralName(GeneralName.Type.IP_ADDRESS, (ASN1Object)new ASN1OctetString(byArray));
                        } else if (stringArray2[0].contains("IPV6Address")) {
                            byArray = GeneralName.stringToIPv6Bytes((String)stringArray2[1]);
                            generalName = new GeneralName(GeneralName.Type.IP_ADDRESS, (ASN1Object)new ASN1OctetString(byArray));
                        } else {
                            System.out.println("Please enter the Subject Alternative Names in correct format : -addext_san <[DNS|IPV4Address|IPV6Address]:<value>[,[DNS|IPV4Address|IPV6Address]:<value>]...>");
                            return null;
                        }
                    }
                    arrayList.add(generalName);
                }
            }
        }
        catch (Exception exception) {
            exception.getMessage();
        }
        return arrayList;
    }

    public static String copyrightVersionBanner(String string) {
        MessageFormat messageFormat = new MessageFormat(a.getString("PRODUCTION_BANNER"));
        Object[] objectArray = new Object[]{string, "19.0.0.0.0"};
        String string2 = messageFormat.format(objectArray);
        MessageFormat messageFormat2 = new MessageFormat(a.getString("VERSION_BANNER"));
        Object[] objectArray2 = new Object[]{"19.4.0.0.0"};
        String string3 = messageFormat2.format(objectArray2);
        MessageFormat messageFormat3 = new MessageFormat(a.getString("COPYRIGHT_BANNER"));
        Object[] objectArray3 = new Object[]{"2004", "2022"};
        String string4 = messageFormat3.format(objectArray3);
        String string5 = string2 + "\n" + string3 + "\n" + string4;
        return string5;
    }

    public static boolean ValidateExpiryPeriodEntry(String string, String string2, String string3) {
        return !(string == null && string2 != null || string != null && string2 == null || string == null && string2 == null && string3 == null) && (string == null || string2 == null || string3 == null);
    }

    public static Date CalculateDateFromString(String string, String string2) {
        Date date = null;
        if (string != null) {
            if (string.length() > 10) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd-HHmmss-z");
                date = simpleDateFormat.parse(string, new ParsePosition(0));
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                date = simpleDateFormat.parse(string, new ParsePosition(0));
            }
        }
        if (date == null) {
            string2 = string2.substring(1, string2.length());
            System.out.println("Please follow the format [yyMMdd-HHmmss-z] or [mm/dd/yyyy] for " + string2);
        }
        return date;
    }

    static String a(String string, Exception exception) {
        String string2 = exception.getLocalizedMessage();
        if (string2 == null) {
            return string;
        }
        if (string2.startsWith("PKI-")) {
            return string2;
        }
        return string + " ( detail = " + string2 + " )";
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }
}

