/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import oracle.r2dbc.OracleR2dbcWarning;
import oracle.r2dbc.impl.DependentCounter;
import oracle.r2dbc.impl.OracleConnectionImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleReadableImpl;
import oracle.r2dbc.impl.Publishers;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.ReadablesMetadata;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class OracleResultImpl
implements Result {
    private boolean isPublished = false;

    private OracleResultImpl() {
    }

    protected abstract <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> var1, Function<? super T, U> var2);

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, "mappingFunction is null");
        this.setPublished();
        return OracleResultImpl.singleSubscriber(Flux.concat(this.mapSegments(Result.Segment.class, mappingFunction)));
    }

    public Publisher<Long> getRowsUpdated() {
        this.setPublished();
        return this.mapSegments(Result.UpdateCount.class, Result.UpdateCount::value);
    }

    public <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, "mappingFunction is null");
        this.setPublished();
        return OracleResultImpl.singleSubscriber(this.mapSegments(Result.RowSegment.class, rowSegment -> {
            Row row = rowSegment.row();
            return mappingFunction.apply(row, row.getMetadata());
        }));
    }

    public <T> Publisher<T> map(Function<? super Readable, ? extends T> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, "mappingFunction is null");
        this.setPublished();
        return OracleResultImpl.singleSubscriber(this.mapSegments(ReadableSegment.class, readableSegment -> mappingFunction.apply(readableSegment.getReadable())));
    }

    public OracleResultImpl filter(Predicate<Result.Segment> filter) {
        OracleR2dbcExceptions.requireNonNull(filter, "filter is null");
        return new FilteredResult(this, filter);
    }

    void addDependent() {
    }

    protected void setPublished() {
        if (this.isPublished) {
            throw new IllegalStateException("A result can not be consumed more than once");
        }
        this.isPublished = true;
    }

    public static OracleResultImpl createQueryResult(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ResultSet resultSet) {
        return new ResultSetResult(r2dbcConnection, dependentCounter, resultSet);
    }

    static OracleResultImpl createCallResult(DependentCounter dependentCounter, OutParameters outParameters, ReactiveJdbcAdapter adapter) {
        return new CallResult(dependentCounter, outParameters, adapter);
    }

    static OracleResultImpl createGeneratedValuesResult(OracleConnectionImpl r2dbcConnection, long updateCount, DependentCounter dependentCounter, ResultSet generatedKeys) {
        return new GeneratedKeysResult(r2dbcConnection, updateCount, dependentCounter, generatedKeys);
    }

    static OracleResultImpl createUpdateCountResult(long updateCount) {
        return new UpdateCountResult(updateCount);
    }

    static OracleResultImpl createBatchUpdateResult(long[] updateCounts) {
        return new BatchUpdateResult(updateCounts);
    }

    static OracleResultImpl createBatchUpdateErrorResult(BatchUpdateException batchUpdateException) {
        return new BatchUpdateErrorResult(batchUpdateException);
    }

    static OracleResultImpl createErrorResult(R2dbcException r2dbcException) {
        return new ErrorResult(r2dbcException);
    }

    static OracleResultImpl createWarningResult(String sql, SQLWarning warning, OracleResultImpl result) {
        return new WarningResult(sql, warning, result);
    }

    private static <T> Publisher<T> singleSubscriber(Publisher<T> publisher) {
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> isSubscribed.compareAndSet(false, true) ? publisher : Mono.error((Throwable)new IllegalStateException("Publisher does not support multiple subscribers")));
    }

    private static final class WarningImpl
    extends MessageImpl
    implements OracleR2dbcWarning {
        private WarningImpl(R2dbcException exception) {
            super(exception);
        }
    }

    private static class MessageImpl
    implements Result.Message {
        private final R2dbcException exception;

        private MessageImpl(R2dbcException exception) {
            this.exception = exception;
        }

        public R2dbcException exception() {
            return this.exception;
        }

        public int errorCode() {
            return this.exception.getErrorCode();
        }

        public String sqlState() {
            return this.exception.getSqlState();
        }

        public String message() {
            return this.exception.getMessage();
        }

        public String toString() {
            return this.exception.toString();
        }
    }

    private static final class UpdateCountImpl
    implements Result.UpdateCount {
        private final long value;

        private UpdateCountImpl(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    private static abstract class DependentResult
    extends OracleResultImpl {
        protected final DependentCounter dependentCounter;

        private DependentResult(DependentCounter dependentCounter) {
            this.dependentCounter = dependentCounter;
        }

        @Override
        void addDependent() {
            this.dependentCounter.increment();
        }

        @Override
        protected final <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            Publisher<Void> removeDependent = this.dependentCounter.decrement();
            return Publishers.concatTerminal(this.mapDependentSegments(segmentType, segmentMapper), removeDependent);
        }

        protected abstract <T extends Result.Segment, U> Publisher<U> mapDependentSegments(Class<T> var1, Function<? super T, U> var2);
    }

    private static final class OutSegmentImpl
    implements Result.OutSegment,
    ReadableSegment {
        private final OutParameters outParameters;

        private OutSegmentImpl(OutParameters outParameters) {
            this.outParameters = outParameters;
        }

        public OutParameters outParameters() {
            return this.outParameters;
        }

        @Override
        public Readable getReadable() {
            return this.outParameters;
        }
    }

    private static final class RowSegmentImpl
    implements Result.RowSegment,
    ReadableSegment {
        private final Row row;

        private RowSegmentImpl(Row row) {
            this.row = row;
        }

        public Row row() {
            return this.row;
        }

        @Override
        public Readable getReadable() {
            return this.row;
        }
    }

    private static interface ReadableSegment
    extends Result.Segment {
        public Readable getReadable();
    }

    private static final class FilteredResult
    extends OracleResultImpl {
        private static final Object FILTERED = new Object();
        private final OracleResultImpl result;
        private final Predicate<Result.Segment> filter;

        private FilteredResult(OracleResultImpl result, Predicate<Result.Segment> filter) {
            this.result = result;
            this.filter = filter;
        }

        @Override
        void addDependent() {
            this.result.addDependent();
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            Object filtered = FILTERED;
            return Flux.from(this.result.mapSegments(Result.Segment.class, segment -> {
                if (!this.filter.test((Result.Segment)segment)) {
                    return filtered;
                }
                if (segmentType.isAssignableFrom(segment.getClass())) {
                    return segmentMapper.apply((Object)segmentType.cast(segment));
                }
                if (segment instanceof Result.Message) {
                    throw ((Result.Message)segment).exception();
                }
                return filtered;
            })).filter(next -> next != FILTERED);
        }

        @Override
        protected void setPublished() {
            this.result.setPublished();
            super.setPublished();
        }
    }

    private static final class WarningResult
    extends OracleResultImpl {
        private final String sql;
        private final SQLWarning warning;
        private final OracleResultImpl result;

        private WarningResult(String sql, SQLWarning warning, OracleResultImpl result) {
            this.sql = sql;
            this.warning = warning;
            this.result = result;
        }

        @Override
        void addDependent() {
            this.result.addDependent();
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            return Flux.concat((Publisher[])new Publisher[]{this.result != null ? this.result.mapSegments(segmentType, segmentMapper) : Mono.empty(), segmentType.isAssignableFrom(WarningImpl.class) ? Flux.fromStream(Stream.iterate(this.warning, Objects::nonNull, SQLWarning::getNextWarning).map((? super T nextWarning) -> segmentMapper.apply((Object)segmentType.cast(new WarningImpl(OracleR2dbcExceptions.toR2dbcException(nextWarning, this.sql)))))) : Mono.empty()});
        }
    }

    private static final class ErrorResult
    extends OracleResultImpl {
        private final R2dbcException r2dbcException;

        private ErrorResult(R2dbcException r2dbcException) {
            this.r2dbcException = r2dbcException;
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            if (!segmentType.isAssignableFrom(MessageImpl.class)) {
                return Mono.error((Throwable)this.r2dbcException);
            }
            return Mono.fromSupplier(() -> segmentMapper.apply((Object)segmentType.cast(new MessageImpl(this.r2dbcException))));
        }
    }

    private static final class BatchUpdateErrorResult
    extends OracleResultImpl {
        private final BatchUpdateResult batchUpdateResult;
        private final ErrorResult errorResult;

        private BatchUpdateErrorResult(BatchUpdateException batchUpdateException) {
            this.batchUpdateResult = new BatchUpdateResult(batchUpdateException.getLargeUpdateCounts());
            this.errorResult = new ErrorResult(OracleR2dbcExceptions.toR2dbcException(batchUpdateException));
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            return Flux.concat((Publisher[])new Publisher[]{this.batchUpdateResult.mapSegments(segmentType, segmentMapper), this.errorResult.mapSegments(segmentType, segmentMapper)});
        }
    }

    private static final class BatchUpdateResult
    extends OracleResultImpl {
        private final long[] updateCounts;

        private BatchUpdateResult(long[] updateCounts) {
            this.updateCounts = updateCounts;
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            if (!segmentType.isAssignableFrom(UpdateCountImpl.class)) {
                return Mono.empty();
            }
            return Flux.fromStream(LongStream.of(this.updateCounts).mapToObj(updateCount -> segmentMapper.apply((Object)segmentType.cast(new UpdateCountImpl(updateCount)))));
        }
    }

    private static final class CallResult
    extends DependentResult {
        private final OutParameters outParameters;
        private final ReactiveJdbcAdapter adapter;

        private CallResult(DependentCounter dependentCounter, OutParameters outParameters, ReactiveJdbcAdapter adapter) {
            super(dependentCounter);
            this.outParameters = outParameters;
            this.adapter = adapter;
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapDependentSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            if (!segmentType.isAssignableFrom(OutSegmentImpl.class)) {
                return Mono.empty();
            }
            return this.adapter.getLock().get(() -> segmentMapper.apply((Object)segmentType.cast(new OutSegmentImpl(this.outParameters))));
        }
    }

    private static final class GeneratedKeysResult
    extends OracleResultImpl {
        private final OracleResultImpl updateCountResult;
        private final OracleResultImpl generatedKeysResult;

        private GeneratedKeysResult(OracleConnectionImpl r2dbcConnection, long updateCount, DependentCounter dependentCounter, ResultSet generatedKeys) {
            this.updateCountResult = GeneratedKeysResult.createUpdateCountResult(updateCount);
            this.generatedKeysResult = GeneratedKeysResult.createQueryResult(r2dbcConnection, dependentCounter, generatedKeys);
        }

        @Override
        void addDependent() {
            this.generatedKeysResult.addDependent();
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            return Flux.concat((Publisher[])new Publisher[]{this.updateCountResult.mapSegments(segmentType, segmentMapper), this.generatedKeysResult.mapSegments(segmentType, segmentMapper)});
        }
    }

    private static final class ResultSetResult
    extends DependentResult {
        private final OracleConnectionImpl r2dbcConnection;
        private final ResultSet resultSet;
        private final ReadablesMetadata.RowMetadataImpl metadata;
        private final ReactiveJdbcAdapter adapter;

        private ResultSetResult(OracleConnectionImpl r2dbcConnection, DependentCounter dependentCounter, ResultSet resultSet) {
            super(dependentCounter);
            this.r2dbcConnection = r2dbcConnection;
            this.resultSet = resultSet;
            this.metadata = ReadablesMetadata.createRowMetadata(OracleR2dbcExceptions.fromJdbc(resultSet::getMetaData));
            this.adapter = r2dbcConnection.adapter();
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapDependentSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            if (!segmentType.isAssignableFrom(RowSegmentImpl.class)) {
                return Mono.empty();
            }
            ReusableJdbcReadable reusableJdbcReadable = new ReusableJdbcReadable();
            Row row = OracleReadableImpl.createRow(this.r2dbcConnection, this.dependentCounter, reusableJdbcReadable, this.metadata);
            return this.adapter.publishRows(this.resultSet, jdbcReadable -> {
                reusableJdbcReadable.current = jdbcReadable;
                return segmentMapper.apply((Object)segmentType.cast(new RowSegmentImpl(row)));
            });
        }

        private static final class ReusableJdbcReadable
        implements ReactiveJdbcAdapter.JdbcReadable {
            ReactiveJdbcAdapter.JdbcReadable current = null;

            private ReusableJdbcReadable() {
            }

            @Override
            public <T> T getObject(int index, Class<T> type) {
                return this.current.getObject(index, type);
            }
        }
    }

    private static final class UpdateCountResult
    extends OracleResultImpl {
        private final long updateCount;

        private UpdateCountResult(long updateCount) {
            this.updateCount = updateCount;
        }

        @Override
        protected <T extends Result.Segment, U> Publisher<U> mapSegments(Class<T> segmentType, Function<? super T, U> segmentMapper) {
            if (!segmentType.isAssignableFrom(UpdateCountImpl.class)) {
                return Mono.empty();
            }
            return Mono.fromSupplier(() -> segmentMapper.apply((Object)segmentType.cast(new UpdateCountImpl(this.updateCount))));
        }
    }
}

