/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.function.Supplier;
import oracle.jdbc.OracleDatabaseException;

final class OracleR2dbcExceptions {
    private OracleR2dbcExceptions() {
    }

    static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    static void requireOpenConnection(Connection jdbcConnection) {
        if (OracleR2dbcExceptions.fromJdbc(jdbcConnection::isClosed).booleanValue()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    static R2dbcException toR2dbcException(SQLException sqlException) {
        return OracleR2dbcExceptions.toR2dbcException(sqlException, OracleR2dbcExceptions.getSql(sqlException));
    }

    static R2dbcException toR2dbcException(SQLException sqlException, String sql) {
        assert (sqlException != null) : "sqlException is null";
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        int errorCode = sqlException.getErrorCode();
        if (sqlException instanceof SQLNonTransientException) {
            if (sqlException instanceof SQLSyntaxErrorException) {
                return new R2dbcBadGrammarException(message, sqlState, errorCode, sql, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLIntegrityConstraintViolationException) {
                return new R2dbcDataIntegrityViolationException(message, sqlState, errorCode, sql, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLNonTransientConnectionException) {
                return new R2dbcNonTransientResourceException(message, sqlState, errorCode, sql, (Throwable)sqlException);
            }
            return new OracleR2dbcNonTransientException(message, sqlState, errorCode, sql, sqlException);
        }
        if (sqlException instanceof SQLTransientException) {
            if (sqlException instanceof SQLTimeoutException) {
                return new R2dbcTimeoutException(message, sqlState, errorCode, sql, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLTransactionRollbackException) {
                return new R2dbcRollbackException(message, sqlState, errorCode, sql, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLTransientConnectionException) {
                return new R2dbcTransientResourceException(message, sqlState, errorCode, sql, (Throwable)sqlException);
            }
            return new OracleR2dbcTransientException(message, sqlState, errorCode, sql, sqlException);
        }
        if (sqlException instanceof SQLRecoverableException) {
            return new R2dbcTransientResourceException(message, sqlState, errorCode, sql, (Throwable)sqlException);
        }
        return new OracleR2dbcException(message, sqlState, errorCode, sql, sqlException);
    }

    static void runJdbc(JdbcRunnable runnable) throws R2dbcException {
        try {
            runnable.runOrThrow();
        }
        catch (SQLException sqlException) {
            throw OracleR2dbcExceptions.toR2dbcException(sqlException);
        }
    }

    static <T> T fromJdbc(JdbcSupplier<T> supplier) throws R2dbcException {
        try {
            return supplier.getOrThrow();
        }
        catch (SQLException sqlException) {
            throw OracleR2dbcExceptions.toR2dbcException(sqlException);
        }
    }

    static R2dbcNonTransientException newNonTransientException(String message, String sql, Throwable cause) {
        return new OracleR2dbcNonTransientException(message, null, 0, sql, cause);
    }

    private static String getSql(SQLException sqlException) {
        for (Throwable cause = sqlException.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof OracleDatabaseException)) continue;
            return ((OracleDatabaseException)cause).getSql();
        }
        return null;
    }

    private static final class OracleR2dbcNonTransientException
    extends R2dbcNonTransientException {
        private OracleR2dbcNonTransientException(String message, String sqlState, int errorCode, String sql, Throwable cause) {
            super(message, sqlState, errorCode, sql, cause);
        }
    }

    private static final class OracleR2dbcTransientException
    extends R2dbcTransientException {
        private OracleR2dbcTransientException(String message, String sqlState, int errorCode, String sql, SQLException sqlException) {
            super(message, sqlState, errorCode, sql, (Throwable)sqlException);
        }
    }

    private static final class OracleR2dbcException
    extends R2dbcException {
        private OracleR2dbcException(String message, String sqlState, int errorCode, String sql, SQLException sqlException) {
            super(message, sqlState, errorCode, sql, (Throwable)sqlException);
        }
    }

    @FunctionalInterface
    static interface JdbcSupplier<T>
    extends Supplier<T> {
        public T getOrThrow() throws SQLException;

        @Override
        default public T get() throws R2dbcException {
            return OracleR2dbcExceptions.fromJdbc(this);
        }
    }

    @FunctionalInterface
    static interface JdbcRunnable
    extends Runnable {
        public void runOrThrow() throws SQLException;

        @Override
        default public void run() throws R2dbcException {
            OracleR2dbcExceptions.runJdbc(this);
        }
    }
}

