/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Batch;
import java.sql.Connection;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import oracle.r2dbc.impl.OracleConnectionImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleResultImpl;
import oracle.r2dbc.impl.OracleStatementImpl;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

final class OracleBatchImpl
implements Batch {
    private final OracleConnectionImpl r2dbcConnection;
    private final Connection jdbcConnection;
    private final Duration timeout;
    private Queue<OracleStatementImpl> statements = new LinkedList<OracleStatementImpl>();

    OracleBatchImpl(Duration timeout, OracleConnectionImpl r2dbcConnection) {
        this.timeout = timeout;
        this.r2dbcConnection = r2dbcConnection;
        this.jdbcConnection = r2dbcConnection.jdbcConnection();
    }

    public Batch add(String sql) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(sql, "sql is null");
        this.statements.add(new OracleStatementImpl(sql, this.timeout, this.r2dbcConnection));
        return this;
    }

    public Publisher<OracleResultImpl> execute() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        Queue<OracleStatementImpl> currentStatements = this.statements;
        this.statements = new LinkedList<OracleStatementImpl>();
        return Flux.fromIterable(currentStatements).flatMapSequential(OracleStatementImpl::execute);
    }
}

