/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import oracle.r2dbc.impl.AsyncLock;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Mono;

final class AsyncLockImpl
implements AsyncLock {
    private final AtomicInteger waitCount = new AtomicInteger(0);
    private final ConcurrentLinkedDeque<Runnable> waitQueue = new ConcurrentLinkedDeque();

    AsyncLockImpl() {
    }

    @Override
    public void lock(Runnable callback) {
        assert (this.waitCount.get() >= 0) : "Wait count is less than 0: " + this.waitCount;
        if (this.waitCount.compareAndSet(0, 1)) {
            callback.run();
        } else {
            this.waitQueue.addLast(callback);
            if (0 == this.waitCount.getAndIncrement()) {
                this.waitQueue.removeFirst().run();
            }
        }
    }

    private void unlock() {
        assert (this.waitCount.get() > 0) : "Wait count is less than 1: " + this.waitCount;
        if (0 != this.waitCount.decrementAndGet()) {
            this.waitQueue.removeFirst().run();
        }
    }

    @Override
    public Publisher<Void> run(OracleR2dbcExceptions.JdbcRunnable jdbcRunnable) {
        return Mono.create(monoSink -> this.lock(() -> {
            try {
                jdbcRunnable.runOrThrow();
                this.unlock();
                monoSink.success();
            }
            catch (Throwable throwable) {
                this.unlock();
                monoSink.error(throwable);
            }
        }));
    }

    @Override
    public <T> Publisher<T> get(OracleR2dbcExceptions.JdbcSupplier<T> jdbcSupplier) {
        return Mono.create(monoSink -> this.lock(() -> {
            try {
                Object result = jdbcSupplier.getOrThrow();
                this.unlock();
                monoSink.success(result);
            }
            catch (Throwable throwable) {
                this.unlock();
                monoSink.error(throwable);
            }
        }));
    }

    @Override
    public <T> Publisher<T> flatMap(OracleR2dbcExceptions.JdbcSupplier<Publisher<T>> publisherSupplier) {
        return Mono.from(this.get(publisherSupplier)).flatMapMany(Function.identity());
    }

    @Override
    public <T> Publisher<T> lock(Publisher<T> publisher) {
        return subscriber -> this.lock(() -> publisher.subscribe(new UsingConnectionSubscriber(subscriber)));
    }

    private final class UsingConnectionSubscriber<T>
    implements Subscription,
    Subscriber<T> {
        private static final long CANCEL_PENDING = -1L;
        private static final long TERMINATED = -2L;
        private final Subscriber<T> downstream;
        private Subscription upstream;
        private final AtomicLong demand = new AtomicLong(0L);

        private UsingConnectionSubscriber(Subscriber<T> downstream) {
            this.downstream = downstream;
        }

        public void onSubscribe(Subscription subscription) {
            AsyncLockImpl.this.unlock();
            this.upstream = subscription;
            this.downstream.onSubscribe((Subscription)this);
        }

        public void request(long n) {
            AsyncLockImpl.this.lock(() -> {
                long currentDemand = this.demand.getAndUpdate(current -> current < 0L ? current : (Long.MAX_VALUE - current < n ? Long.MAX_VALUE : current + n));
                if (currentDemand >= 0L) {
                    this.upstream.request(n);
                } else {
                    AsyncLockImpl.this.unlock();
                }
            });
        }

        public void onNext(T value) {
            long currentDemand = this.demand.getAndUpdate(current -> current == Long.MAX_VALUE ? current : (current == -1L ? -2L : current - 1L));
            if (currentDemand == -1L) {
                AsyncLockImpl.this.unlock();
                this.upstream.cancel();
            } else if (currentDemand > 0L) {
                if (currentDemand == 1L) {
                    AsyncLockImpl.this.unlock();
                }
                this.downstream.onNext(value);
            }
        }

        public void cancel() {
            long currentDemand = this.demand.getAndUpdate(current -> current > 0L || current == -1L ? -1L : -2L);
            if (currentDemand == 0L) {
                this.upstream.cancel();
            }
        }

        public void onError(Throwable error) {
            this.terminate();
            this.downstream.onError(error);
        }

        public void onComplete() {
            this.terminate();
            this.downstream.onComplete();
        }

        private void terminate() {
            long currentDemand = this.demand.getAndSet(-2L);
            if (currentDemand > 0L || currentDemand == -1L) {
                AsyncLockImpl.this.unlock();
            }
        }
    }
}

