/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc;

import io.r2dbc.spi.Result;
import io.r2dbc.spi.Type;
import java.nio.ByteBuffer;
import java.sql.RowId;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Objects;
import oracle.r2dbc.OracleR2dbcObject;
import oracle.sql.VECTOR;
import oracle.sql.json.OracleJsonObject;

public final class OracleR2dbcTypes {
    public static final Type BINARY_DOUBLE = new TypeImpl(Double.class, "BINARY_DOUBLE");
    public static final Type BINARY_FLOAT = new TypeImpl(Float.class, "BINARY_FLOAT");
    public static final Type INTERVAL_DAY_TO_SECOND = new TypeImpl(Duration.class, "INTERVAL DAY TO SECOND");
    public static final Type INTERVAL_YEAR_TO_MONTH = new TypeImpl(Period.class, "INTERVAL YEAR TO MONTH");
    public static final Type JSON = new TypeImpl(OracleJsonObject.class, "JSON");
    public static final Type LONG = new TypeImpl(String.class, "LONG");
    public static final Type LONG_RAW = new TypeImpl(ByteBuffer.class, "LONG RAW");
    public static final Type ROWID = new TypeImpl(RowId.class, "ROWID");
    public static final Type TIMESTAMP_WITH_LOCAL_TIME_ZONE = new TypeImpl(LocalDateTime.class, "TIMESTAMP WITH LOCAL TIME ZONE");
    public static final Type REF_CURSOR = new TypeImpl(Result.class, "SYS_REFCURSOR");
    public static final Type VECTOR = new TypeImpl(VECTOR.class, "VECTOR");

    private OracleR2dbcTypes() {
    }

    public static ArrayType arrayType(String name) {
        return new ArrayTypeImpl(Objects.requireNonNull(name, "name is null"));
    }

    public static ObjectType objectType(String name) {
        return new ObjectTypeImpl(Objects.requireNonNull(name, "name is null"));
    }

    private static class TypeImpl
    implements Type {
        private final Class<?> javaType;
        private final String sqlName;

        TypeImpl(Class<?> javaType, String sqlName) {
            this.javaType = javaType;
            this.sqlName = sqlName;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public String getName() {
            return this.sqlName;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Type)) {
                return false;
            }
            return this.sqlName.equals(((Type)other).getName());
        }

        public int hashCode() {
            return this.sqlName.hashCode();
        }
    }

    private static final class ObjectTypeImpl
    extends TypeImpl
    implements ObjectType {
        ObjectTypeImpl(String name) {
            super(OracleR2dbcObject.class, name);
        }
    }

    private static final class ArrayTypeImpl
    extends TypeImpl
    implements ArrayType {
        ArrayTypeImpl(String name) {
            super(Object[].class, name);
        }
    }

    public static interface ObjectType
    extends Type {
        public Class<?> getJavaType();

        public String getName();
    }

    public static interface ArrayType
    extends Type {
        public Class<?> getJavaType();

        public String getName();
    }
}

