/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Lifecycle;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import oracle.r2dbc.impl.OracleBatchImpl;
import oracle.r2dbc.impl.OracleConnectionMetadataImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleStatementImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleConnectionImpl
implements Connection,
Lifecycle {
    private final ReactiveJdbcAdapter adapter;
    private final java.sql.Connection jdbcConnection;
    private Duration statementTimeout = Duration.ZERO;
    private IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
    private TransactionDefinition currentTransaction = null;

    OracleConnectionImpl(java.sql.Connection jdbcConnection, ReactiveJdbcAdapter adapter) {
        this.adapter = adapter;
        this.jdbcConnection = jdbcConnection;
    }

    public Publisher<Void> beginTransaction() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return this.beginTransaction((TransactionDefinition)this.isolationLevel);
    }

    public Publisher<Void> beginTransaction(TransactionDefinition definition) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(definition, "definition is null");
        OracleConnectionImpl.validateTransactionDefinition(definition);
        return Mono.from(this.setAutoCommit(false)).then(Mono.from((Publisher)this.createStatement(this.composeSetTransaction(definition)).execute()).flatMap(result -> Mono.from((Publisher)result.getRowsUpdated())).then().doOnSuccess(nil -> {
            this.currentTransaction = definition;
        })).cache();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String composeSetTransaction(TransactionDefinition definition) {
        StringBuilder setTransactionBuilder = new StringBuilder("SET TRANSACTION");
        IsolationLevel isolationLevel = (IsolationLevel)definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL);
        Boolean isReadOnly = (Boolean)definition.getAttribute(TransactionDefinition.READ_ONLY);
        String name = (String)definition.getAttribute(TransactionDefinition.NAME);
        if (isolationLevel != null) {
            if (IsolationLevel.READ_COMMITTED.equals(isolationLevel)) {
                setTransactionBuilder.append(" ISOLATION LEVEL READ COMMITTED");
            } else {
                if (!IsolationLevel.SERIALIZABLE.equals(isolationLevel)) throw new IllegalArgumentException("Unsupported isolation level:" + isolationLevel);
                setTransactionBuilder.append(" ISOLATION LEVEL SERIALIZABLE");
            }
        } else if (isReadOnly != null) {
            setTransactionBuilder.append(isReadOnly != false ? " READ ONLY" : " READ WRITE");
        }
        if (name == null) return setTransactionBuilder.toString();
        setTransactionBuilder.append(" NAME ").append(this.enquoteLiteral(name));
        return setTransactionBuilder.toString();
    }

    private String enquoteLiteral(String literal) {
        String string;
        block8: {
            Statement jdbcStatement = this.jdbcConnection.createStatement();
            try {
                string = jdbcStatement.enquoteLiteral(literal);
                if (jdbcStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jdbcStatement != null) {
                        try {
                            jdbcStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw OracleR2dbcExceptions.toR2dbcException(sqlException);
                }
            }
            jdbcStatement.close();
        }
        return string;
    }

    private static void validateTransactionDefinition(TransactionDefinition definition) {
        IsolationLevel isolationLevel = (IsolationLevel)definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL);
        Boolean isReadOnly = (Boolean)definition.getAttribute(TransactionDefinition.READ_ONLY);
        String name = (String)definition.getAttribute(TransactionDefinition.NAME);
        if (isolationLevel != null) {
            if (isReadOnly != null) {
                throw new IllegalArgumentException("Specifying both ISOLATION_LEVEL and READ_ONLY is not supported");
            }
            if (!isolationLevel.equals(IsolationLevel.READ_COMMITTED) && !isolationLevel.equals(IsolationLevel.SERIALIZABLE)) {
                throw new IllegalArgumentException("Unsupported ISOLATION_LEVEL: " + isolationLevel);
            }
        } else if (isReadOnly == null && name == null) {
            throw new IllegalArgumentException("Transaction definition does not specify an isolation level, read only, or name. At least one must be specified.");
        }
        if (definition.getAttribute(TransactionDefinition.LOCK_WAIT_TIMEOUT) != null) {
            throw new UnsupportedOperationException("Oracle Database does not support a lock wait timeout transaction parameter");
        }
    }

    public Publisher<Void> close() {
        return this.adapter.publishClose(this.jdbcConnection);
    }

    public Publisher<Void> commitTransaction() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return Mono.from(this.adapter.publishCommit(this.jdbcConnection)).doOnSuccess(nil -> {
            this.currentTransaction = null;
        });
    }

    public Batch createBatch() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return new OracleBatchImpl(this.statementTimeout, this.jdbcConnection, this.adapter);
    }

    public io.r2dbc.spi.Statement createStatement(String sql) {
        OracleR2dbcExceptions.requireNonNull(sql, "sql is null");
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return new OracleStatementImpl(sql, this.statementTimeout, this.jdbcConnection, this.adapter);
    }

    public boolean isAutoCommit() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return OracleR2dbcExceptions.fromJdbc(this.jdbcConnection::getAutoCommit);
    }

    public ConnectionMetadata getMetadata() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return new OracleConnectionMetadataImpl(OracleR2dbcExceptions.fromJdbc(this.jdbcConnection::getMetaData));
    }

    public Publisher<Void> createSavepoint(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return Mono.from(this.setAutoCommit(false)).then(Flux.from((Publisher)this.createStatement("SAVEPOINT " + name).execute()).flatMap(Result::getRowsUpdated).then());
    }

    public Publisher<Void> releaseSavepoint(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return Mono.empty();
    }

    public Publisher<Void> rollbackTransaction() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return Mono.from(this.adapter.publishRollback(this.jdbcConnection)).doOnSuccess(nil -> {
            this.currentTransaction = null;
        });
    }

    public Publisher<Void> rollbackTransactionToSavepoint(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return Flux.from((Publisher)this.createStatement("ROLLBACK TO " + name).execute()).flatMap(Result::getRowsUpdated).then();
    }

    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        return Mono.from(this.adapter.getLock().flatMap(() -> {
            if (autoCommit == this.jdbcConnection.getAutoCommit()) {
                return Mono.empty();
            }
            if (!autoCommit) {
                this.jdbcConnection.setAutoCommit(false);
                return Mono.empty();
            }
            return Mono.from(this.commitTransaction()).concatWith(this.adapter.getLock().run(() -> this.jdbcConnection.setAutoCommit(true)));
        })).cache();
    }

    public Publisher<Void> setLockWaitTimeout(Duration timeout) {
        throw new UnsupportedOperationException("Oracle Database does not support a lock wait timeout session parameter");
    }

    public Publisher<Void> setStatementTimeout(Duration timeout) {
        OracleR2dbcExceptions.requireNonNull(timeout, "timeout is null");
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout is a negative Duration: " + timeout);
        }
        this.statementTimeout = timeout;
        return Mono.empty();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        if (this.currentTransaction == null) {
            return this.isolationLevel;
        }
        IsolationLevel currentIsolationLevel = (IsolationLevel)this.currentTransaction.getAttribute(TransactionDefinition.ISOLATION_LEVEL);
        return currentIsolationLevel != null ? currentIsolationLevel : (Boolean.TRUE == this.currentTransaction.getAttribute(TransactionDefinition.READ_ONLY) ? IsolationLevel.SERIALIZABLE : this.isolationLevel);
    }

    public Publisher<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        OracleR2dbcExceptions.requireNonNull(isolationLevel, "isolationLevel is null");
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        if (isolationLevel.equals(this.isolationLevel)) {
            return Mono.empty();
        }
        Object alterSession = "ALTER SESSION SET ISOLATION_LEVEL = ";
        if (isolationLevel.equals(IsolationLevel.READ_COMMITTED)) {
            alterSession = (String)alterSession + "READ COMMITTED";
        } else if (isolationLevel.equals(IsolationLevel.SERIALIZABLE)) {
            alterSession = (String)alterSession + "SERIALIZABLE";
        } else {
            throw new IllegalArgumentException("Oracle Database does not support isolation level: " + isolationLevel);
        }
        return Mono.from((Publisher)this.createStatement((String)alterSession).execute()).then().doOnSuccess(nil -> {
            this.isolationLevel = isolationLevel;
        }).cache();
    }

    public Publisher<Boolean> validate(ValidationDepth depth) {
        OracleR2dbcExceptions.requireNonNull(depth, "depth is null");
        return Mono.defer(() -> OracleR2dbcExceptions.fromJdbc(() -> {
            if (this.jdbcConnection.isClosed()) {
                return Mono.just((Object)false);
            }
            if (depth == ValidationDepth.LOCAL) {
                return Mono.just((Object)true);
            }
            return Mono.from((Publisher)this.createStatement("SELECT 1 FROM sys.dual").execute()).flatMap(result -> Mono.from((Publisher)result.map((row, metadata) -> (Integer)row.get(0, Integer.class)))).map(value -> Integer.valueOf(1).equals(value)).defaultIfEmpty((Object)false).onErrorReturn((Object)false);
        })).cache();
    }

    public Publisher<Void> postAllocate() {
        return Mono.fromSupplier(() -> {
            OracleR2dbcExceptions.runJdbc(this.jdbcConnection::beginRequest);
            return null;
        });
    }

    public Publisher<Void> preRelease() {
        return Mono.fromSupplier(() -> {
            OracleR2dbcExceptions.runJdbc(this.jdbcConnection::endRequest);
            return null;
        });
    }
}

