/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLWarning;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleReadableImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.ReadablesMetadata;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class OracleResultImpl
implements Result {
    private static final Object FILTERED = new Object();
    private boolean isPublished = false;
    private final AtomicReference<Publisher<Void>> onConsumed = new AtomicReference<Mono>(Mono.empty());

    private OracleResultImpl() {
    }

    abstract <T> Publisher<T> publishSegments(Function<Result.Segment, T> var1);

    private <T extends Result.Segment, U> Publisher<U> publishSegments(Class<T> type, Function<? super T, U> mappingFunction) {
        this.setPublished();
        Mono whenConsumed = Mono.defer(() -> {
            Publisher consumedPublisher = this.onConsumed.getAndSet(null);
            return consumedPublisher == null ? Mono.empty() : Mono.from((Publisher)consumedPublisher);
        });
        return Flux.concatDelayError((Publisher[])new Publisher[]{Flux.from(this.publishSegments(segment -> {
            if (type.isInstance(segment)) {
                return mappingFunction.apply((Object)type.cast(segment));
            }
            if (segment instanceof Result.Message) {
                throw ((Result.Message)segment).exception();
            }
            return FILTERED;
        })).filter(object -> object != FILTERED), whenConsumed}).doOnCancel(() -> Mono.from((Publisher)whenConsumed).subscribe());
    }

    public <T> Publisher<T> flatMap(Function<Result.Segment, ? extends Publisher<? extends T>> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, "mappingFunction is null");
        return OracleResultImpl.singleSubscriber(Flux.concat(this.publishSegments(Result.Segment.class, mappingFunction)));
    }

    public Publisher<Long> getRowsUpdated() {
        return this.publishSegments(Result.UpdateCount.class, Result.UpdateCount::value);
    }

    public <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, "mappingFunction is null");
        return OracleResultImpl.singleSubscriber(this.publishSegments(Result.RowSegment.class, rowSegment -> {
            Row row = rowSegment.row();
            return mappingFunction.apply(row, row.getMetadata());
        }));
    }

    public <T> Publisher<T> map(Function<? super Readable, ? extends T> mappingFunction) {
        OracleR2dbcExceptions.requireNonNull(mappingFunction, "mappingFunction is null");
        return OracleResultImpl.singleSubscriber(this.publishSegments(ReadableSegment.class, readableSegment -> mappingFunction.apply(readableSegment.getReadable())));
    }

    public OracleResultImpl filter(Predicate<Result.Segment> filter) {
        OracleR2dbcExceptions.requireNonNull(filter, "filter is null");
        if (this.isPublished) {
            throw OracleResultImpl.multipleConsumptionException();
        }
        return new FilteredResult(this, filter);
    }

    final boolean onConsumed(Publisher<Void> onConsumed) {
        return null != this.onConsumed.getAndUpdate(current -> current == null ? null : onConsumed);
    }

    protected void setPublished() {
        if (this.isPublished) {
            throw OracleResultImpl.multipleConsumptionException();
        }
        this.isPublished = true;
    }

    private static IllegalStateException multipleConsumptionException() {
        return new IllegalStateException("A result can not be consumed more than once");
    }

    public static OracleResultImpl createQueryResult(ResultSet resultSet, ReactiveJdbcAdapter adapter) {
        return new ResultSetResult(resultSet, adapter);
    }

    static OracleResultImpl createCallResult(OutParameters outParameters, ReactiveJdbcAdapter adapter) {
        return new CallResult(outParameters, adapter);
    }

    static OracleResultImpl createGeneratedValuesResult(long updateCount, ResultSet generatedKeys, ReactiveJdbcAdapter adapter) {
        return new GeneratedKeysResult(updateCount, generatedKeys, adapter);
    }

    static OracleResultImpl createUpdateCountResult(long updateCount) {
        return new UpdateCountResult(updateCount);
    }

    static OracleResultImpl createBatchUpdateResult(long[] updateCounts) {
        return new BatchUpdateResult(updateCounts);
    }

    static OracleResultImpl createBatchUpdateErrorResult(BatchUpdateException batchUpdateException) {
        return new BatchUpdateErrorResult(batchUpdateException);
    }

    static OracleResultImpl createErrorResult(R2dbcException r2dbcException) {
        return new ErrorResult(r2dbcException);
    }

    static OracleResultImpl createWarningResult(SQLWarning warning, OracleResultImpl result) {
        return new WarningResult(warning, result);
    }

    private static <T> Publisher<T> singleSubscriber(Publisher<T> publisher) {
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> isSubscribed.compareAndSet(false, true) ? publisher : Mono.error((Throwable)new IllegalStateException("Publisher does not support multiple subscribers")));
    }

    private static final class MessageImpl
    implements Result.Message {
        private final R2dbcException exception;

        private MessageImpl(R2dbcException exception) {
            this.exception = exception;
        }

        public R2dbcException exception() {
            return this.exception;
        }

        public int errorCode() {
            return this.exception.getErrorCode();
        }

        public String sqlState() {
            return this.exception.getSqlState();
        }

        public String message() {
            return this.exception.getMessage();
        }
    }

    private static final class UpdateCountImpl
    implements Result.UpdateCount {
        private final long value;

        private UpdateCountImpl(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }
    }

    private static final class OutSegmentImpl
    implements Result.OutSegment,
    ReadableSegment {
        private final OutParameters outParameters;

        private OutSegmentImpl(OutParameters outParameters) {
            this.outParameters = outParameters;
        }

        public OutParameters outParameters() {
            return this.outParameters;
        }

        @Override
        public Readable getReadable() {
            return this.outParameters;
        }
    }

    private static final class RowSegmentImpl
    implements Result.RowSegment,
    ReadableSegment {
        private final Row row;

        private RowSegmentImpl(Row row) {
            this.row = row;
        }

        public Row row() {
            return this.row;
        }

        @Override
        public Readable getReadable() {
            return this.row;
        }
    }

    private static interface ReadableSegment
    extends Result.Segment {
        public Readable getReadable();
    }

    private static final class FilteredResult
    extends OracleResultImpl {
        private final OracleResultImpl result;
        private final Predicate<Result.Segment> filter;

        private FilteredResult(OracleResultImpl result, Predicate<Result.Segment> filter) {
            this.result = result;
            this.filter = filter;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return this.result.publishSegments(Result.Segment.class, segment -> this.filter.test((Result.Segment)segment) ? mappingFunction.apply((Result.Segment)segment) : FILTERED);
        }
    }

    private static final class WarningResult
    extends OracleResultImpl {
        private final SQLWarning warning;
        private final OracleResultImpl result;

        private WarningResult(SQLWarning warning, OracleResultImpl result) {
            this.warning = warning;
            this.result = result;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return Flux.fromStream(Stream.iterate(this.warning, Objects::nonNull, SQLWarning::getNextWarning).map(OracleR2dbcExceptions::toR2dbcException).map((? super T x$0) -> new MessageImpl((R2dbcException)((Object)x$0)))).map(mappingFunction).concatWith((Publisher)(this.result != null ? this.result.publishSegments(Result.Segment.class, mappingFunction) : Mono.empty()));
        }
    }

    private static final class ErrorResult
    extends OracleResultImpl {
        private final R2dbcException r2dbcException;

        private ErrorResult(R2dbcException r2dbcException) {
            this.r2dbcException = r2dbcException;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return Mono.just((Object)new MessageImpl(this.r2dbcException)).map(mappingFunction);
        }
    }

    private static final class BatchUpdateErrorResult
    extends OracleResultImpl {
        private final BatchUpdateResult batchUpdateResult;
        private final ErrorResult errorResult;

        private BatchUpdateErrorResult(BatchUpdateException batchUpdateException) {
            this.batchUpdateResult = new BatchUpdateResult(batchUpdateException.getLargeUpdateCounts());
            this.errorResult = new ErrorResult(OracleR2dbcExceptions.toR2dbcException(batchUpdateException));
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return Flux.concat((Publisher[])new Publisher[]{this.batchUpdateResult.publishSegments(mappingFunction), this.errorResult.publishSegments(mappingFunction)});
        }
    }

    private static final class BatchUpdateResult
    extends OracleResultImpl {
        private final long[] updateCounts;

        private BatchUpdateResult(long[] updateCounts) {
            this.updateCounts = updateCounts;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return Flux.fromStream(LongStream.of(this.updateCounts).mapToObj(x$0 -> new UpdateCountImpl(x$0))).map(mappingFunction);
        }
    }

    private static final class CallResult
    extends OracleResultImpl {
        private final OutParameters outParameters;
        private final ReactiveJdbcAdapter adapter;

        private CallResult(OutParameters outParameters, ReactiveJdbcAdapter adapter) {
            this.outParameters = outParameters;
            this.adapter = adapter;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return this.adapter.getLock().get(() -> mappingFunction.apply(new OutSegmentImpl(this.outParameters)));
        }
    }

    private static final class GeneratedKeysResult
    extends OracleResultImpl {
        private final OracleResultImpl updateCountResult;
        private final OracleResultImpl generatedKeysResult;

        private GeneratedKeysResult(long updateCount, ResultSet generatedKeys, ReactiveJdbcAdapter adapter) {
            this.updateCountResult = GeneratedKeysResult.createUpdateCountResult(updateCount);
            this.generatedKeysResult = GeneratedKeysResult.createQueryResult(generatedKeys, adapter);
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return Flux.from(this.updateCountResult.publishSegments(mappingFunction)).concatWith(this.generatedKeysResult.publishSegments(mappingFunction));
        }
    }

    private static final class ResultSetResult
    extends OracleResultImpl {
        private final ResultSet resultSet;
        private final ReadablesMetadata.RowMetadataImpl metadata;
        private final ReactiveJdbcAdapter adapter;

        private ResultSetResult(ResultSet resultSet, ReactiveJdbcAdapter adapter) {
            this.resultSet = resultSet;
            this.metadata = ReadablesMetadata.createRowMetadata(OracleR2dbcExceptions.fromJdbc(resultSet::getMetaData));
            this.adapter = adapter;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            ReusableJdbcReadable reusableJdbcReadable = new ReusableJdbcReadable();
            Row row = OracleReadableImpl.createRow(reusableJdbcReadable, this.metadata, this.adapter);
            return this.adapter.publishRows(this.resultSet, jdbcReadable -> {
                reusableJdbcReadable.current = jdbcReadable;
                return mappingFunction.apply(new RowSegmentImpl(row));
            });
        }

        private static final class ReusableJdbcReadable
        implements ReactiveJdbcAdapter.JdbcReadable {
            ReactiveJdbcAdapter.JdbcReadable current = null;

            private ReusableJdbcReadable() {
            }

            @Override
            public <T> T getObject(int index, Class<T> type) {
                return this.current.getObject(index, type);
            }
        }
    }

    private static final class UpdateCountResult
    extends OracleResultImpl {
        private final long updateCount;

        private UpdateCountResult(long updateCount) {
            this.updateCount = updateCount;
        }

        @Override
        <T> Publisher<T> publishSegments(Function<Result.Segment, T> mappingFunction) {
            return this.updateCount >= 0L ? Mono.just((Object)new UpdateCountImpl(this.updateCount)).map(mappingFunction) : Mono.empty();
        }
    }
}

