/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Batch;
import java.sql.Connection;
import java.time.Duration;
import java.util.LinkedList;
import java.util.Queue;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleResultImpl;
import oracle.r2dbc.impl.OracleStatementImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

final class OracleBatchImpl
implements Batch {
    private final ReactiveJdbcAdapter adapter;
    private final Connection jdbcConnection;
    private final Duration timeout;
    private Queue<OracleStatementImpl> statements = new LinkedList<OracleStatementImpl>();

    OracleBatchImpl(Duration timeout, Connection jdbcConnection, ReactiveJdbcAdapter adapter) {
        this.timeout = timeout;
        this.jdbcConnection = OracleR2dbcExceptions.requireNonNull(jdbcConnection, "jdbcConnection is null");
        this.adapter = OracleR2dbcExceptions.requireNonNull(adapter, "adapter is null");
    }

    public Batch add(String sql) {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        OracleR2dbcExceptions.requireNonNull(sql, "sql is null");
        this.statements.add(new OracleStatementImpl(sql, this.timeout, this.jdbcConnection, this.adapter));
        return this;
    }

    public Publisher<OracleResultImpl> execute() {
        OracleR2dbcExceptions.requireOpenConnection(this.jdbcConnection);
        Queue<OracleStatementImpl> currentStatements = this.statements;
        this.statements = new LinkedList<OracleStatementImpl>();
        return Flux.fromIterable(currentStatements).concatMap(OracleStatementImpl::execute);
    }
}

