/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleResultImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import oracle.r2dbc.impl.SqlParameterParser;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleStatementImpl
implements Statement {
    private static final Object BIND_NOT_SET = new Object();
    private final Connection jdbcConnection;
    private final ReactiveJdbcAdapter adapter;
    private final String sql;
    private final List<String> parameterNames;
    private Collection<DeferredBind> deferredBinds = new ArrayList<DeferredBind>();
    private final Object[] bindValues;
    private Queue<Object[]> batch = new LinkedList<Object[]>();
    private int fetchSize = 0;
    private String[] generatedColumns = null;

    OracleStatementImpl(ReactiveJdbcAdapter adapter, Connection jdbcConnection, String sql) {
        this.adapter = adapter;
        this.jdbcConnection = jdbcConnection;
        this.sql = sql;
        this.parameterNames = SqlParameterParser.parse(sql);
        this.bindValues = new Object[this.parameterNames.size()];
        Arrays.fill(this.bindValues, BIND_NOT_SET);
    }

    public Statement bind(int index, Object value) {
        OracleR2dbcExceptions.requireNonNull(value, "value must not be null");
        this.requireValidIndex(index);
        this.bindValues[index] = this.convertToJdbcBindValue(value);
        return this;
    }

    public Statement bind(String identifier, Object value) {
        OracleR2dbcExceptions.requireNonNull(identifier, "identifier must not be null");
        OracleR2dbcExceptions.requireNonNull(value, "value must not be null");
        this.bindValues[this.indexOfIdentifier((String)identifier)] = this.convertToJdbcBindValue(value);
        return this;
    }

    public Statement bindNull(int index, Class<?> type) {
        OracleR2dbcExceptions.requireNonNull(type, "class type must not be null");
        this.requireValidIndex(index);
        this.bindValues[index] = null;
        return this;
    }

    public Statement bindNull(String identifier, Class<?> type) {
        OracleR2dbcExceptions.requireNonNull(identifier, "identifier must not be null");
        OracleR2dbcExceptions.requireNonNull(type, "class type must not be null");
        this.bindValues[this.indexOfIdentifier((String)identifier)] = null;
        return this;
    }

    public Statement add() {
        OracleStatementImpl.requireAllParametersSet(this.bindValues);
        this.batch.add((Object[])this.bindValues.clone());
        Arrays.fill(this.bindValues, BIND_NOT_SET);
        return this;
    }

    public Statement returnGeneratedValues(String ... columns) {
        OracleR2dbcExceptions.requireNonNull(columns, "Column names are null");
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != null) continue;
            throw new IllegalArgumentException("Null column name at index: " + i);
        }
        this.generatedColumns = (String[])columns.clone();
        return this;
    }

    public Statement fetchSize(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException("Fetch size is less than zero: " + rows);
        }
        this.fetchSize = rows;
        return this;
    }

    public Publisher<? extends Result> execute() {
        if (this.batch.isEmpty()) {
            this.add();
        } else {
            this.addImplicit();
        }
        Publisher<Result> resultPublisher = this.createResultPublisher(this.batch, this.fetchSize, this.generatedColumns);
        this.batch = new LinkedList<Object[]>();
        Collection<DeferredBind> currentDeferredBinds = this.deferredBinds;
        this.deferredBinds = new ArrayList<DeferredBind>();
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> {
            if (isSubscribed.compareAndSet(false, true)) {
                return OracleStatementImpl.materializeDeferredBinds(currentDeferredBinds).thenMany(resultPublisher).concatWith((Publisher)OracleStatementImpl.discardDeferredBinds(currentDeferredBinds).cast(Result.class));
            }
            return Mono.error((Throwable)new IllegalStateException("Multiple subscribers are not supported by the Oracle R2DBC Statement.execute() publisher"));
        });
    }

    private Publisher<Result> createResultPublisher(Queue<Object[]> batch, int fetchSize, String[] generatedColumns) {
        return Mono.from(this.adapter.publishPreparedStatement(this.sql, generatedColumns, this.jdbcConnection)).flatMapMany(preparedStatement -> {
            OracleR2dbcExceptions.runOrHandleSQLException(() -> preparedStatement.setFetchSize(fetchSize));
            return batch.size() == 1 ? (generatedColumns == null ? this.executeSingle((PreparedStatement)preparedStatement, (Object[])batch.remove()) : this.executeGeneratingValues((PreparedStatement)preparedStatement, (Object[])batch.remove())) : this.executeBatch((PreparedStatement)preparedStatement, batch);
        });
    }

    private Publisher<Result> executeSingle(PreparedStatement jdbcStatement, Object[] bindValues) {
        OracleStatementImpl.setJdbcBindValues(bindValues, jdbcStatement);
        return Mono.from(this.adapter.publishSQLExecution(jdbcStatement)).map(isResultSet -> {
            if (isResultSet.booleanValue()) {
                OracleR2dbcExceptions.runOrHandleSQLException(jdbcStatement::closeOnCompletion);
                return OracleResultImpl.createQueryResult(this.adapter, OracleR2dbcExceptions.getOrHandleSQLException(jdbcStatement::getResultSet));
            }
            int updateCount = OracleR2dbcExceptions.getOrHandleSQLException(jdbcStatement::getUpdateCount);
            OracleR2dbcExceptions.runOrHandleSQLException(jdbcStatement::close);
            return OracleResultImpl.createUpdateCountResult(updateCount);
        });
    }

    private Publisher<Result> executeBatch(PreparedStatement jdbcStatement, Queue<Object[]> batch) {
        while (!batch.isEmpty()) {
            Object[] batchValues = batch.remove();
            OracleStatementImpl.setJdbcBindValues(batchValues, jdbcStatement);
            OracleR2dbcExceptions.runOrHandleSQLException(jdbcStatement::addBatch);
        }
        OracleR2dbcExceptions.runOrHandleSQLException(jdbcStatement::closeOnCompletion);
        return Flux.from(this.adapter.publishBatchUpdate(jdbcStatement)).map(updateCount -> OracleResultImpl.createUpdateCountResult(Math.toIntExact(updateCount)));
    }

    private Publisher<Result> executeGeneratingValues(PreparedStatement jdbcStatement, Object[] bindValues) {
        OracleStatementImpl.setJdbcBindValues(bindValues, jdbcStatement);
        return Mono.from(this.adapter.publishSQLExecution(jdbcStatement)).flatMap(isResultSet -> {
            OracleR2dbcExceptions.runOrHandleSQLException(jdbcStatement::closeOnCompletion);
            return isResultSet.booleanValue() ? Mono.just((Object)OracleResultImpl.createQueryResult(this.adapter, OracleR2dbcExceptions.getOrHandleSQLException(jdbcStatement::getResultSet))) : Mono.from(OracleResultImpl.createGeneratedValuesResult(this.adapter, OracleR2dbcExceptions.getOrHandleSQLException(jdbcStatement::getUpdateCount), OracleR2dbcExceptions.getOrHandleSQLException(jdbcStatement::getGeneratedKeys)));
        });
    }

    private void addImplicit() {
        if (this.bindValues.length != 0 && this.bindValues[0] != BIND_NOT_SET) {
            this.add();
        } else {
            for (int i = 1; i < this.bindValues.length; ++i) {
                if (this.bindValues[i] == BIND_NOT_SET) continue;
                throw new IllegalStateException("One or more parameters are not set");
            }
        }
    }

    private void requireValidIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Parameter index is non-positive: " + index);
        }
        if (index >= this.parameterNames.size()) {
            throw new IndexOutOfBoundsException("Parameter index is out of range: " + index + ". Largest index is: " + (this.parameterNames.size() - 1));
        }
    }

    private int indexOfIdentifier(String identifier) {
        int index = this.parameterNames.indexOf(identifier);
        if (index == -1) {
            throw new IllegalArgumentException("Unrecognized parameter identifier: " + identifier);
        }
        return index;
    }

    private Object convertToJdbcBindValue(Object bindValue) {
        if (bindValue == null) {
            return bindValue;
        }
        if (bindValue instanceof Blob) {
            return this.convertBlobBind((Blob)bindValue);
        }
        if (bindValue instanceof Clob) {
            return this.convertClobBind((Clob)bindValue);
        }
        if (bindValue instanceof ByteBuffer) {
            return this.convertByteBufferBind((ByteBuffer)bindValue);
        }
        if (this.adapter.isSupportedBindType(bindValue.getClass())) {
            return bindValue;
        }
        throw new IllegalArgumentException("Unsupported Java type: " + bindValue.getClass());
    }

    private static void setJdbcBindValues(Object[] values, PreparedStatement jdbcStatement) {
        OracleR2dbcExceptions.runOrHandleSQLException(() -> {
            for (int i = 0; i < values.length; ++i) {
                Object bindValue = values[i];
                if (bindValue == null) {
                    jdbcStatement.setNull(i + 1, 0);
                    continue;
                }
                if (bindValue instanceof String) {
                    jdbcStatement.setNString(i + 1, (String)bindValue);
                    continue;
                }
                if (bindValue instanceof Reader) {
                    jdbcStatement.setNCharacterStream(i + 1, (Reader)bindValue);
                    continue;
                }
                jdbcStatement.setObject(i + 1, bindValue);
            }
        });
    }

    private static void requireAllParametersSet(Object[] bindValues) {
        for (Object value : bindValues) {
            if (value != BIND_NOT_SET) continue;
            throw new IllegalStateException("One or more parameters are not set");
        }
    }

    private static Mono<Void> materializeDeferredBinds(Collection<DeferredBind> deferredBinds) {
        if (deferredBinds.isEmpty()) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            Mono allMaterialized = Mono.empty();
            for (DeferredBind deferredBind : deferredBinds) {
                allMaterialized = allMaterialized.then(deferredBind.materialize());
            }
            return allMaterialized;
        }).cache();
    }

    private static Mono<Void> discardDeferredBinds(Collection<DeferredBind> deferredBinds) {
        if (deferredBinds.isEmpty()) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            Mono allDiscarded = Mono.empty();
            for (DeferredBind deferredBind : deferredBinds) {
                allDiscarded = allDiscarded.then(deferredBind.discard());
            }
            return allDiscarded;
        }).cache();
    }

    private java.sql.Blob convertBlobBind(final Blob r2dbcBlob) {
        final java.sql.Blob jdbcBlob = OracleR2dbcExceptions.getOrHandleSQLException(this.jdbcConnection::createBlob);
        this.deferredBinds.add(new DeferredBind(){

            @Override
            public Mono<Void> materialize() {
                return Mono.from(OracleStatementImpl.this.adapter.publishBlobWrite((Publisher<ByteBuffer>)r2dbcBlob.stream(), jdbcBlob));
            }

            @Override
            public Mono<Void> discard() {
                return Mono.from(OracleStatementImpl.this.adapter.publishBlobFree(jdbcBlob));
            }
        });
        return jdbcBlob;
    }

    private java.sql.Clob convertClobBind(final Clob r2dbcClob) {
        final java.sql.Clob jdbcClob = OracleR2dbcExceptions.getOrHandleSQLException(this.jdbcConnection::createNClob);
        this.deferredBinds.add(new DeferredBind(){

            @Override
            public Mono<Void> materialize() {
                return Mono.from(OracleStatementImpl.this.adapter.publishClobWrite((Publisher<? extends CharSequence>)r2dbcClob.stream(), jdbcClob));
            }

            @Override
            public Mono<Void> discard() {
                return Mono.from(OracleStatementImpl.this.adapter.publishClobFree(jdbcClob));
            }
        });
        return jdbcClob;
    }

    private byte[] convertByteBufferBind(ByteBuffer byteBuffer) {
        ByteBuffer slice = byteBuffer.slice();
        byte[] byteArray = new byte[slice.remaining()];
        slice.get(byteArray);
        return byteArray;
    }

    private static interface DeferredBind {
        public Mono<Void> materialize();

        public Mono<Void> discard();
    }
}

