/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.RowMetadata;
import java.lang.reflect.Array;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import oracle.r2dbc.impl.OracleColumnMetadataImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;

final class OracleRowMetadataImpl
implements RowMetadata {
    private final List<OracleColumnMetadataImpl> columnMetadataList;
    private final HashMap<String, Integer> columnNameIndexes;
    private final ColumnNamesCollection columnNames;

    OracleRowMetadataImpl(ResultSetMetaData resultSetMetaData) {
        int columnCount = OracleR2dbcExceptions.getOrHandleSQLException(resultSetMetaData::getColumnCount);
        OracleColumnMetadataImpl[] columnMetadataArray = new OracleColumnMetadataImpl[columnCount];
        this.columnNameIndexes = new HashMap(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            columnMetadataArray[i] = OracleColumnMetadataImpl.fromResultSetMetaData(resultSetMetaData, i);
            this.columnNameIndexes.putIfAbsent(columnMetadataArray[i].getName().toLowerCase(), i);
        }
        this.columnMetadataList = Collections.unmodifiableList(Arrays.asList(columnMetadataArray));
        this.columnNames = new ColumnNamesCollection();
    }

    public OracleColumnMetadataImpl getColumnMetadata(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index: " + index);
        }
        if (index > this.columnMetadataList.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + index + " exceeds the maximum column index: " + this.columnMetadataList.size());
        }
        return this.columnMetadataList.get(index);
    }

    public OracleColumnMetadataImpl getColumnMetadata(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        int index = this.getColumnIndex(name);
        if (index == -1) {
            throw new NoSuchElementException("No column found with name: " + name);
        }
        return this.columnMetadataList.get(index);
    }

    public Iterable<OracleColumnMetadataImpl> getColumnMetadatas() {
        return this.columnMetadataList;
    }

    public Collection<String> getColumnNames() {
        return this.columnNames;
    }

    int getColumnIndex(String name) {
        Integer index = this.columnNameIndexes.get(name.toLowerCase());
        return index == null ? -1 : index;
    }

    private final class ColumnNamesCollection
    implements Collection<String> {
        private ColumnNamesCollection() {
        }

        @Override
        public boolean contains(Object name) {
            if (name == null) {
                throw new NullPointerException("Argument is null");
            }
            if (!(name instanceof String)) {
                throw new ClassCastException("Argument's type is not a String: " + name.getClass());
            }
            return OracleRowMetadataImpl.this.getColumnIndex((String)name) != -1;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            Objects.requireNonNull(collection, "collection is null");
            for (Object element : collection) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < OracleRowMetadataImpl.this.columnMetadataList.size();
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return OracleRowMetadataImpl.this.columnMetadataList.get(this.index++).getName();
                }
            };
        }

        public String[] toArray() {
            String[] namesArray = new String[OracleRowMetadataImpl.this.columnMetadataList.size()];
            for (int i = 0; i < namesArray.length; ++i) {
                namesArray[i] = OracleRowMetadataImpl.this.columnMetadataList.get(i).getName();
            }
            return namesArray;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Objects.requireNonNull(array, "array is null");
            int size = OracleRowMetadataImpl.this.columnMetadataList.size();
            if (array.length < size) {
                array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            } else if (array.length > size) {
                array[size] = null;
            }
            for (int i = 0; i < size; ++i) {
                array[i] = OracleRowMetadataImpl.this.columnMetadataList.get(i).getName();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> generator) {
            Objects.requireNonNull(generator, "generator is null");
            T[] array = generator.apply(OracleRowMetadataImpl.this.columnMetadataList.size());
            for (int i = 0; i < OracleRowMetadataImpl.this.columnMetadataList.size(); ++i) {
                array[i] = OracleRowMetadataImpl.this.columnMetadataList.get(i).getName();
            }
            return array;
        }

        @Override
        public int size() {
            return OracleRowMetadataImpl.this.columnMetadataList.size();
        }

        @Override
        public boolean isEmpty() {
            return OracleRowMetadataImpl.this.columnMetadataList.isEmpty();
        }

        @Override
        public boolean add(String o) {
            throw this.modificationNotSupported();
        }

        @Override
        public boolean remove(Object o) {
            throw this.modificationNotSupported();
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw this.modificationNotSupported();
        }

        @Override
        public boolean removeIf(Predicate<? super String> filter) {
            throw this.modificationNotSupported();
        }

        @Override
        public void clear() {
            throw this.modificationNotSupported();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw this.modificationNotSupported();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw this.modificationNotSupported();
        }

        private UnsupportedOperationException modificationNotSupported() {
            return new UnsupportedOperationException("The getColumnNames() Collection is unmodifiable");
        }
    }
}

