/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.Row;
import java.nio.ByteBuffer;
import java.sql.NClob;
import oracle.r2dbc.impl.OracleLargeObjects;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleRowMetadataImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;

final class OracleRowImpl
implements Row {
    private final ReactiveJdbcAdapter adapter;
    private final ReactiveJdbcAdapter.JdbcRow jdbcRow;
    private final OracleRowMetadataImpl rowMetadata;

    OracleRowImpl(ReactiveJdbcAdapter.JdbcRow jdbcRow, OracleRowMetadataImpl rowMetadata, ReactiveJdbcAdapter adapter) {
        this.adapter = adapter;
        this.jdbcRow = jdbcRow;
        this.rowMetadata = rowMetadata;
    }

    public Object get(int index) {
        this.requireValidIndex(index);
        return this.convertColumnValue(index, this.rowMetadata.getColumnMetadata(index).getJavaType());
    }

    public <T> T get(int index, Class<T> type) {
        OracleR2dbcExceptions.requireNonNull(type, "type must not be null");
        this.requireValidIndex(index);
        return this.convertColumnValue(index, type);
    }

    public Object get(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name must not be null");
        int columnIndex = this.getColumnIndex(name);
        return this.convertColumnValue(columnIndex, this.rowMetadata.getColumnMetadata(columnIndex).getJavaType());
    }

    public <T> T get(String name, Class<T> type) {
        OracleR2dbcExceptions.requireNonNull(name, "name must not be null");
        OracleR2dbcExceptions.requireNonNull(type, "type must not be null");
        return this.convertColumnValue(this.getColumnIndex(name), type);
    }

    private int getColumnIndex(String name) {
        int columnIndex = this.rowMetadata.getColumnIndex(name);
        if (columnIndex != -1) {
            return columnIndex;
        }
        throw new IllegalArgumentException("Unrecognized name: " + name);
    }

    private <T> T convertColumnValue(int index, Class<T> type) {
        this.requireSupportedTypeMapping(index, type);
        if (type.equals(ByteBuffer.class)) {
            return type.cast(this.getByteBuffer(index));
        }
        if (type.equals(Blob.class)) {
            return type.cast(this.getBlob(index));
        }
        if (type.equals(Clob.class)) {
            return type.cast(this.getClob(index));
        }
        return this.jdbcRow.getObject(index, type);
    }

    private ByteBuffer getByteBuffer(int index) {
        byte[] columnValue = this.jdbcRow.getObject(index, byte[].class);
        return columnValue == null ? null : ByteBuffer.wrap(columnValue);
    }

    private Blob getBlob(int index) {
        java.sql.Blob jdbcBlob = this.jdbcRow.getObject(index, java.sql.Blob.class);
        return jdbcBlob == null ? null : OracleLargeObjects.createBlob(this.adapter.publishBlobRead(jdbcBlob), this.adapter.publishBlobFree(jdbcBlob));
    }

    private Clob getClob(int index) {
        Integer columnTypeCode = this.rowMetadata.getColumnMetadata(index).getNativeTypeMetadata().getVendorTypeNumber();
        boolean isNChar = columnTypeCode != null && (columnTypeCode == 2011 || columnTypeCode == -15 || columnTypeCode == -9 || columnTypeCode == -16);
        java.sql.Clob jdbcClob = isNChar ? (java.sql.Clob)this.jdbcRow.getObject(index, NClob.class) : this.jdbcRow.getObject(index, java.sql.Clob.class);
        return jdbcClob == null ? null : OracleLargeObjects.createClob(this.adapter.publishClobRead(jdbcClob), this.adapter.publishClobFree(jdbcClob));
    }

    private void requireValidIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index is less than zero: " + index);
        }
        if (index >= this.rowMetadata.getColumnNames().size()) {
            throw new IllegalArgumentException("Index " + index + " is greater than or equal to column count: " + this.rowMetadata.getColumnNames().size());
        }
    }

    private void requireSupportedTypeMapping(int index, Class<?> type) {
        Integer sqlTypeCode = this.rowMetadata.getColumnMetadata(index).getNativeTypeMetadata().getVendorTypeNumber();
        if (sqlTypeCode == null) {
            return;
        }
        switch (sqlTypeCode) {
            case 2004: {
                if (type.equals(Blob.class)) break;
                throw this.unsupportedTypeMapping("BLOB", index, type);
            }
            case 2005: {
                if (type.equals(Clob.class)) break;
                throw this.unsupportedTypeMapping("CLOB", index, type);
            }
        }
    }

    private R2dbcException unsupportedTypeMapping(String sqlTypeName, int index, Class<?> type) {
        return OracleR2dbcExceptions.newNonTransientException(String.format("Unsupported SQL to Java type mapping. SQL Type: %s, Column Index: %d, Java Type: %s", sqlTypeName, index, type.getName()), null);
    }
}

