/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.R2dbcBadGrammarException;
import io.r2dbc.spi.R2dbcDataIntegrityViolationException;
import io.r2dbc.spi.R2dbcException;
import io.r2dbc.spi.R2dbcNonTransientException;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.R2dbcRollbackException;
import io.r2dbc.spi.R2dbcTimeoutException;
import io.r2dbc.spi.R2dbcTransientException;
import io.r2dbc.spi.R2dbcTransientResourceException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.function.Supplier;

final class OracleR2dbcExceptions {
    private OracleR2dbcExceptions() {
    }

    static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        return obj;
    }

    static R2dbcException toR2dbcException(SQLException sqlException) {
        assert (sqlException != null) : "sqlException is null";
        String message = sqlException.getMessage();
        String sqlState = sqlException.getSQLState();
        int errorCode = sqlException.getErrorCode();
        if (sqlException instanceof SQLNonTransientException) {
            if (sqlException instanceof SQLSyntaxErrorException) {
                return new R2dbcBadGrammarException(message, sqlState, errorCode, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLIntegrityConstraintViolationException) {
                return new R2dbcDataIntegrityViolationException(message, sqlState, errorCode, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLNonTransientConnectionException) {
                return new R2dbcNonTransientResourceException(message, sqlState, errorCode, (Throwable)sqlException);
            }
            return new OracleR2dbcNonTransientException(message, sqlState, errorCode, sqlException);
        }
        if (sqlException instanceof SQLTransientException) {
            if (sqlException instanceof SQLTimeoutException) {
                return new R2dbcTimeoutException(message, sqlState, errorCode, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLTransactionRollbackException) {
                return new R2dbcRollbackException(message, sqlState, errorCode, (Throwable)sqlException);
            }
            if (sqlException instanceof SQLTransientConnectionException) {
                return new R2dbcTransientResourceException(message, sqlState, errorCode, (Throwable)sqlException);
            }
            return new OracleR2dbcTransientException(message, sqlState, errorCode, sqlException);
        }
        if (sqlException instanceof SQLRecoverableException) {
            return new R2dbcTransientResourceException(message, sqlState, errorCode, (Throwable)sqlException);
        }
        return new OracleR2dbcException(message, sqlState, errorCode, sqlException);
    }

    static void runOrHandleSQLException(ThrowingRunnable runnable) throws R2dbcException {
        try {
            runnable.runOrThrow();
        }
        catch (SQLException sqlException) {
            throw OracleR2dbcExceptions.toR2dbcException(sqlException);
        }
    }

    static <T> T getOrHandleSQLException(ThrowingSupplier<T> supplier) throws R2dbcException {
        try {
            return supplier.getOrThrow();
        }
        catch (SQLException sqlException) {
            throw OracleR2dbcExceptions.toR2dbcException(sqlException);
        }
    }

    static R2dbcNonTransientException newNonTransientException(String message, Throwable cause) {
        return new OracleR2dbcNonTransientException(message, null, 0, cause);
    }

    private static final class OracleR2dbcNonTransientException
    extends R2dbcNonTransientException {
        private OracleR2dbcNonTransientException(String message, String sqlState, int errorCode, Throwable cause) {
            super(message, sqlState, errorCode, cause);
        }
    }

    private static final class OracleR2dbcTransientException
    extends R2dbcTransientException {
        private OracleR2dbcTransientException(String message, String sqlState, int errorCode, SQLException sqlException) {
            super(message, sqlState, errorCode, (Throwable)sqlException);
        }
    }

    private static final class OracleR2dbcException
    extends R2dbcException {
        private OracleR2dbcException(String message, String sqlState, int errorCode, SQLException sqlException) {
            super(message, sqlState, errorCode, (Throwable)sqlException);
        }
    }

    @FunctionalInterface
    static interface ThrowingSupplier<T>
    extends Supplier<T> {
        public T getOrThrow() throws SQLException;

        @Override
        default public T get() throws R2dbcException {
            return OracleR2dbcExceptions.getOrHandleSQLException(this);
        }
    }

    @FunctionalInterface
    static interface ThrowingRunnable
    extends Runnable {
        public void runOrThrow() throws SQLException;

        @Override
        default public void run() throws R2dbcException {
            OracleR2dbcExceptions.runOrHandleSQLException(this);
        }
    }
}

