/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Batch;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.ValidationDepth;
import java.sql.Connection;
import oracle.r2dbc.impl.OracleBatchImpl;
import oracle.r2dbc.impl.OracleConnectionMetadataImpl;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleStatementImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

final class OracleConnectionImpl
implements io.r2dbc.spi.Connection {
    private final ReactiveJdbcAdapter adapter;
    private final Connection jdbcConnection;

    OracleConnectionImpl(ReactiveJdbcAdapter adapter, Connection jdbcConnection) {
        this.adapter = adapter;
        this.jdbcConnection = jdbcConnection;
    }

    public Publisher<Void> beginTransaction() {
        String isolationLevel;
        int jdbcIsolationLevel = OracleR2dbcExceptions.getOrHandleSQLException(this.jdbcConnection::getTransactionIsolation);
        switch (jdbcIsolationLevel) {
            case 2: {
                isolationLevel = "READ COMMITTED";
                break;
            }
            case 8: {
                isolationLevel = "SERIALIZABLE";
                break;
            }
            default: {
                throw OracleR2dbcExceptions.newNonTransientException("Unrecognized JDBC transaction isolation level: " + jdbcIsolationLevel, null);
            }
        }
        return Mono.from(this.setAutoCommit(false)).then(Mono.from((Publisher)this.createStatement("SET TRANSACTION ISOLATION LEVEL " + isolationLevel).execute()).flatMap(result -> Mono.from((Publisher)result.getRowsUpdated())).then()).cache();
    }

    public Publisher<Void> close() {
        return this.adapter.publishClose(this.jdbcConnection);
    }

    public Publisher<Void> commitTransaction() {
        return this.adapter.publishCommit(this.jdbcConnection);
    }

    public Batch createBatch() {
        this.requireOpenConnection();
        return new OracleBatchImpl(this.adapter, this.jdbcConnection);
    }

    public Statement createStatement(String sql) {
        OracleR2dbcExceptions.requireNonNull(sql, "sql is null");
        this.requireOpenConnection();
        return new OracleStatementImpl(this.adapter, this.jdbcConnection, sql);
    }

    public boolean isAutoCommit() {
        this.requireOpenConnection();
        return OracleR2dbcExceptions.getOrHandleSQLException(this.jdbcConnection::getAutoCommit);
    }

    public ConnectionMetadata getMetadata() {
        this.requireOpenConnection();
        return new OracleConnectionMetadataImpl(OracleR2dbcExceptions.getOrHandleSQLException(this.jdbcConnection::getMetaData));
    }

    public Publisher<Void> createSavepoint(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        throw new UnsupportedOperationException("createSavepoint not supported");
    }

    public Publisher<Void> releaseSavepoint(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        return Mono.empty();
    }

    public Publisher<Void> rollbackTransaction() {
        return this.adapter.publishRollback(this.jdbcConnection);
    }

    public Publisher<Void> rollbackTransactionToSavepoint(String name) {
        OracleR2dbcExceptions.requireNonNull(name, "name is null");
        throw new UnsupportedOperationException("rollbackTransactionToSavepoint not supported");
    }

    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        return Mono.defer(() -> OracleR2dbcExceptions.getOrHandleSQLException(() -> {
            if (autoCommit == this.jdbcConnection.getAutoCommit()) {
                return Mono.empty();
            }
            if (!autoCommit) {
                this.jdbcConnection.setAutoCommit(false);
                return Mono.empty();
            }
            return Mono.from(this.commitTransaction()).doOnSuccess(nil -> OracleR2dbcExceptions.runOrHandleSQLException(() -> this.jdbcConnection.setAutoCommit(true)));
        })).cache();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        this.requireOpenConnection();
        return IsolationLevel.READ_COMMITTED;
    }

    public Publisher<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        OracleR2dbcExceptions.requireNonNull(isolationLevel, "isolationLevel is null");
        if (isolationLevel.equals(IsolationLevel.READ_COMMITTED)) {
            return Mono.empty();
        }
        return Mono.error((Throwable)OracleR2dbcExceptions.newNonTransientException("Oracle R2DBC does not support isolation level: " + isolationLevel, null));
    }

    public Publisher<Boolean> validate(ValidationDepth depth) {
        OracleR2dbcExceptions.requireNonNull(depth, "depth is null");
        return Mono.defer(() -> OracleR2dbcExceptions.getOrHandleSQLException(() -> {
            if (this.jdbcConnection.isClosed()) {
                return Mono.just((Object)false);
            }
            if (depth == ValidationDepth.LOCAL) {
                return Mono.just((Object)true);
            }
            return Mono.from((Publisher)this.createStatement("SELECT 1 FROM sys.dual").execute()).flatMap(result -> Mono.from((Publisher)result.map((row, metadata) -> (Integer)row.get(0, Integer.class)))).map(value -> Integer.valueOf(1).equals(value)).defaultIfEmpty((Object)false).onErrorReturn((Object)false);
        })).cache();
    }

    private void requireOpenConnection() {
        if (OracleR2dbcExceptions.getOrHandleSQLException(this.jdbcConnection::isClosed).booleanValue()) {
            throw new IllegalStateException("Connection is closed");
        }
    }
}

