/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Blob;
import io.r2dbc.spi.Clob;
import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.R2dbcException;
import java.nio.ByteBuffer;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import oracle.jdbc.OracleType;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.sql.json.OracleJsonObject;

final class OracleColumnMetadataImpl
implements ColumnMetadata {
    private static final int OFFSET_DATE_TIME_PRECISION = 35;
    private static final int LOCAL_DATE_TIME_PRECISION = 29;
    private final SQLType sqlType;
    private final Class<?> javaType;
    private final String name;
    private final Nullability nullability;
    private final Integer precision;
    private final Integer scale;

    private OracleColumnMetadataImpl(SQLType sqlType, Class<?> javaType, String name, Nullability nullability, Integer precision, Integer scale) {
        this.sqlType = sqlType;
        this.javaType = javaType;
        this.name = name;
        this.nullability = nullability;
        this.precision = precision;
        this.scale = scale;
    }

    static OracleColumnMetadataImpl fromResultSetMetaData(ResultSetMetaData resultSetMetaData, int index) {
        int jdbcIndex = index + 1;
        int sqlTypeCode = OracleR2dbcExceptions.getOrHandleSQLException(() -> resultSetMetaData.getColumnType(jdbcIndex));
        switch (sqlTypeCode) {
            case 2004: {
                return OracleColumnMetadataImpl.newMetadata(Blob.class, null, resultSetMetaData, jdbcIndex);
            }
            case 2005: 
            case 2011: {
                return OracleColumnMetadataImpl.newMetadata(Clob.class, null, resultSetMetaData, jdbcIndex);
            }
            case 91: {
                return OracleColumnMetadataImpl.newMetadata(LocalDate.class, resultSetMetaData, jdbcIndex);
            }
            case -102: 
            case 93: {
                return OracleColumnMetadataImpl.newMetadata(LocalDateTime.class, 29, resultSetMetaData, jdbcIndex);
            }
            case -101: 
            case 2014: {
                return OracleColumnMetadataImpl.newMetadata(OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE, 35, resultSetMetaData, jdbcIndex);
            }
            case -3: {
                return OracleColumnMetadataImpl.newMetadata(ByteBuffer.class, OracleR2dbcExceptions.getOrHandleSQLException(() -> resultSetMetaData.getColumnDisplaySize(jdbcIndex)), resultSetMetaData, jdbcIndex);
            }
            case -4: 
            case -2: {
                return OracleColumnMetadataImpl.newMetadata(ByteBuffer.class, resultSetMetaData, jdbcIndex);
            }
            case -103: {
                return OracleColumnMetadataImpl.newMetadata(Period.class, resultSetMetaData, jdbcIndex);
            }
            case -104: {
                return OracleColumnMetadataImpl.newMetadata(Duration.class, resultSetMetaData, jdbcIndex);
            }
            case -8: {
                return OracleColumnMetadataImpl.newMetadata(String.class, resultSetMetaData, jdbcIndex);
            }
            case 2016: {
                return OracleColumnMetadataImpl.newMetadata(OracleJsonObject.class, null, resultSetMetaData, jdbcIndex);
            }
        }
        return OracleColumnMetadataImpl.newMetadata(resultSetMetaData, jdbcIndex);
    }

    private static OracleColumnMetadataImpl newMetadata(ResultSetMetaData resultSetMetaData, int jdbcIndex) throws R2dbcException {
        return OracleColumnMetadataImpl.newMetadata(OracleColumnMetadataImpl.getJavaType(resultSetMetaData, jdbcIndex), resultSetMetaData, jdbcIndex);
    }

    private static OracleColumnMetadataImpl newMetadata(Class<?> javaType, ResultSetMetaData resultSetMetaData, int jdbcIndex) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> {
            int precision = resultSetMetaData.getPrecision(jdbcIndex);
            int scale = resultSetMetaData.getScale(jdbcIndex);
            return new OracleColumnMetadataImpl(OracleColumnMetadataImpl.getSqlType(resultSetMetaData, jdbcIndex), javaType, resultSetMetaData.getColumnLabel(jdbcIndex), OracleColumnMetadataImpl.getNullability(resultSetMetaData, jdbcIndex), precision == 0 ? null : Integer.valueOf(precision), scale == 0 ? null : Integer.valueOf(scale));
        });
    }

    private static OracleColumnMetadataImpl newMetadata(Class<?> javaType, Integer precision, ResultSetMetaData resultSetMetaData, int jdbcIndex) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> {
            int scale = resultSetMetaData.getScale(jdbcIndex);
            return new OracleColumnMetadataImpl(OracleColumnMetadataImpl.getSqlType(resultSetMetaData, jdbcIndex), javaType, resultSetMetaData.getColumnLabel(jdbcIndex), OracleColumnMetadataImpl.getNullability(resultSetMetaData, jdbcIndex), precision, scale == 0 ? null : Integer.valueOf(scale));
        });
    }

    private static OracleColumnMetadataImpl newMetadata(Class<?> javaType, SQLType sqlType, Integer precision, ResultSetMetaData resultSetMetaData, int jdbcIndex) {
        return OracleR2dbcExceptions.getOrHandleSQLException(() -> {
            int scale = resultSetMetaData.getScale(jdbcIndex);
            return new OracleColumnMetadataImpl(sqlType, javaType, resultSetMetaData.getColumnLabel(jdbcIndex), OracleColumnMetadataImpl.getNullability(resultSetMetaData, jdbcIndex), precision, scale == 0 ? null : Integer.valueOf(scale));
        });
    }

    private static Class<?> getJavaType(ResultSetMetaData resultSetMetaData, int jdbcIndex) {
        try {
            String className = OracleR2dbcExceptions.getOrHandleSQLException(() -> resultSetMetaData.getColumnClassName(jdbcIndex));
            return className == null ? Object.class : Class.forName(className);
        }
        catch (ClassNotFoundException columnClassNotFound) {
            throw OracleR2dbcExceptions.newNonTransientException("Could not find the Java class type for column at index: " + (jdbcIndex - 1), columnClassNotFound);
        }
    }

    private static Nullability getNullability(ResultSetMetaData resultSetMetaData, int jdbcIndex) {
        int nullability = OracleR2dbcExceptions.getOrHandleSQLException(() -> resultSetMetaData.isNullable(jdbcIndex));
        switch (nullability) {
            case 0: {
                return Nullability.NON_NULL;
            }
            case 1: {
                return Nullability.NULLABLE;
            }
        }
        return Nullability.UNKNOWN;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getName() {
        return this.name;
    }

    public SQLType getNativeTypeMetadata() {
        return this.sqlType;
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    private static SQLType getSqlType(ResultSetMetaData resultSetMetaData, int jdbcIndex) {
        int typeNumber = OracleR2dbcExceptions.getOrHandleSQLException(() -> resultSetMetaData.getColumnType(jdbcIndex));
        for (JDBCType jdbcType : JDBCType.values()) {
            Integer vendorTypeNumber = jdbcType.getVendorTypeNumber();
            if (vendorTypeNumber == null || vendorTypeNumber != typeNumber) continue;
            return jdbcType;
        }
        try {
            OracleType oracleType = OracleType.toOracleType((int)typeNumber);
            return oracleType != null ? oracleType : JDBCType.OTHER;
        }
        catch (SQLException typeNotFound) {
            return JDBCType.OTHER;
        }
    }
}

