/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.OracleStatementImpl;
import oracle.r2dbc.impl.ReactiveJdbcAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class OracleBatchImpl
implements Batch {
    private final ReactiveJdbcAdapter adapter;
    private final Connection jdbcConnection;
    private Queue<Statement> statements = new LinkedList<Statement>();

    OracleBatchImpl(ReactiveJdbcAdapter adapter, Connection jdbcConnection) {
        this.adapter = OracleR2dbcExceptions.requireNonNull(adapter, "adapter is null");
        this.jdbcConnection = OracleR2dbcExceptions.requireNonNull(jdbcConnection, "jdbcConnection is null");
    }

    public Batch add(String sql) {
        OracleR2dbcExceptions.requireNonNull(sql, "sql is null");
        this.statements.add(new OracleStatementImpl(this.adapter, this.jdbcConnection, sql));
        return this;
    }

    public Publisher<? extends Result> execute() {
        Queue<Statement> currentStatements = this.statements;
        this.statements = new LinkedList<Statement>();
        AtomicBoolean isSubscribed = new AtomicBoolean(false);
        return Flux.defer(() -> {
            if (isSubscribed.compareAndSet(false, true)) {
                return Flux.fromIterable((Iterable)currentStatements).concatMap(Statement::execute);
            }
            return Mono.error((Throwable)new IllegalStateException("Multiple subscribers are not supported by the Oracle R2DBC Batch.execute() publisher"));
        });
    }
}

