/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;
import oracle.net.nt.WSSSocketChannel;

public class TcpsNTAdapter
extends TcpNTAdapter {
    private String matchSSLServerCertDNWith;
    private boolean fullDNMatch;
    private String hostNameForDNMatch = null;
    SSLSocketFactory l_sslSockFac;
    Socket underlyingSocket = null;
    SocketChannel underlyingSocketChannel = null;
    SSLSocket socketWithListener;
    SSLEngine l_sslEngine;
    private String httpProxy;
    private int httpProxyPort;
    private String websocketURI = "/sqlnet";
    private final SSLContext sslContext;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    public TcpsNTAdapter(String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws NLException {
        this(string, properties, null, null);
    }

    public TcpsNTAdapter(String string, @Blind(value=PropertiesBlinder.class) Properties properties, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver) throws NLException {
        super(string, properties, oracleHostnameResolver);
        this.sslContext = sSLContext;
    }

    @Override
    protected void initializeProxy() {
        this.readHttpsProxyConfig();
        if (this.httpProxy != null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.httpProxy, this.httpProxyPort));
        } else {
            super.initializeProxy();
        }
    }

    private void readHttpsProxyConfig() {
        NVPair nVPair = this.nav.findNVPair(this.nvpAddr, "HTTPS_PROXY");
        NVPair nVPair2 = this.nav.findNVPair(this.nvpAddr, "HTTPS_PROXY_PORT");
        if (nVPair != null) {
            this.httpProxy = nVPair.getAtom();
            if (nVPair2 != null) {
                this.httpProxyPort = Integer.parseInt(nVPair2.getAtom());
            }
        }
        if (this.httpProxy == null) {
            String string;
            this.httpProxy = (String)this.socketOptions.get(30);
            if (this.httpProxy != null && (string = (String)this.socketOptions.get(31)) != null) {
                this.httpProxyPort = Integer.parseInt(string);
            }
        }
    }

    @Override
    public void connect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        if (!this.useNio.booleanValue()) {
            this.l_sslSockFac = this.newSSLSocketFactory(dMSNoun);
            this.underlyingSocket = new Socket();
        } else {
            this.l_sslEngine = this.newSSLEngine();
        }
        super.connect(dMSNoun);
    }

    @Override
    protected void establishSocket(InetSocketAddress inetSocketAddress, DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        long l2 = System.currentTimeMillis();
        super.establishSocket(inetSocketAddress, dMSNoun);
        try {
            this.underlyingSocket = this.socket;
            this.underlyingSocketChannel = this.socketChannel;
            if (!this.useNio.booleanValue()) {
                this.socket = this.l_sslSockFac.createSocket(this.socket, this.host, this.port, true);
            } else {
                this.socketChannel = new SSLSocketChannel(this.socketChannel, this.l_sslEngine);
                this.socket = this.socketChannel.socket();
            }
            this.setSSLSocketOptions();
            if (this.useNio.booleanValue() && "WSS".equalsIgnoreCase(this.protocol)) {
                NVPair nVPair = this.nav.findNVPair(this.nvpAddr, "WEBSOCK_URI");
                if (nVPair != null) {
                    this.websocketURI = nVPair.getAtom();
                }
                String string = (String)this.socketOptions.get(26);
                OpaqueString opaqueString = (OpaqueString)this.socketOptions.get(27);
                this.socketChannel = new WSSSocketChannel(this.socketChannel, this.websocketURI, this.host, this.port, string, opaqueString);
            }
        }
        catch (IOException iOException) {
            String string = String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", iOException.getMessage(), System.currentTimeMillis() - l2, inetSocketAddress.getHostString(), this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.inetAddresses, this.useNio);
            IOException iOException2 = new IOException(string, iOException);
            throw iOException2;
        }
    }

    @Override
    public final CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if ("WSS".equalsIgnoreCase(this.protocol)) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with the WebSocket Secureprotocol"));
        }
        try {
            this.l_sslEngine = this.newSSLEngine();
        }
        catch (IOException iOException2) {
            return CompletionStageUtil.failedStage(iOException2);
        }
        long l2 = System.currentTimeMillis();
        return super.connectAsync(dMSNoun, asyncOutboundTimeoutHandler, executor).thenCompose(CompletionStageUtil.normalCompletionHandler(void_ -> {
            this.underlyingSocket = this.socket;
            this.underlyingSocketChannel = this.socketChannel;
            SSLSocketChannel sSLSocketChannel = new SSLSocketChannel(this.socketChannel, this.l_sslEngine);
            this.socketChannel = sSLSocketChannel;
            this.socket = this.socketChannel.socket();
            this.setSSLSocketOptions();
            return sSLSocketChannel.doSSLHandshakeAsync(executor);
        })).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            if (this.underlyingSocketChannel != null) {
                throw iOException;
            }
            SocketAddress socketAddress = this.underlyingSocketChannel.getRemoteAddress();
            String string = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : "UNKOWN HOST";
            String string2 = String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", iOException.getMessage(), System.currentTimeMillis() - l2, string, this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.inetAddresses, this.useNio);
            IOException iOException2 = new IOException(string2, iOException);
            throw iOException2;
        }));
    }

    public void renegotiateSession() throws IOException {
        Object object;
        if (this.useNio.booleanValue()) {
            this.l_sslEngine = this.newSSLEngine();
            object = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine);
            if (this.protocol.equalsIgnoreCase("wss")) {
                this.socketChannel.setUnderlyingChannel((SocketChannel)object);
            } else {
                this.socketChannel = object;
            }
            this.socket = this.socketChannel.socket();
        } else {
            this.socketWithListener = (SSLSocket)this.socket;
            this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
        }
        object = (String)this.socketOptions.get(3);
        if (object != null) {
            this.setOption(3, object);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sSLSocket = null;
        if (!this.useNio.booleanValue()) {
            sSLSocket = (SSLSocket)this.socket;
            sSLSocket.setUseClientMode(true);
        }
        TcpsConfigure.configureVersion(sSLSocket, this.l_sslEngine, (String)this.socketOptions.get(6), this.useNio);
        TcpsConfigure.configureCipherSuites(sSLSocket, this.l_sslEngine, (String)this.socketOptions.get(7), this.useNio);
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 108: {
                this.setServerDNMatchValue((String[])object);
                break;
            }
            case 107: {
                if (((String)object).equalsIgnoreCase("TRUE")) {
                    this.fullDNMatch = true;
                    break;
                }
                this.fullDNMatch = false;
                break;
            }
            default: {
                super.setOption(n2, object);
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        SSLSocket sSLSocket = null;
        SSLSession sSLSession = null;
        if (!this.useNio.booleanValue()) {
            sSLSocket = (SSLSocket)this.socket;
            sSLSession = sSLSocket.getSession();
        } else {
            sSLSession = this.l_sslEngine.getSession();
        }
        switch (n2) {
            case 102: {
                String string = sSLSession.getCipherSuite();
                if (string != null && string.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 105: {
                return sSLSession.getCipherSuite();
            }
            case 103: {
                X509Certificate x509Certificate = (X509Certificate)sSLSession.getPeerCertificates()[0];
                return x509Certificate.getSubjectDN().getName();
            }
            case 104: {
                return sSLSession.getPeerCertificateChain();
            }
            case 106: {
                if (this.isDnMatchingEnabled()) {
                    X509Certificate x509Certificate = (X509Certificate)sSLSession.getPeerCertificates()[0];
                    String string = x509Certificate.getSubjectDN().getName();
                    if (TcpsConfigure.matchServerDN(x509Certificate, this.matchSSLServerCertDNWith, this.fullDNMatch, this.hostNameForDNMatch == null ? this.host : this.hostNameForDNMatch)) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "TRUE";
            }
        }
        return super.getOption(n2);
    }

    @Override
    public boolean isDnMatchingEnabled() {
        String string = (String)this.socketOptions.get(4);
        if (string == null) {
            string = System.getProperty("oracle.net.ssl_server_dn_match", (String)this.socketOptions.get(40));
        }
        return string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE");
    }

    public void setServerDNMatchValue(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        this.hostNameForDNMatch = stringArray[3];
        if (string != null) {
            this.matchSSLServerCertDNWith = string;
            this.fullDNMatch = true;
        } else if (string2 != null) {
            this.matchSSLServerCertDNWith = string2.indexOf(46) != -1 ? "CN=" + string2.substring(0, string2.indexOf(46)) : "CN=" + string2.trim();
        } else if (string3 != null) {
            this.matchSSLServerCertDNWith = string3.indexOf(46) != -1 ? "CN=" + string3.substring(0, string3.indexOf(46)) : "CN=" + string3.trim();
        }
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCPS;
    }

    private SSLEngine newSSLEngine() throws IOException {
        if (this.sslContext == null) {
            return CustomSSLSocketFactory.getSSLSocketEngine(this.host, this.port, this.socketOptions);
        }
        SSLEngine sSLEngine = this.sslContext.createSSLEngine(this.host, this.port);
        sSLEngine.setUseClientMode(true);
        return sSLEngine;
    }

    private SSLSocketFactory newSSLSocketFactory(DMSFactory.DMSNoun dMSNoun) throws IOException {
        if (this.sslContext == null) {
            return CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions, dMSNoun);
        }
        SSLSocketFactory sSLSocketFactory = this.sslContext.getSocketFactory();
        sSLSocketFactory = new MetricsEnabledSSLSocketFactoryWrapper(sSLSocketFactory, dMSNoun);
        return sSLSocketFactory;
    }

    static {
        try {
            $$$methodRef$$$17 = TcpsNTAdapter.class.getDeclaredConstructor(String.class, Properties.class, SSLContext.class, OracleHostnameResolver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpsNTAdapter.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpsNTAdapter.class.getDeclaredMethod("lambda$connectAsync$0", Executor.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpsNTAdapter.class.getDeclaredMethod("lambda$connectAsync$1", Long.TYPE, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpsNTAdapter.class.getDeclaredMethod("newSSLSocketFactory", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpsNTAdapter.class.getDeclaredMethod("newSSLEngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpsNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpsNTAdapter.class.getDeclaredMethod("setServerDNMatchValue", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpsNTAdapter.class.getDeclaredMethod("isDnMatchingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpsNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpsNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpsNTAdapter.class.getDeclaredMethod("setSSLSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpsNTAdapter.class.getDeclaredMethod("renegotiateSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpsNTAdapter.class.getDeclaredMethod("connectAsync", DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpsNTAdapter.class.getDeclaredMethod("establishSocket", InetSocketAddress.class, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpsNTAdapter.class.getDeclaredMethod("connect", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpsNTAdapter.class.getDeclaredMethod("readHttpsProxyConfig", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpsNTAdapter.class.getDeclaredMethod("initializeProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

