/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.net.jdbc.TNSAddress.Description;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.nt.ConnectDescription;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavAddressList;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class NavDescription
extends Description
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int descProcessed;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public NavDescription(SchemaObjectFactoryInterface schemaObjectFactoryInterface) {
        super(schemaObjectFactoryInterface);
    }

    @Override
    public void navigate(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        stringBuffer.append("(DESCRIPTION=");
        ConnectDescription connectDescription = connStrategy.newConnectDescription();
        if (this.SDU != null) {
            connectDescription.setSdu(this.getIntValue(this.SDU, connectDescription.getSdu()));
        }
        if (this.TDU != null) {
            connectDescription.setTdu(this.getIntValue(this.TDU, connectDescription.getTdu()));
        }
        if (this.connectTimeout != null) {
            connectDescription.setConnectTimeout(TimeUnitSuffixUtility.getTimeInMilliseconds(this.connectTimeout, true, connectDescription.getConnectTimeout()));
        }
        if (this.transportTimeout != null) {
            connectDescription.setTransportConnectTimeout(TimeUnitSuffixUtility.getTimeInMilliseconds(this.transportTimeout, true, connectDescription.getTransportConnectTimeout()));
        }
        if (this.retryCount != null) {
            connStrategy.retryCount = this.getIntValue(this.retryCount, connStrategy.retryCount);
            connectDescription.setRetryCount(connStrategy.retryCount);
        }
        if (this.delayInMillis != -1) {
            connectDescription.setDelayInMillis(this.delayInMillis);
        }
        if (!this.failover) {
            stringBuffer.append("(FAILOVER=false)");
        }
        if (this.netConnectionIdPrefix != null) {
            connectDescription.setConnectionIdPrefix(this.netConnectionIdPrefix);
        }
        if (this.checksumClient != null) {
            connectDescription.setChecksumClient(this.checksumClient);
        }
        if (this.checksumClientTypes != null) {
            connectDescription.setChecksumClientTypes(this.checksumClientTypes);
        }
        if (this.encryptionClient != null) {
            connectDescription.setEncryptionClient(this.encryptionClient);
        }
        if (this.encryptionClientTypes != null) {
            connectDescription.setEncryptionClientTypes(this.encryptionClientTypes);
        }
        if (this.allowWeakCrypto != null) {
            connectDescription.setAllowWeakCrypto(this.allowWeakCrypto);
        }
        connStrategy.addSocketOptions(this.keepAlive);
        if (this.sourceRoute) {
            if (!this.backwardCompatibilityCase(this.children, connStrategy)) {
                this.activeChildren = this.children;
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(connStrategy, stringBuffer);
                for (int i2 = 1; i2 < this.activeChildren.size(); ++i2) {
                    ((NavSchemaObject)this.activeChildren.elementAt(i2)).addToString(connStrategy);
                }
            } else {
                this.setConnectionOption(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (int i3 = 0; i3 < this.activeChildren.size(); ++i3) {
                ((NavSchemaObject)this.activeChildren.elementAt(i3)).navigate(connStrategy, stringBuffer);
            }
            this.closeNVPair(connStrategy);
        }
        if (this.expireTime != null) {
            connectDescription.setExpireTime(this.getIntValue(this.expireTime, -1));
        }
        if (this.loadBalance) {
            connStrategy.addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF();
        }
        connectDescription.setTokenAuthentication(this.tokenAuthentication);
        connectDescription.setTokenLocation(this.tokenLocation);
        connectDescription.setPasswordAuthentication(this.passwordAuthentication);
        connectDescription.setOciIamUrl(this.ociIamUrl);
        connectDescription.setOciTenancy(this.ociTenancy);
        connectDescription.setOciCompartment(this.ociCompartment);
        connectDescription.setOciDatabase(this.ociDatabase);
        connStrategy.closeDescription();
    }

    public void closeNVPair(ConnStrategy connStrategy) {
        if (connStrategy.currentDescription() == null) {
            return;
        }
        ArrayList<ConnOption> arrayList = connStrategy.currentDescription().getConnectOptions();
        for (ConnOption connOption : arrayList) {
            if (this.sourceRoute) {
                connOption.conn_data.append("(SOURCE_ROUTE=yes)");
            }
            if (this.connectData == null) {
                this.connectData = "(SERVICE_NAME=)";
            }
            connOption.conn_data.append("(CONNECT_DATA=");
            connOption.conn_data.append("(CID=(PROGRAM=");
            connOption.conn_data.append(connStrategy.getProgramName());
            connOption.conn_data.append(")(HOST=__jdbc__)(USER=");
            connOption.conn_data.append(connStrategy.getOSUsername());
            connOption.conn_data.append("))");
            connOption.conn_data.append(this.connectData);
            connOption.conn_data.append(")");
            if (this.SID != null) {
                connOption.sid = this.SID;
            }
            if (this.serviceName != null) {
                connOption.service_name = this.serviceName;
            }
            if (this.instanceName != null) {
                connOption.instance_name = this.instanceName;
            }
            if (this.sslServerCertDN != null) {
                connOption.sslServerCertDN = this.sslServerCertDN;
            }
            if (this.myWalletDirectory != null) {
                connOption.walletDirectory = this.myWalletDirectory;
            }
            connOption.conn_data.append(")");
            connOption.done = true;
        }
    }

    @Override
    public void addToString(ConnStrategy connStrategy) {
    }

    private int getIntValue(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    private boolean backwardCompatibilityCase(Vector vector, ConnStrategy connStrategy) {
        if (vector.size() == 1 && ((NavSchemaObject)vector.elementAt(0)).isA() == 1 && !((NavAddressList)vector.elementAt((int)0)).sourceRoute) {
            NavAddressList navAddressList = (NavAddressList)vector.elementAt(0);
            int n2 = navAddressList.getChildrenSize();
            if (n2 == 0) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (navAddressList.getChildrenType(i2) == 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setConnectionOption(ConnStrategy connStrategy, StringBuffer stringBuffer) {
        stringBuffer.append("(ADDRESS_LIST=");
        NavAddressList navAddressList = (NavAddressList)this.children.elementAt(0);
        NavAddress navAddress = navAddressList.getChild(0);
        int n2 = navAddressList.getChildrenSize();
        navAddress.navigate(connStrategy, stringBuffer);
        for (int i2 = 1; i2 < n2; ++i2) {
            navAddressList.getChild(i2).addToString(connStrategy);
        }
        connStrategy.currentDescription().getConnectOptions().get((int)0).conn_data.append(")");
    }

    static {
        try {
            $$$methodRef$$$6 = NavDescription.class.getDeclaredConstructor(SchemaObjectFactoryInterface.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NavDescription.class.getDeclaredMethod("setConnectionOption", ConnStrategy.class, StringBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NavDescription.class.getDeclaredMethod("backwardCompatibilityCase", Vector.class, ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NavDescription.class.getDeclaredMethod("getIntValue", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NavDescription.class.getDeclaredMethod("addToString", ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NavDescription.class.getDeclaredMethod("closeNVPair", ConnStrategy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NavDescription.class.getDeclaredMethod("navigate", ConnStrategy.class, StringBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

