/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.util.RepConversion;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class ResultSetCache
implements oracle.jdbc.internal.ResultSetCache,
Monitor.WaitableMonitor {
    static final int COMPILE_KEY_SIZE = 16;
    static final int RUNTIME_KEY_SIZE = 16;
    private static final int CACHE_ID_SIZE = 16;
    private static final long STAT_SEND_INTERVAL = 30000L;
    private final byte[] cacheId = new byte[16];
    private final byte[] cacheIdAsNibbles = new byte[32];
    private boolean isCacheIdAsNibblesReady = false;
    private final long cacheLagInMillis;
    private long nextPingTime = 0L;
    private AtomicLong invalidationCount = new AtomicLong(0L);
    private AtomicLong invalidatedQueryCount = new AtomicLong(0L);
    private AtomicLong validQueriesPurged = new AtomicLong(0L);
    private AtomicLong invalidatedBeforeCompletion = new AtomicLong(0L);
    private AtomicInteger cacheHits = new AtomicInteger(0);
    private long lastStatSentAt;
    private T4CTTIOqcsta oqcsta;
    private AtomicBoolean needToSendStats = new AtomicBoolean(false);
    private long registrationId = -1L;
    private ResultSetCacheState state = ResultSetCacheState.INIT;
    private long visibleSCN;
    private final CacheStorage cacheStorage;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private final Condition monitorCondition = this.newMonitorCondition();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    ResultSetCache(long l2, int n2) {
        assert (l2 > 0L);
        assert (n2 >= 0);
        new Random().nextBytes(this.cacheId);
        this.cacheStorage = new CacheStorage(l2);
        this.cacheLagInMillis = n2;
    }

    void setState(ResultSetCacheState resultSetCacheState) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (resultSetCacheState == this.state) {
                return;
            }
            this.state = resultSetCacheState;
            if (resultSetCacheState == ResultSetCacheState.STARTED) {
                this.monitorNotifyAll();
            }
        }
    }

    ResultSetCacheState getState() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            ResultSetCacheState resultSetCacheState = this.state;
            return resultSetCacheState;
        }
    }

    byte[] getCacheId() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            byte[] byArray = this.cacheId;
            return byArray;
        }
    }

    byte[] getCacheIdAsNibbles() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (!this.isCacheIdAsNibblesReady) {
                RepConversion.bArray2Nibbles(this.cacheId, this.cacheIdAsNibbles);
                this.isCacheIdAsNibblesReady = true;
            }
            byte[] byArray = this.cacheIdAsNibbles;
            return byArray;
        }
    }

    long getRegistrationId() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            long l2 = this.registrationId;
            return l2;
        }
    }

    void setRegistrationId(long l2) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.registrationId = l2;
        }
    }

    void setOQCSTA(T4CTTIOqcsta t4CTTIOqcsta) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.oqcsta = t4CTTIOqcsta;
        }
    }

    T4CTTIOqcsta getOQCSTA() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            T4CTTIOqcsta t4CTTIOqcsta = this.oqcsta;
            return t4CTTIOqcsta;
        }
    }

    void setVisibleSCN(long l2) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.visibleSCN = l2;
            this.nextPingTime = System.currentTimeMillis() + this.cacheLagInMillis;
        }
    }

    long getVisibleSCN() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            long l2 = this.visibleSCN;
            return l2;
        }
    }

    void processCommittedInvalidation(T4CTTIqcinv t4CTTIqcinv) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            long l2 = t4CTTIqcinv.kpdqcqid;
            if (l2 == 0L) {
                return;
            }
            this.invalidationCount.incrementAndGet();
            long l3 = t4CTTIqcinv.kpdqcscn.getSCN();
            if (!T4CTTIkscn.isLessThanUnsigned(l3, this.visibleSCN)) {
                int n2 = this.cacheStorage.removeResultsetCacheEntries(l2);
                this.invalidatedQueryCount.addAndGet(n2);
            }
            this.needToSendStats.set(true);
        }
    }

    ResultSetCacheEntry getResultSetCacheEntry(OracleStatement oracleStatement) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            ResultSetCacheEntry resultSetCacheEntry;
            byte[] byArray = oracleStatement.getCompileKey();
            if (byArray == null || byArray.length == 0) {
                ResultSetCacheEntry resultSetCacheEntry2 = null;
                return resultSetCacheEntry2;
            }
            byte[] byArray2 = oracleStatement.getRuntimeKey();
            if (byArray2 == null) {
                ResultSetCacheEntry resultSetCacheEntry3 = null;
                return resultSetCacheEntry3;
            }
            ResultSetCacheEntryKey resultSetCacheEntryKey = new ResultSetCacheEntryKey(byArray, byArray2);
            long l2 = oracleStatement.getQueryId();
            ArrayList<Long> arrayList = oracleStatement.connection.getResultSetCacheLocalInvalidations();
            if (l2 == 0L || arrayList.contains(l2)) {
                ResultSetCacheEntry resultSetCacheEntry4 = null;
                return resultSetCacheEntry4;
            }
            if (System.currentTimeMillis() > this.nextPingTime) {
                oracleStatement.connection.pingDatabase();
            }
            if ((resultSetCacheEntry = this.cacheStorage.getResultsetCacheEntry(resultSetCacheEntryKey, l2, oracleStatement.connection.userName)) != null && resultSetCacheEntry.userName.equals(oracleStatement.connection.userName)) {
                if (resultSetCacheEntry.isValid()) {
                    this.cacheHits.incrementAndGet();
                    this.needToSendStats.set(true);
                    if (this.lastStatSentAt == 0L) {
                        this.lastStatSentAt = System.currentTimeMillis();
                    }
                }
                ResultSetCacheEntry resultSetCacheEntry5 = resultSetCacheEntry;
                return resultSetCacheEntry5;
            }
            ResultSetCacheEntry resultSetCacheEntry6 = null;
            return resultSetCacheEntry6;
        }
    }

    void registerConnection(OracleConnection oracleConnection) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (this.state == ResultSetCacheState.INIT) {
                this.setState(ResultSetCacheState.STARTING);
            } else if (this.state == ResultSetCacheState.STARTING) {
                try {
                    this.monitorWait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    boolean needToSendStatsResetIfTrue() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (System.currentTimeMillis() - this.lastStatSentAt > 30000L && this.needToSendStats.weakCompareAndSet(true, false)) {
                this.lastStatSentAt = System.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int getCacheLag() {
        return (int)this.cacheLagInMillis;
    }

    @Override
    public long getInvalidationCount() {
        return this.invalidationCount.get();
    }

    @Override
    public long getInvalidatedQueryCount() {
        return this.invalidatedQueryCount.get();
    }

    @Override
    public long getInvalidatedBeforeCompletion() {
        return this.invalidatedBeforeCompletion.get();
    }

    @Override
    public long getValidQueriesPurged() {
        return this.validQueriesPurged.get();
    }

    @Override
    public int getCacheHits() {
        return this.cacheHits.get();
    }

    void updateCurrentCacheSize(long l2) {
        this.cacheStorage.incrementCacheSize(l2);
    }

    @Override
    public long getCurrentCacheSize() {
        return this.cacheStorage.getCacheSize();
    }

    @Override
    public long getMaxCacheSize() {
        return this.cacheStorage.maxSize();
    }

    @Override
    public long getNumberOfCacheEntries() {
        return this.cacheStorage.size();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public final Condition getMonitorCondition() {
        return this.monitorCondition;
    }

    static {
        try {
            $$$methodRef$$$26 = ResultSetCache.class.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ResultSetCache.class.getDeclaredMethod("getMonitorCondition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ResultSetCache.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ResultSetCache.class.getDeclaredMethod("getNumberOfCacheEntries", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ResultSetCache.class.getDeclaredMethod("getMaxCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ResultSetCache.class.getDeclaredMethod("getCurrentCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ResultSetCache.class.getDeclaredMethod("updateCurrentCacheSize", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ResultSetCache.class.getDeclaredMethod("getCacheHits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ResultSetCache.class.getDeclaredMethod("getValidQueriesPurged", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ResultSetCache.class.getDeclaredMethod("getInvalidatedBeforeCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ResultSetCache.class.getDeclaredMethod("getInvalidatedQueryCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ResultSetCache.class.getDeclaredMethod("getInvalidationCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ResultSetCache.class.getDeclaredMethod("getCacheLag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ResultSetCache.class.getDeclaredMethod("needToSendStatsResetIfTrue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ResultSetCache.class.getDeclaredMethod("registerConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ResultSetCache.class.getDeclaredMethod("getResultSetCacheEntry", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ResultSetCache.class.getDeclaredMethod("processCommittedInvalidation", T4CTTIqcinv.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ResultSetCache.class.getDeclaredMethod("getVisibleSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ResultSetCache.class.getDeclaredMethod("setVisibleSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ResultSetCache.class.getDeclaredMethod("getOQCSTA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ResultSetCache.class.getDeclaredMethod("setOQCSTA", T4CTTIOqcsta.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ResultSetCache.class.getDeclaredMethod("setRegistrationId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ResultSetCache.class.getDeclaredMethod("getRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ResultSetCache.class.getDeclaredMethod("getCacheIdAsNibbles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetCache.class.getDeclaredMethod("getCacheId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetCache.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetCache.class.getDeclaredMethod("setState", ResultSetCacheState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static class CacheStorage
    extends LinkedHashMap<ResultSetCacheEntryKey, ResultSetCacheEntry>
    implements Monitor {
        private static final int INITIAL_SIZE = 10;
        private static final long serialVersionUID = 1L;
        private long currentCacheSize;
        private final long maxCacheSize;
        private final Map<Long, LinkedList<ResultSetCacheEntry>> queryIdIndex;
        private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        CacheStorage(long l2) {
            super(10);
            this.queryIdIndex = new HashMap<Long, LinkedList<ResultSetCacheEntry>>(10);
            this.maxCacheSize = l2;
        }

        ResultSetCacheEntry getResultsetCacheEntry(ResultSetCacheEntryKey resultSetCacheEntryKey, long l3, String string) {
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                ResultSetCacheEntry resultSetCacheEntry = (ResultSetCacheEntry)super.get(resultSetCacheEntryKey);
                if (resultSetCacheEntry == null) {
                    resultSetCacheEntry = new ResultSetCacheEntry(resultSetCacheEntryKey, l3);
                    resultSetCacheEntry.userName = string;
                    super.put(resultSetCacheEntryKey, resultSetCacheEntry);
                    this.currentCacheSize += resultSetCacheEntry.getSizeInMemory();
                    this.queryIdIndex.computeIfAbsent(l3, l2 -> new LinkedList()).add(resultSetCacheEntry);
                }
                ResultSetCacheEntry resultSetCacheEntry2 = resultSetCacheEntry;
                return resultSetCacheEntry2;
            }
        }

        int removeResultsetCacheEntries(Long l2) {
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                int n2 = 0;
                LinkedList<ResultSetCacheEntry> linkedList = this.queryIdIndex.remove(l2);
                if (linkedList != null) {
                    for (ResultSetCacheEntry resultSetCacheEntry : linkedList) {
                        if (this.remove(resultSetCacheEntry.getResultSetCacheEntryKey()) != null) {
                            this.currentCacheSize -= resultSetCacheEntry.getSizeInMemory();
                        }
                        resultSetCacheEntry.invalidate();
                        ++n2;
                    }
                }
                int n3 = n2;
                return n3;
            }
        }

        void incrementCacheSize(long l2) {
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                this.currentCacheSize += l2;
            }
        }

        long getCacheSize() {
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                long l2 = this.currentCacheSize;
                return l2;
            }
        }

        long maxSize() {
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                long l2 = this.maxCacheSize;
                return l2;
            }
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ResultSetCacheEntryKey, ResultSetCacheEntry> entry) {
            try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
                boolean bl;
                boolean bl2 = bl = this.currentCacheSize >= this.maxCacheSize;
                if (bl) {
                    ResultSetCacheEntry resultSetCacheEntry = entry.getValue();
                    this.currentCacheSize = -1L * resultSetCacheEntry.getSizeInMemory();
                    LinkedList<ResultSetCacheEntry> linkedList = this.queryIdIndex.get(resultSetCacheEntry.getQueryId());
                    linkedList.remove(resultSetCacheEntry);
                }
                boolean bl3 = bl;
                return bl3;
            }
        }

        @Override
        public final Monitor.CloseableLock getMonitorLock() {
            return this.monitorLock;
        }

        static {
            try {
                $$$methodRef$$$8 = CacheStorage.class.getDeclaredConstructor(Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = CacheStorage.class.getDeclaredMethod("lambda$getResultsetCacheEntry$0", Long.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = CacheStorage.class.getDeclaredMethod("getMonitorLock", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = CacheStorage.class.getDeclaredMethod("removeEldestEntry", Map.Entry.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = CacheStorage.class.getDeclaredMethod("maxSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = CacheStorage.class.getDeclaredMethod("getCacheSize", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = CacheStorage.class.getDeclaredMethod("incrementCacheSize", Long.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = CacheStorage.class.getDeclaredMethod("removeResultsetCacheEntries", Long.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = CacheStorage.class.getDeclaredMethod("getResultsetCacheEntry", ResultSetCacheEntryKey.class, Long.TYPE, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    static final class ResultSetCacheState
    extends Enum<ResultSetCacheState> {
        public static final /* enum */ ResultSetCacheState INIT;
        public static final /* enum */ ResultSetCacheState STARTING;
        public static final /* enum */ ResultSetCacheState STARTED;
        public static final /* enum */ ResultSetCacheState STARTUP_FAILED;
        private static final /* synthetic */ ResultSetCacheState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ResultSetCacheState[] values() {
            return (ResultSetCacheState[])$VALUES.clone();
        }

        public static ResultSetCacheState valueOf(String string) {
            return Enum.valueOf(ResultSetCacheState.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = ResultSetCacheState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ResultSetCacheState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ResultSetCacheState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            INIT = new ResultSetCacheState();
            STARTING = new ResultSetCacheState();
            STARTED = new ResultSetCacheState();
            STARTUP_FAILED = new ResultSetCacheState();
            $VALUES = new ResultSetCacheState[]{INIT, STARTING, STARTED, STARTUP_FAILED};
        }
    }
}

