/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.Log;

public final class TcpMultiplexer {
    private static final Consumer<Throwable> NO_OP_CALLBACK;
    private static volatile boolean isStarted;
    private final Selector selector;
    private final ConcurrentLinkedQueue<Runnable> registrationQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger pendingRegistrationCount = new AtomicInteger(0);
    private final Thread pollingThread;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    private static TcpMultiplexer soleInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void registerForReadEvent(SocketChannel socketChannel, Consumer<Throwable> consumer) throws IOException {
        TcpMultiplexer.soleInstance().register(socketChannel, 1, consumer);
    }

    public static void registerForWriteEvent(SocketChannel socketChannel, Consumer<Throwable> consumer) throws IOException {
        TcpMultiplexer.soleInstance().register(socketChannel, 4, consumer);
    }

    public static void registerForConnectEvent(SocketChannel socketChannel, Consumer<Throwable> consumer) throws IOException {
        TcpMultiplexer.soleInstance().register(socketChannel, 8, consumer);
    }

    public static void cancelRegistration(SocketChannel socketChannel, Throwable throwable) {
        if (!isStarted) {
            return;
        }
        SelectionKey selectionKey = TcpMultiplexer.soleInstance().getKeyForChannel(socketChannel);
        if (selectionKey == null) {
            return;
        }
        TcpMultiplexer.onReadReady(selectionKey, throwable);
    }

    public static void stop() {
        if (!isStarted) {
            return;
        }
        isStarted = false;
        TcpMultiplexer.soleInstance().pollingThread.interrupt();
    }

    private TcpMultiplexer(Selector selector) {
        this.selector = selector;
        this.pollingThread = new Thread(this::poll, this.getClass().getName());
        this.pollingThread.setDaemon(true);
        this.pollingThread.start();
        isStarted = true;
    }

    private void register(SocketChannel socketChannel, int n2, Consumer<Throwable> consumer) throws IOException {
        this.registrationQueue.add(() -> {
            try {
                socketChannel.configureBlocking(false);
                socketChannel.register(this.selector, n2, consumer);
            }
            catch (IOException iOException) {
                try {
                    socketChannel.configureBlocking(true);
                }
                catch (IOException iOException2) {
                    iOException.addSuppressed(iOException2);
                }
                consumer.accept(iOException);
            }
        });
        if (this.pendingRegistrationCount.getAndIncrement() == 0) {
            this.selector.wakeup();
        }
    }

    private SelectionKey getKeyForChannel(SocketChannel socketChannel) {
        return socketChannel.keyFor(this.selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void poll() {
        try {
            try {
                while (true) {
                    int n2;
                    int n3 = this.selector.select();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedIOException(Thread.currentThread().getName() + " received a thread interrupt");
                    }
                    while (n3 != 0) {
                        for (SelectionKey selectionKey2 : this.selector.selectedKeys()) {
                            TcpMultiplexer.onReadReady(selectionKey2);
                        }
                        this.selector.selectedKeys().clear();
                        n3 = this.selector.selectNow();
                    }
                    do {
                        void object;
                        n2 = 0;
                        Runnable runnable = this.registrationQueue.poll();
                        while (object != null) {
                            ++n2;
                            object.run();
                            Runnable runnable2 = this.registrationQueue.poll();
                        }
                    } while (this.pendingRegistrationCount.addAndGet(-n2) > 0);
                }
            }
            catch (IOException iOException) {
                this.invokeAllReadinessCallbacks(iOException);
                Consumer[] consumerArray = (Consumer[])this.selector.keys().stream().map(selectionKey -> (Consumer)selectionKey.attach(NO_OP_CALLBACK)).toArray(Consumer[]::new);
                IOException iOException2 = new IOException("Selector has stopped polling");
                try {
                    this.selector.close();
                }
                catch (IOException iOException3) {
                    iOException2.addSuppressed(iOException3);
                }
                for (Consumer consumer : consumerArray) {
                    consumer.accept(iOException2);
                }
            }
        }
        catch (Throwable throwable) {
            Consumer[] consumerArray = (Consumer[])this.selector.keys().stream().map(selectionKey -> (Consumer)selectionKey.attach(NO_OP_CALLBACK)).toArray(Consumer[]::new);
            IOException iOException = new IOException("Selector has stopped polling");
            try {
                this.selector.close();
            }
            catch (IOException iOException4) {
                iOException.addSuppressed(iOException4);
            }
            for (Consumer consumer : consumerArray) {
                consumer.accept(iOException);
            }
            throw throwable;
        }
    }

    private static final void onReadReady(SelectionKey selectionKey) {
        TcpMultiplexer.onReadReady(selectionKey, null);
    }

    private static final void onReadReady(SelectionKey selectionKey, Throwable throwable) {
        try {
            selectionKey.cancel();
            selectionKey.channel().configureBlocking(true);
        }
        catch (IOException iOException) {
            if (throwable == null) {
                throwable = iOException;
            }
            throwable.addSuppressed(iOException);
        }
        TcpMultiplexer.invokeReadinessCallback(selectionKey, throwable);
    }

    private static final void invokeReadinessCallback(SelectionKey selectionKey, Throwable throwable) {
        Consumer consumer = (Consumer)selectionKey.attach(NO_OP_CALLBACK);
        try {
            consumer.accept(throwable);
        }
        catch (Throwable throwable2) {
        }
    }

    private void invokeAllReadinessCallbacks(Throwable throwable) {
        for (SelectionKey selectionKey : this.selector.keys()) {
            TcpMultiplexer.invokeReadinessCallback(selectionKey, throwable);
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$18 = TcpMultiplexer.class.getDeclaredConstructor(Selector.class, 1.class);
        }
        catch (Throwable throwable2) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TcpMultiplexer.class.getDeclaredConstructor(Selector.class);
        }
        catch (Throwable throwable3) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpMultiplexer.class.getDeclaredMethod("lambda$static$0", Throwable.class);
        }
        catch (Throwable throwable4) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpMultiplexer.class.getDeclaredMethod("lambda$register$1", SocketChannel.class, Integer.TYPE, Consumer.class);
        }
        catch (Throwable throwable5) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpMultiplexer.class.getDeclaredMethod("lambda$poll$2", SelectionKey.class);
        }
        catch (Throwable throwable6) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpMultiplexer.class.getDeclaredMethod("lambda$poll$3", Integer.TYPE);
        }
        catch (Throwable throwable7) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpMultiplexer.class.getDeclaredMethod("invokeAllReadinessCallbacks", Throwable.class);
        }
        catch (Throwable throwable8) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpMultiplexer.class.getDeclaredMethod("invokeReadinessCallback", SelectionKey.class, Throwable.class);
        }
        catch (Throwable throwable9) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpMultiplexer.class.getDeclaredMethod("onReadReady", SelectionKey.class, Throwable.class);
        }
        catch (Throwable throwable10) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpMultiplexer.class.getDeclaredMethod("onReadReady", SelectionKey.class);
        }
        catch (Throwable throwable11) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpMultiplexer.class.getDeclaredMethod("poll", new Class[0]);
        }
        catch (Throwable throwable12) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpMultiplexer.class.getDeclaredMethod("getKeyForChannel", SocketChannel.class);
        }
        catch (Throwable throwable13) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpMultiplexer.class.getDeclaredMethod("register", SocketChannel.class, Integer.TYPE, Consumer.class);
        }
        catch (Throwable throwable14) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpMultiplexer.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable15) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpMultiplexer.class.getDeclaredMethod("cancelRegistration", SocketChannel.class, Throwable.class);
        }
        catch (Throwable throwable16) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpMultiplexer.class.getDeclaredMethod("registerForConnectEvent", SocketChannel.class, Consumer.class);
        }
        catch (Throwable throwable17) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpMultiplexer.class.getDeclaredMethod("registerForWriteEvent", SocketChannel.class, Consumer.class);
        }
        catch (Throwable throwable18) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpMultiplexer.class.getDeclaredMethod("registerForReadEvent", SocketChannel.class, Consumer.class);
        }
        catch (Throwable throwable19) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpMultiplexer.class.getDeclaredMethod("soleInstance", new Class[0]);
        }
        catch (Throwable throwable20) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NO_OP_CALLBACK = throwable -> {};
        isStarted = false;
    }

    private static final class LazyHolder {
        private static final TcpMultiplexer INSTANCE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        private LazyHolder() {
        }

        static {
            Selector selector;
            try {
                $$$methodRef$$$1 = LazyHolder.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = LazyHolder.class.getDeclaredMethod("access$100", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                selector = Selector.open();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            INSTANCE = new TcpMultiplexer(selector);
        }
    }
}

