/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version = 0;
    private boolean needStackingForCommitRollbackPrepare = false;
    private static String xa_start_816;
    private static String xa_start_post_816;
    private static String xa_end_816;
    private static String xa_end_post_816;
    private static String xa_commit_816;
    private static String xa_commit_post_816;
    private static String xa_prepare_816;
    private static String xa_prepare_post_816;
    private static String xa_rollback_816;
    private static String xa_rollback_post_816;
    private static String xa_forget_816;
    private static String xa_forget_post_816;
    boolean isTransLoose = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        super(connection, oracleXAConnection);
        SQLException sQLException = null;
        try {
            this.m_version = ((OracleConnection)connection).getVersionNumber();
            this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
            this.m_version = (short)-1;
        }
        if (this.m_version < 8170) {
            throw (XAException)DatabaseError.createXAException(String.format("Unsupported database version %d", this.m_version), -6).initCause(sQLException);
        }
    }

    @Override
    public void start(Xid xid, int n2) throws XAException {
        OracleConnection oracleConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
            int n3 = -1;
            try {
                int n4;
                int n5;
                block27: {
                    block28: {
                        block26: {
                            block25: {
                                if (xid == null) {
                                    throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                                }
                                n5 = n2 & 0xFF00;
                                n4 = (n2 &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
                                if (((n2 &= 0xFFFEFFFF) & 0x820000A) != n2) break block25;
                                if (n4 == 0 || (n4 & 0x10000) == 65536) break block26;
                            }
                            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                        }
                        if ((n5 & 0xFF00) != 0 && n5 != 256 && n5 != 512 && n5 != 1024) {
                            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                        }
                        if ((n2 & 0x8200000) == 0) break block27;
                        if ((n5 & 0xFF00) != 0) break block28;
                        if ((n4 & 0x10000) == 0) break block27;
                    }
                    throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                }
                n2 |= n5 | n4;
                this.saveAndAlterAutoCommitModeForGlobalTransaction();
                try {
                    n3 = this.doStart(xid, n2);
                }
                catch (SQLException sQLException) {
                    throw this.convertError(sQLException, -3);
                }
                this.checkError(n3);
                boolean[] blArray = new boolean[]{false};
                super.createOrUpdateXid(xid, false, blArray);
            }
            catch (XAException xAException) {
                this.restoreAutoCommitModeForGlobalTransaction();
                throw xAException;
            }
        }
    }

    protected int doStart(Xid xid, int n2) throws XAException, SQLException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_start_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, this.timeout);
            callableStatement.setInt(6, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        block29: {
            OracleConnection oracleConnection = this.getPhysicalConnection();
            try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
                int n3 = -1;
                boolean bl = false;
                boolean bl2 = false;
                try {
                    if (xid == null) {
                        throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                    }
                    int n4 = 638582786;
                    if ((n2 & n4) != n2) {
                        throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                    }
                    Xid xid2 = null;
                    bl = (n2 & 0x4000000) != 0;
                    boolean bl3 = bl2 = (n2 & 0x20000000) != 0;
                    if (bl || bl2) {
                        xid2 = super.suspendStacked(xid);
                    }
                    try {
                        boolean bl4 = false;
                        if (bl || bl2) {
                            bl4 = this.isXidSuspended(xid);
                            if (bl4) {
                                super.resumeStacked(xid);
                            }
                            this.removeXidFromList(xid);
                        } else if (n2 == 0x2000000) {
                            boolean[] blArray = new boolean[]{false};
                            super.createOrUpdateXid(xid, true, blArray);
                            bl4 = blArray[0];
                        }
                        n3 = this.doEnd(xid, n2, bl4);
                    }
                    catch (SQLException sQLException) {
                        throw this.convertError(sQLException, -3);
                    }
                    if (xid2 != null) {
                        super.resumeStacked(xid2);
                    } else if (this.isXidListEmpty()) {
                        this.exitGlobalTxnMode();
                        this.activeXid = null;
                    }
                    this.checkError(n3);
                    if (!bl || n2 == 0x4000000) {
                        if (!bl2 || n2 == 0x20000000) break block29;
                    }
                    throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                }
                finally {
                    this.restoreAutoCommitModeForGlobalTransaction();
                }
            }
        }
    }

    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        int n3 = -1;
        try {
            callableStatement = this.connection.prepareCall(xa_end_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        OracleConnection oracleConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
            if (xid == null) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            Xid xid2 = null;
            if (this.needStackingForCommitRollbackPrepare) {
                xid2 = super.suspendStacked(xid);
            } else {
                this.removeXidFromList(xid);
                if (this.activeXid == null) {
                    this.exitGlobalTxnMode();
                }
            }
            try {
                try {
                    this.doCommit(xid, bl);
                }
                catch (SQLException sQLException) {
                    throw this.convertError(sQLException, -3);
                }
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -7) {
                    try {
                        oracleConnection.close();
                    }
                    catch (SQLException sQLException) {
                    }
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
                throw xAException;
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(xid2);
            }
        }
    }

    protected void doCommit(Xid xid, boolean bl) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_commit_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, bl ? 1 : 0);
            callableStatement.execute();
            int n2 = callableStatement.getInt(1);
            this.checkError(n2, -7);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        OracleConnection oracleConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
            int n2;
            int n3 = 0;
            if (xid == null) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            Xid xid2 = null;
            if (this.needStackingForCommitRollbackPrepare) {
                xid2 = super.suspendStacked(xid);
            }
            try {
                try {
                    n3 = this.doPrepare(xid);
                    if (n3 != 0 && n3 != 3) {
                        n2 = OracleXAException.errorConvert(n3);
                        if (n2 != 0 && n2 != 3) {
                            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n3).fillInStackTrace();
                        }
                        n3 = n2;
                    }
                }
                catch (SQLException sQLException) {
                    throw this.convertError(sQLException, -3);
                }
            }
            catch (XAException xAException) {
                if (xAException.errorCode == -7) {
                    try {
                        oracleConnection.close();
                    }
                    catch (SQLException sQLException) {
                    }
                } else if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
                throw xAException;
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(xid2);
            }
            n2 = n3;
            return n2;
        }
    }

    protected int doPrepare(Xid xid) throws XAException, SQLException {
        int n2 = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_prepare_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        OracleConnection oracleConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
            int n2 = 0;
            if (xid == null) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            this.removeXidFromList(xid);
            try {
                n2 = this.doForget(xid);
            }
            catch (SQLException sQLException) {
                throw this.convertError(sQLException, -3);
            }
            this.checkError(n2);
        }
    }

    protected int doForget(Xid xid) throws XAException, SQLException {
        int n2 = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_forget_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            if (n2 == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        OracleConnection oracleConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
            int n2 = 0;
            if (xid == null) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            Xid xid2 = null;
            if (this.needStackingForCommitRollbackPrepare) {
                xid2 = super.suspendStacked(xid);
            } else {
                this.removeXidFromList(xid);
                if (this.activeXid == null) {
                    this.exitGlobalTxnMode();
                }
            }
            try {
                this.doRollback(xid);
            }
            catch (SQLException sQLException) {
                throw this.convertError(sQLException, -3);
            }
            if (this.needStackingForCommitRollbackPrepare) {
                super.resumeStacked(xid2);
            }
            this.checkError(n2);
        }
    }

    protected void doRollback(Xid xid) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_rollback_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            int n2 = callableStatement.getInt(1);
            this.checkError(n2, -7);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
    }

    public void doTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        OracleConnection oracleConnection = this.getPhysicalConnection();
        try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
            this.doDoTwoPhaseAction(n2, n3, stringArray, xidArray);
        }
    }

    protected int doDoTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        throw (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static {
        try {
            $$$methodRef$$$16 = OracleXAResource.class.getDeclaredConstructor(Connection.class, OracleXAConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleXAResource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleXAResource.class.getDeclaredMethod("getSerializedBytes", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXAResource.class.getDeclaredMethod("doDoTwoPhaseAction", Integer.TYPE, Integer.TYPE, String[].class, Xid[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXAResource.class.getDeclaredMethod("doTwoPhaseAction", Integer.TYPE, Integer.TYPE, String[].class, Xid[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXAResource.class.getDeclaredMethod("doRollback", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXAResource.class.getDeclaredMethod("rollback", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXAResource.class.getDeclaredMethod("doForget", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXAResource.class.getDeclaredMethod("forget", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXAResource.class.getDeclaredMethod("doPrepare", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXAResource.class.getDeclaredMethod("prepare", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXAResource.class.getDeclaredMethod("doCommit", Xid.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXAResource.class.getDeclaredMethod("commit", Xid.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAResource.class.getDeclaredMethod("doEnd", Xid.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAResource.class.getDeclaredMethod("end", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAResource.class.getDeclaredMethod("doStart", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAResource.class.getDeclaredMethod("start", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
        xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
        xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
        xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
        xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
        xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
        xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
        xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
        xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
        xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
        xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
        xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    }
}

