/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T4CXAConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAConnectionBuilderImpl;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.XA, Feature.HIGH_AVAILABILITY, Feature.CONN_POOL, Feature.APPLICATION_CONTINUITY})
public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private int rmid = -1;
    private String xaOpenString = null;
    private static boolean libraryLoaded;
    private static Monitor LOAD_LIBRARY_MONITOR;
    private static final String dbSuffix = "HeteroXA";
    private static final String dllName = "heteroxa21";
    private static final char atSignChar = '@';
    private static int rmidSeed;
    private static Monitor RMID_SEED_MONITOR;
    private static final int MAX_RMID_SEED = 65536;
    private String driverCharSetIdString = null;
    private String oldTnsEntry = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public OracleXADataSource() throws SQLException {
        this.isOracleDataSource = true;
        this.setConnectionProperty("oracle.jdbc.enableACSupport", "false");
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        Properties properties = new Properties(this.connectionProperties);
        if (this.user != null && this.password != null && this.password != OpaqueString.NULL) {
            properties.setProperty("user", this.user);
            properties.setProperty("password", this.password.get());
        }
        return this.getXAConnection(properties.getProperty("user"), properties.getProperty("password"));
    }

    @Override
    public XAConnection getXAConnection(String string, @Blind String string2) throws SQLException {
        String string3 = OracleXADataSource.getSystemProperty("oracle.jdbc.enableACSupport", null);
        if (string3 == null) {
            string3 = this.getConnectionProperty("oracle.jdbc.enableACSupport");
        }
        if (string3 == null) {
            string3 = "true";
        }
        boolean bl = string3 != null && string3.equalsIgnoreCase("true");
        return this.getXAConnectionInternal((OracleXAConnectionBuilderImpl)((OracleXAConnectionBuilderImpl)this.createXAConnectionBuilder().user(string)).password(OpaqueString.newOpaqueString(string2)), bl);
    }

    @Override
    public XAConnection getXAConnection(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return (XAConnection)this.getPooledConnection(properties);
    }

    public XAConnection getXAConnection(OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl) throws SQLException {
        String string;
        Properties properties = new Properties(this.connectionProperties);
        OpaqueString opaqueString = oracleXAConnectionBuilderImpl.getPassword();
        if (oracleXAConnectionBuilderImpl.getUser() != null && opaqueString != null && opaqueString != OpaqueString.NULL) {
            properties.setProperty("user", oracleXAConnectionBuilderImpl.getUser());
            properties.setProperty("password", opaqueString.get());
        }
        if (oracleXAConnectionBuilderImpl.getServiceName() != null) {
            properties.setProperty("oracle.jdbc.targetServiceName", oracleXAConnectionBuilderImpl.getServiceName());
        }
        if (oracleXAConnectionBuilderImpl.getShardingKey() != null) {
            string = oracleXAConnectionBuilderImpl.getShardingKey().encodeKeyinB64Format();
            properties.setProperty("oracle.jdbc.targetShardingKey", string);
        }
        if (oracleXAConnectionBuilderImpl.getSuperShardingKey() != null) {
            string = oracleXAConnectionBuilderImpl.getSuperShardingKey().encodeKeyinB64Format();
            properties.setProperty("oracle.jdbc.targetSuperShardingKey", string);
        }
        if (oracleXAConnectionBuilderImpl.getReadOnlyInstanceAllowed()) {
            properties.setProperty("oracle.jdbc.readOnlyInstanceAllowed", "true");
        }
        return (XAConnection)this.getPooledConnection(properties, oracleXAConnectionBuilderImpl);
    }

    @Override
    public OracleXAConnectionBuilderImpl createXAConnectionBuilder() {
        return new OracleXAConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public oracle.jdbc.datasource.OracleXAConnection build() throws SQLException {
                if (this.getGSSCredential() != null && (this.getUser() != null || this.getPassword() != null && this.getPassword() != OpaqueString.NULL)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                String string = OracleXADataSource.getSystemProperty("oracle.jdbc.enableACSupport", null);
                if (string == null) {
                    string = OracleXADataSource.this.getConnectionProperty("oracle.jdbc.enableACSupport");
                }
                if (string == null) {
                    string = "true";
                }
                boolean bl = string != null && string.equalsIgnoreCase("true");
                return (OracleXAConnection)OracleXADataSource.this.getXAConnectionInternal(this, bl);
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OracleXADataSource.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    private XAConnection getXAConnectionInternal(OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl, boolean bl) throws SQLException {
        if (!bl) {
            return this.getXAConnection(oracleXAConnectionBuilderImpl);
        }
        this.setupACSpecificProperties(bl);
        OraclePooledConnection oraclePooledConnection = (OraclePooledConnection)((Object)this.getXAConnection(oracleXAConnectionBuilderImpl));
        Connection connection = oraclePooledConnection.getPhysicalHandle();
        OracleConnectionBuilderImpl oracleConnectionBuilderImpl = oracleXAConnectionBuilderImpl == null ? null : (OracleConnectionBuilderImpl)this.createConnectionBuilder().copy(oracleXAConnectionBuilderImpl);
        Connection connection2 = this.enableACAndProxifyIfNecessary(connection, oracleConnectionBuilderImpl);
        if (connection != connection2) {
            oraclePooledConnection.setConnection((OracleConnection)connection2);
        }
        return (XAConnection)((Object)oraclePooledConnection);
    }

    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", string);
        properties.setProperty("password", string2);
        return this.getPooledConnection(properties);
    }

    public PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        return this.getPooledConnection(properties, null);
    }

    private final PooledConnection getPooledConnection(@Blind(value=PropertiesBlinder.class) Properties properties, OracleXAConnectionBuilderImpl oracleXAConnectionBuilderImpl) throws SQLException {
        try {
            String string = this.getURL();
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            String string4 = properties.getProperty("oracle.jdbc.targetInstanceName");
            String string5 = properties.getProperty("oracle.jdbc.targetServiceName");
            String string6 = properties.getProperty("oracle.jdbc.targetShardingKey");
            String string7 = properties.getProperty("oracle.jdbc.targetSuperShardingKey");
            String string8 = properties.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
            String string9 = null;
            String string10 = null;
            String string11 = null;
            int n2 = 0;
            if (this.useNativeXA && (string.startsWith("jdbc:oracle:oci8") || string.startsWith("jdbc:oracle:oci"))) {
                Throwable throwable;
                Monitor.CloseableLock closeableLock;
                long[] lArray = new long[]{0L, 0L};
                String string12 = null;
                String string13 = null;
                Monitor.CloseableLock closeableLock2 = this.acquireCloseableLock();
                Object object = null;
                try {
                    block126: {
                        string12 = this.tnsEntry != null ? this.tnsEntry : this.getTNSEntryFromUrl(string);
                        if (string12 != null && string12.length() == 0 || string12.startsWith("(DESCRIPTION")) {
                            throw (SQLException)DatabaseError.createSqlException(207).fillInStackTrace();
                        }
                        if (!libraryLoaded) {
                            closeableLock = LOAD_LIBRARY_MONITOR.acquireCloseableLock();
                            throwable = null;
                            try {
                                if (libraryLoaded) break block126;
                                try {
                                    System.loadLibrary(dllName);
                                    libraryLoaded = true;
                                }
                                catch (Error error) {
                                    libraryLoaded = false;
                                    throw error;
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (closeableLock != null) {
                                    if (throwable != null) {
                                        try {
                                            closeableLock.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        closeableLock.close();
                                    }
                                }
                            }
                        }
                    }
                    if (this.connectionProperties != null) {
                        string13 = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
                    }
                }
                catch (Throwable throwable4) {
                    object = throwable4;
                    throw throwable4;
                }
                finally {
                    if (closeableLock2 != null) {
                        if (object != null) {
                            try {
                                closeableLock2.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)object).addSuppressed(throwable5);
                            }
                        } else {
                            closeableLock2.close();
                        }
                    }
                }
                if (string13 != null && string13.equalsIgnoreCase("true")) {
                    short s2 = T2CConnection.getDriverCharSetIdFromNLS_LANG();
                    this.driverCharSetIdString = Integer.toString(s2);
                } else if (!string12.equals(this.oldTnsEntry)) {
                    short s3 = T2CConnection.getClientCharSetId();
                    this.driverCharSetIdString = Integer.toString(s3);
                    this.oldTnsEntry = string12;
                }
                Monitor.CloseableLock closeableLock3 = this.acquireCloseableLock();
                object = null;
                try {
                    string9 = this.databaseName + dbSuffix + rmidSeed;
                    this.rmid = n2 = rmidSeed;
                    closeableLock = RMID_SEED_MONITOR.acquireCloseableLock();
                    throwable = null;
                    try {
                        rmidSeed = (rmidSeed + 1) % 65536;
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (closeableLock != null) {
                            if (throwable != null) {
                                try {
                                    closeableLock.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                closeableLock.close();
                            }
                        }
                    }
                    int n3 = 0;
                    throwable = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                    this.xaOpenString = string11 = this.generateXAOpenString(string9, string12, string2, string3, 60, 2000, true, true, ".", n3, false, throwable != null && ((String)((Object)throwable)).equalsIgnoreCase("true"), this.driverCharSetIdString, this.driverCharSetIdString);
                    string10 = this.generateXACloseString(string9, false);
                }
                catch (Throwable throwable8) {
                    object = throwable8;
                    throw throwable8;
                }
                finally {
                    if (closeableLock3 != null) {
                        if (object != null) {
                            try {
                                closeableLock3.close();
                            }
                            catch (Throwable throwable9) {
                                ((Throwable)object).addSuppressed(throwable9);
                            }
                        } else {
                            closeableLock3.close();
                        }
                    }
                }
                int n4 = this.t2cDoXaOpen(string11, n2, 0, 0);
                if (n4 != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * n4).fillInStackTrace();
                }
                n4 = this.t2cConvertOciHandles(string9, lArray);
                if (n4 != 0) {
                    throw (SQLException)DatabaseError.createSqlException(null, -1 * n4).fillInStackTrace();
                }
                properties.put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                properties.put("OCIEnvHandle", String.valueOf(lArray[1]));
                properties.put("JDBCDriverCharSetId", this.driverCharSetIdString);
                if (this.loginTimeout != 0) {
                    properties.put("oracle.net.CONNECT_TIMEOUT", "" + this.loginTimeout * 1000);
                }
                object = this.driver.connect(this.getURL(), properties);
                if (this.maxStatementsSet) {
                    ((OracleConnection)object).setStatementCacheSize(this.maxStatements);
                }
                if (this.explicitCachingEnabledSet) {
                    ((OracleConnection)object).setExplicitCachingEnabled(this.explicitCachingEnabled);
                }
                if (this.implicitCachingEnabledSet) {
                    ((OracleConnection)object).setImplicitCachingEnabled(this.implicitCachingEnabled);
                }
                if (this.maxStatements > 0 && !this.explicitCachingEnabled && !this.implicitCachingEnabled) {
                    ((OracleConnection)object).setImplicitCachingEnabled(true);
                    ((OracleConnection)object).setExplicitCachingEnabled(true);
                }
                OracleXAHeteroConnection oracleXAHeteroConnection = new OracleXAHeteroConnection((Connection)object);
                oracleXAHeteroConnection.setRmid(n2);
                oracleXAHeteroConnection.setXaCloseString(string10);
                oracleXAHeteroConnection.registerCloseCallback(new OracleXAHeteroCloseCallback(), oracleXAHeteroConnection);
                return oracleXAHeteroConnection;
            }
            if (this.useNativeXA && string.startsWith("jdbc:oracle:thin")) {
                Properties properties2 = new Properties();
                try (Serializable serializable = this.acquireCloseableLock();){
                    try (Monitor.CloseableLock closeableLock = RMID_SEED_MONITOR.acquireCloseableLock();){
                        this.rmid = rmidSeed = (rmidSeed + 1) % 65536;
                    }
                    if (this.connectionProperties == null) {
                        this.connectionProperties = new Properties();
                    }
                    this.connectionProperties.put("RessourceManagerId", Integer.toString(this.rmid));
                    if (string2 != null) {
                        properties2.setProperty("user", string2);
                    }
                    if (string3 != null) {
                        properties2.setProperty("password", string3);
                    }
                    if (this.maxStatementsSet) {
                        properties2.setProperty("stmt_cache_size", "" + this.maxStatements);
                    }
                    if (this.implicitCachingEnabledSet) {
                        properties2.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                    }
                    if (this.explicitCachingEnabledSet) {
                        properties2.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                    }
                    if (this.loginTimeout != 0) {
                        properties2.setProperty("LoginTimeout", "" + this.loginTimeout);
                    }
                    if (string4 != null) {
                        properties2.setProperty("oracle.jdbc.targetInstanceName", string4);
                    }
                    if (string5 != null) {
                        properties2.setProperty("oracle.jdbc.targetServiceName", string5);
                    }
                    if (string6 != null) {
                        properties2.setProperty("oracle.jdbc.targetShardingKey", string6);
                    }
                    if (string7 != null) {
                        properties2.setProperty("oracle.jdbc.targetSuperShardingKey", string7);
                    }
                    if ("true".equalsIgnoreCase(string8)) {
                        properties2.setProperty("oracle.jdbc.readOnlyInstanceAllowed", string8);
                    }
                }
                serializable = new T4CXAConnection(super.getPhysicalConnection(properties2, oracleXAConnectionBuilderImpl));
                var17_23 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
                ((OracleXAConnection)serializable).isXAResourceTransLoose = var17_23 != null && (((String)((Object)var17_23)).equals("true") || ((String)((Object)var17_23)).equalsIgnoreCase("true"));
                return serializable;
            }
            Properties properties3 = new Properties();
            try (Serializable serializable = this.acquireCloseableLock();){
                if (string2 != null) {
                    properties3.setProperty("user", string2);
                }
                if (string3 != null) {
                    properties3.setProperty("password", string3);
                }
                if (this.maxStatementsSet) {
                    properties3.setProperty("stmt_cache_size", "" + this.maxStatements);
                }
                if (this.implicitCachingEnabledSet) {
                    properties3.setProperty("ImplicitStatementCachingEnabled", "" + this.implicitCachingEnabled);
                }
                if (this.explicitCachingEnabledSet) {
                    properties3.setProperty("ExplicitStatementCachingEnabled", "" + this.explicitCachingEnabled);
                }
                if (this.loginTimeout != 0) {
                    properties3.setProperty("LoginTimeout", "" + this.loginTimeout);
                }
                if (string4 != null) {
                    properties3.setProperty("oracle.jdbc.targetInstanceName", string4);
                }
                if (string5 != null) {
                    properties3.setProperty("oracle.jdbc.targetServiceName", string5);
                }
                if (string6 != null) {
                    properties3.setProperty("oracle.jdbc.targetShardingKey", string6);
                }
                if (string7 != null) {
                    properties3.setProperty("oracle.jdbc.targetSuperShardingKey", string7);
                }
                if ("true".equalsIgnoreCase(string8)) {
                    properties3.setProperty("oracle.jdbc.readOnlyInstanceAllowed", string8);
                }
            }
            serializable = new OracleXAConnection(super.getPhysicalConnection(properties3, null));
            var17_24 = this.connectionProperties != null ? this.connectionProperties.getProperty("oracle.jdbc.XATransLoose") : null;
            ((OracleXAConnection)serializable).isXAResourceTransLoose = var17_24 != null && (((String)((Object)var17_24)).equals("true") || ((String)((Object)var17_24)).equalsIgnoreCase("true"));
            return serializable;
        }
        catch (XAException xAException) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xAException);
        }
    }

    private native int t2cDoXaOpen(String var1, int var2, int var3, int var4);

    private native int t2cConvertOciHandles(String var1, long[] var2);

    void setRmid(int n2) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.rmid = n2;
        }
    }

    int getRmid() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            int n2 = this.rmid;
            return n2;
        }
    }

    void setXaOpenString(String string) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.xaOpenString = string;
        }
    }

    String getXaOpenString() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            String string = this.xaOpenString;
            return string;
        }
    }

    @Blind
    private String generateXAOpenString(String string, String string2, String string3, @Blind String string4, int n2, int n3, boolean bl, boolean bl2, String string5, int n4, boolean bl3, boolean bl4, String string6, String string7) {
        return "ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n3 + "+SESWT=" + n2 + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n4 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f") + (bl4 ? "+Loose_Coupling=t" : "") + "+CharSet=" + string6 + "+NCharSet=" + string7;
    }

    private String generateXACloseString(String string, boolean bl) {
        return "ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f");
    }

    private String getTNSEntryFromUrl(String string) {
        int n2 = string.indexOf(64);
        return string.substring(n2 + 1);
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$19 = OracleXADataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = OracleXADataSource.class.getDeclaredMethod("access$100", OracleXADataSource.class, OracleXAConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = OracleXADataSource.class.getDeclaredMethod("access$000", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = OracleXADataSource.class.getDeclaredMethod("getTNSEntryFromUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = OracleXADataSource.class.getDeclaredMethod("generateXACloseString", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = OracleXADataSource.class.getDeclaredMethod("generateXAOpenString", String.class, String.class, String.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = OracleXADataSource.class.getDeclaredMethod("getXaOpenString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = OracleXADataSource.class.getDeclaredMethod("setXaOpenString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = OracleXADataSource.class.getDeclaredMethod("getRmid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = OracleXADataSource.class.getDeclaredMethod("setRmid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class, OracleXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = OracleXADataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = OracleXADataSource.class.getDeclaredMethod("getXAConnectionInternal", OracleXAConnectionBuilderImpl.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = OracleXADataSource.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", OracleXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = OracleXADataSource.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        libraryLoaded = false;
        LOAD_LIBRARY_MONITOR = Monitor.newInstance();
        rmidSeed = 0;
        RMID_SEED_MONITOR = Monitor.newInstance();
    }
}

