/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUCache;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.STATEMENT_CACHE})
final class LRUStatementCache {
    private int cacheSize;
    private final LRUCache<OraclePreparedStatement> implicitCache = new LRUCache(true);
    private final LRUCache<OraclePreparedStatement> explicitCache = new LRUCache(false);
    private boolean implicitCacheEnabled = false;
    private boolean explicitCacheEnabled = false;
    static final String DMS_HIT_COUNT_NAME = "StatementCacheHit";
    static final String DMS_HIT_COUNT_DESCRIPTION = "Statement found in cache";
    static final String DMS_MISS_COUNT_NAME = "StatementCacheMiss";
    static final String DMS_MISS_COUNT_DESCRIPTION = "Statement not found in cache";
    DMSFactory.DMSEvent dmsStatementCacheHitCount = null;
    DMSFactory.DMSEvent dmsStatementCacheMissCount = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    LRUStatementCache(int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
        }
        this.cacheSize = n2;
        this.implicitCache.vacancy(n2);
        this.explicitCache.vacancy(n2);
    }

    protected void createDMSSensors(DMSFactory.DMSNoun dMSNoun) {
        this.dmsStatementCacheHitCount = DMSFactory.getInstance().createEvent(dMSNoun, DMS_HIT_COUNT_NAME, DMS_HIT_COUNT_DESCRIPTION);
        this.dmsStatementCacheMissCount = DMSFactory.getInstance().createEvent(dMSNoun, DMS_MISS_COUNT_NAME, DMS_MISS_COUNT_DESCRIPTION);
    }

    public void resize(int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
        }
        while (this.implicitCache.size() > n2) {
            this.implicitCache.removeLeastRecent().exitImplicitCacheToClose();
        }
        while (this.explicitCache.size() > n2) {
            this.explicitCache.removeLeastRecent().exitImplicitCacheToClose();
        }
        this.cacheSize = n2;
        this.implicitCache.vacancy(n2);
        this.explicitCache.vacancy(n2);
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = bl;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        return bl;
    }

    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeExplicitCache();
        }
        this.explicitCacheEnabled = bl;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
        return bl;
    }

    void addToImplicitCache(OraclePreparedStatement oraclePreparedStatement, String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled || 0 == this.cacheSize || oraclePreparedStatement.cacheState == 2) {
            return;
        }
        oraclePreparedStatement.enterImplicitCache();
        this.implicitCache.add(oraclePreparedStatement, n2, n3, string);
        while (this.implicitCache.size() > this.cacheSize) {
            this.implicitCache.removeLeastRecent().exitImplicitCacheToClose();
        }
    }

    void addToExplicitCache(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        if (!this.explicitCacheEnabled || 0 == this.cacheSize || oraclePreparedStatement.cacheState == 2) {
            return;
        }
        oraclePreparedStatement.enterExplicitCache();
        this.explicitCache.add(oraclePreparedStatement, 0, 0, string);
        while (this.explicitCache.size() > this.cacheSize) {
            this.explicitCache.removeLeastRecent().exitExplicitCacheToClose();
        }
    }

    OracleStatement searchImplicitCache(String string, int n2, int n3, PhysicalConnection physicalConnection) throws SQLException {
        if (!this.implicitCacheEnabled || 0 == this.cacheSize) {
            return null;
        }
        OraclePreparedStatement oraclePreparedStatement = this.implicitCache.removeMostRecent(n2, n3, string);
        if (null != oraclePreparedStatement) {
            oraclePreparedStatement.exitImplicitCacheToActive();
            this.dmsStatementCacheHitCount.occurred();
        } else {
            this.dmsStatementCacheMissCount.occurred();
        }
        return oraclePreparedStatement;
    }

    OracleStatement searchExplicitCache(String string) throws SQLException {
        if (!this.explicitCacheEnabled || 0 == this.cacheSize) {
            return null;
        }
        OraclePreparedStatement oraclePreparedStatement = this.explicitCache.removeMostRecent(0, 0, string);
        if (null != oraclePreparedStatement) {
            oraclePreparedStatement.exitExplicitCacheToActive();
            this.dmsStatementCacheHitCount.occurred();
        } else {
            this.dmsStatementCacheMissCount.occurred();
        }
        return oraclePreparedStatement;
    }

    void purgeImplicitCache() throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = this.implicitCache.removeLeastRecent();
        while (null != oraclePreparedStatement) {
            oraclePreparedStatement.exitImplicitCacheToClose();
            oraclePreparedStatement = this.implicitCache.removeLeastRecent();
        }
    }

    void purgeExplicitCache() throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = this.explicitCache.removeLeastRecent();
        while (null != oraclePreparedStatement) {
            oraclePreparedStatement.exitExplicitCacheToClose();
            oraclePreparedStatement = this.explicitCache.removeLeastRecent();
        }
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    void close() throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = this.implicitCache.removeLeastRecent();
        while (null != oraclePreparedStatement) {
            oraclePreparedStatement.exitImplicitCacheToClose();
            oraclePreparedStatement = this.implicitCache.removeLeastRecent();
        }
        oraclePreparedStatement = this.explicitCache.removeLeastRecent();
        while (null != oraclePreparedStatement) {
            oraclePreparedStatement.exitExplicitCacheToClose();
            oraclePreparedStatement = this.explicitCache.removeLeastRecent();
        }
    }

    private OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    protected void clearCursorIds() {
        this.implicitCache.forEach(oraclePreparedStatement -> oraclePreparedStatement.clearCursorId());
        this.explicitCache.forEach(oraclePreparedStatement -> oraclePreparedStatement.clearCursorId());
    }

    public String toString() {
        return "implicitCache=" + this.implicitCache.toString() + ", explicitCache=" + this.explicitCache.toString();
    }

    static {
        try {
            $$$methodRef$$$19 = LRUStatementCache.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LRUStatementCache.class.getDeclaredMethod("lambda$clearCursorIds$0", OraclePreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LRUStatementCache.class.getDeclaredMethod("lambda$clearCursorIds$1", OraclePreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LRUStatementCache.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LRUStatementCache.class.getDeclaredMethod("clearCursorIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LRUStatementCache.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LRUStatementCache.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LRUStatementCache.class.getDeclaredMethod("getCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LRUStatementCache.class.getDeclaredMethod("purgeExplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LRUStatementCache.class.getDeclaredMethod("purgeImplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LRUStatementCache.class.getDeclaredMethod("searchExplicitCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LRUStatementCache.class.getDeclaredMethod("searchImplicitCache", String.class, Integer.TYPE, Integer.TYPE, PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LRUStatementCache.class.getDeclaredMethod("addToExplicitCache", OraclePreparedStatement.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LRUStatementCache.class.getDeclaredMethod("addToImplicitCache", OraclePreparedStatement.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LRUStatementCache.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LRUStatementCache.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LRUStatementCache.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LRUStatementCache.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LRUStatementCache.class.getDeclaredMethod("resize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LRUStatementCache.class.getDeclaredMethod("createDMSSensors", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

