/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import java.io.Closeable;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.util.logging.Logger;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public interface OracleJsonParser
extends Closeable {
    public boolean hasNext();

    public Event next();

    public String getString();

    public boolean isIntegralNumber();

    public int getInt();

    public long getLong();

    public double getDouble();

    public float getFloat();

    public BigInteger getBigInteger();

    public BigDecimal getBigDecimal();

    public Instant getInstant();

    public Period getPeriod();

    public Duration getDuration();

    public byte[] getBytes();

    public OracleJsonValue getValue();

    public OracleJsonArray getArray();

    public OracleJsonObject getObject();

    public void skipArray();

    public void skipObject();

    public <T> T wrap(Class<T> var1);

    @Override
    public void close();

    public static final class Event
    extends Enum<Event> {
        public static final /* enum */ Event START_ARRAY;
        public static final /* enum */ Event START_OBJECT;
        public static final /* enum */ Event KEY_NAME;
        public static final /* enum */ Event VALUE_STRING;
        public static final /* enum */ Event VALUE_DECIMAL;
        public static final /* enum */ Event VALUE_DOUBLE;
        public static final /* enum */ Event VALUE_FLOAT;
        public static final /* enum */ Event VALUE_BINARY;
        public static final /* enum */ Event VALUE_TIMESTAMP;
        public static final /* enum */ Event VALUE_DATE;
        public static final /* enum */ Event VALUE_INTERVALYM;
        public static final /* enum */ Event VALUE_INTERVALDS;
        public static final /* enum */ Event VALUE_TRUE;
        public static final /* enum */ Event VALUE_FALSE;
        public static final /* enum */ Event VALUE_NULL;
        public static final /* enum */ Event END_OBJECT;
        public static final /* enum */ Event END_ARRAY;
        private static final /* synthetic */ Event[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Event[] values() {
            return (Event[])$VALUES.clone();
        }

        public static Event valueOf(String string) {
            return Enum.valueOf(Event.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = Event.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Event.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Event.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            START_ARRAY = new Event();
            START_OBJECT = new Event();
            KEY_NAME = new Event();
            VALUE_STRING = new Event();
            VALUE_DECIMAL = new Event();
            VALUE_DOUBLE = new Event();
            VALUE_FLOAT = new Event();
            VALUE_BINARY = new Event();
            VALUE_TIMESTAMP = new Event();
            VALUE_DATE = new Event();
            VALUE_INTERVALYM = new Event();
            VALUE_INTERVALDS = new Event();
            VALUE_TRUE = new Event();
            VALUE_FALSE = new Event();
            VALUE_NULL = new Event();
            END_OBJECT = new Event();
            END_ARRAY = new Event();
            $VALUES = new Event[]{START_ARRAY, START_OBJECT, KEY_NAME, VALUE_STRING, VALUE_DECIMAL, VALUE_DOUBLE, VALUE_FLOAT, VALUE_BINARY, VALUE_TIMESTAMP, VALUE_DATE, VALUE_INTERVALYM, VALUE_INTERVALDS, VALUE_TRUE, VALUE_FALSE, VALUE_NULL, END_OBJECT, END_ARRAY};
        }
    }
}

