/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    private final String addressInfo;
    NetStatImpl netStat = null;
    Boolean useNio;
    int port;
    String host;
    String protocol;
    String uri;
    NVNavigator nav;
    NVPair nvpAddr;
    protected SocketChannelWrapper socketChannel;
    InetAddress[] inetAddresses = null;
    int count;
    int attempts;
    protected String httpProxy;
    protected int httpProxyPort;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private final ConnOption connOption;
    private static Hashtable<String, InetAddress[]> inetaddressesCache;
    private static Hashtable<String, Integer> circularOffsets;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    public TcpNTAdapter(String string, Properties properties, ConnOption connOption) throws NLException {
        this.socketOptions = properties;
        this.addressInfo = string;
        this.connOption = connOption;
        this.useNio = Boolean.parseBoolean((String)properties.get(20));
        this.nav = new NVNavigator();
        this.nvpAddr = new NVFactory().createNVPair(string);
        NVPair nVPair = this.nav.findNVPair(this.nvpAddr, "HOST");
        NVPair nVPair2 = this.nav.findNVPair(this.nvpAddr, "PORT");
        NVPair nVPair3 = this.nav.findNVPair(this.nvpAddr, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair.getAtom();
        if (nVPair2 != null) {
            try {
                this.port = Integer.parseInt(nVPair2.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        if (nVPair3 != null) {
            this.protocol = nVPair3.getAtom();
        }
        NVPair nVPair4 = this.nav.findNVPair(this.nvpAddr, "HTTPS_PROXY");
        NVPair nVPair5 = this.nav.findNVPair(this.nvpAddr, "HTTPS_PROXY_PORT");
        if (nVPair4 != null) {
            this.httpProxy = nVPair4.getAtom();
            if (nVPair5 != null) {
                this.httpProxyPort = Integer.parseInt(nVPair5.getAtom());
            }
        }
    }

    protected byte[] prepareTcpFastOpenDataAndGet() throws UnsupportedEncodingException, NetException {
        byte[] byArray = null;
        if (SQLnetDef.isTcpFastOpenEnabled((String)this.socketOptions.get(109))) {
            byArray = this.getTFOBytes(this.connOption.getConnectData());
            if (byArray == null) {
                byArray = this.getTFOBytes(this.connOption.getOriginalConnOption().getConnectData());
            }
            if (byArray != null) {
                this.connOption.setConnectData(new String(byArray));
            }
        }
        return byArray;
    }

    private byte[] getTFOBytes(String string) throws NetException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            NVPair nVPair;
            NVPair nVPair2 = new NVFactory().createNVPair(string);
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "CONNECT_DATA");
            if (nVPair3 == null) {
                return null;
            }
            NVPair nVPair4 = nVPair = nVNavigator.findNVPair(nVPair3, "USE_TCP_FAST_OPEN") != null ? nVNavigator.findNVPair(nVPair3, "USE_TCP_FAST_OPEN") : nVNavigator.findNVPair(nVPair3, "TFO");
            if (nVPair == null) {
                nVPair3.addListElement(new NVPair("USE_TCP_FAST_OPEN", "yes"));
            } else {
                nVPair.setAtom("yes");
            }
            String string2 = nVPair2.toString();
            return string2.getBytes("ASCII");
        }
        catch (Exception exception) {
            throw new NetException(102);
        }
    }

    @Override
    public void connect(NounIntf nounIntf) throws IOException {
        String string = (String)this.socketOptions.get(2);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        MetricsEnabledSocketFactory metricsEnabledSocketFactory = new MetricsEnabledSocketFactory(nounIntf);
        if (this.inetAddresses == null) {
            this.inetAddresses = InetAddress.getAllByName(this.host);
            if (bl && this.inetAddresses.length > 1) {
                this.inetAddresses = TcpNTAdapter.getAddressesInCircularOrder(this.host, this.inetAddresses);
            }
            DownHostsCache.getInstance().reorderAddresses(this.inetAddresses, this.port);
            this.attempts = this.inetAddresses.length;
            this.count = 0;
        }
        while (true) {
            InetAddress inetAddress = this.inetAddresses[this.count];
            ++this.count;
            --this.attempts;
            long l2 = System.currentTimeMillis();
            if (!this.useNio.booleanValue()) {
                this.socket = ((SocketFactory)metricsEnabledSocketFactory).createSocket();
            }
            try {
                if (this.useNio.booleanValue()) {
                    this.netStat = new NetStatImpl();
                    InetSocketAddress inetSocketAddress = null;
                    if (this.httpProxy != null) {
                        inetSocketAddress = new InetSocketAddress(this.httpProxy, this.httpProxyPort);
                    }
                    this.socketChannel = new TimeoutSocketChannel(new InetSocketAddress(inetAddress, this.port), Integer.parseInt(string), this.netStat, inetSocketAddress, this.prepareTcpFastOpenDataAndGet());
                    this.socket = this.socketChannel.socket();
                    break;
                }
                this.socket.connect(new InetSocketAddress(inetAddress, this.port), Integer.parseInt(string));
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.attempts > 0) continue;
                this.resetInetAddress();
                String string2 = String.format("%s, socket connect lapse %d ms. %s %d %s %d %s", iOException.getMessage(), System.currentTimeMillis() - l2, inetAddress.toString(), this.port, string, this.count, this.useNio);
                IOException iOException2 = new IOException(string2, iOException);
                throw iOException2;
                if (this.count < this.inetAddresses.length) continue;
            }
            break;
        }
        this.setReadTimeoutIfRequired(this.socketOptions);
        this.setSocketOptions();
    }

    @Override
    public boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.count < this.inetAddresses.length;
    }

    @Override
    public void resetInetAddress() {
        this.inetAddresses = null;
    }

    @Override
    public NetStat getNetStat() {
        return this.netStat;
    }

    public void setSocketOptions() throws IOException {
        String string = (String)this.socketOptions.get(0);
        if (string != null) {
            this.setOption(0, string);
        }
        if ((string = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, string);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel.disconnect();
            } else if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 0: {
                String string = (String)object;
                this.socket.setTcpNoDelay(string.equals("YES"));
                break;
            }
            case 1: {
                String string = (String)object;
                if (!string.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: 
            case 101: {
                this.sockTimeout = Integer.parseInt((String)object);
                if (!this.useNio.booleanValue()) {
                    this.socket.setSoTimeout(this.sockTimeout);
                    break;
                }
                this.socketChannel.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 101: {
                return "" + this.sockTimeout;
            }
            case 3: {
                if (!this.useNio.booleanValue()) {
                    return Integer.toString(this.socket.getSoTimeout());
                }
                return this.socketChannel.getSoTimeout();
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket != null) {
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket.close();
        }
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = (String)properties.get(3);
        }
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    public String getAddressInfo() {
        return this.addressInfo;
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    static final synchronized InetAddress[] getAddressesInCircularOrder(String string, InetAddress[] inetAddressArray) {
        InetAddress[] inetAddressArray2 = inetaddressesCache.get(string);
        Integer n2 = circularOffsets.get(string);
        if (inetAddressArray2 == null || !TcpNTAdapter.areEquals(inetAddressArray2, inetAddressArray)) {
            n2 = new Integer(0);
            inetAddressArray2 = inetAddressArray;
            inetaddressesCache.put(string, inetAddressArray);
            circularOffsets.put(string, n2);
        }
        InetAddress[] inetAddressArray3 = TcpNTAdapter.getCopyAddresses(inetAddressArray2, n2);
        circularOffsets.put(string, new Integer((n2 + 1) % inetAddressArray2.length));
        return inetAddressArray3;
    }

    private static final boolean areEquals(InetAddress[] inetAddressArray, InetAddress[] inetAddressArray2) {
        if (inetAddressArray.length != inetAddressArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            if (inetAddressArray[i2].equals(inetAddressArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] inetAddressArray, int n2) {
        InetAddress[] inetAddressArray2 = new InetAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            inetAddressArray2[i2] = inetAddressArray[(i2 + n2) % inetAddressArray.length];
        }
        return inetAddressArray2;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCP;
    }

    @Override
    @Blind
    public Properties getSqlNetOptions() {
        return (Properties)this.socketOptions.clone();
    }

    static {
        try {
            $$$methodRef$$$26 = TcpNTAdapter.class.getDeclaredConstructor(String.class, Properties.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = TcpNTAdapter.class.getDeclaredMethod("getSqlNetOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = TcpNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = TcpNTAdapter.class.getDeclaredMethod("getSocketChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = TcpNTAdapter.class.getDeclaredMethod("getInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = TcpNTAdapter.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = TcpNTAdapter.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = TcpNTAdapter.class.getDeclaredMethod("getCopyAddresses", InetAddress[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = TcpNTAdapter.class.getDeclaredMethod("areEquals", InetAddress[].class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = TcpNTAdapter.class.getDeclaredMethod("getAddressesInCircularOrder", String.class, InetAddress[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TcpNTAdapter.class.getDeclaredMethod("getAddressInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TcpNTAdapter.class.getDeclaredMethod("setReadTimeoutIfRequired", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpNTAdapter.class.getDeclaredMethod("isCharacteristicUrgentSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpNTAdapter.class.getDeclaredMethod("sendUrgentByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpNTAdapter.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpNTAdapter.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpNTAdapter.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpNTAdapter.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpNTAdapter.class.getDeclaredMethod("setSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpNTAdapter.class.getDeclaredMethod("getNetStat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpNTAdapter.class.getDeclaredMethod("resetInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpNTAdapter.class.getDeclaredMethod("hasMoreInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpNTAdapter.class.getDeclaredMethod("connect", NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpNTAdapter.class.getDeclaredMethod("getTFOBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpNTAdapter.class.getDeclaredMethod("prepareTcpFastOpenDataAndGet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        inetaddressesCache = new Hashtable();
        circularOffsets = new Hashtable();
    }
}

