/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;

public interface OracleLargeObject<T> {
    public void freeTemporary() throws SQLException;

    public boolean isTemporary() throws SQLException;

    public short getDuration() throws SQLException;

    public boolean isFree();

    public void setPrefetchData(PrefetchData<T> var1);

    public PrefetchData<T> getPrefetchData();

    public static final class ArrayPrefetchData<T>
    implements PrefetchData<T> {
        private final T array;
        private final int length;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        private ArrayPrefetchData(T t2, int n2) {
            this.array = t2;
            this.length = n2;
        }

        @Override
        public int copy(int n2, T t2, int n3, int n4) {
            int n5 = Math.min(n4, this.length - n2);
            if (n5 < 1) {
                return 0;
            }
            System.arraycopy(this.array, n2, t2, n3, n5);
            return n5;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public T share() {
            return this.array;
        }

        static {
            try {
                $$$methodRef$$$4 = ArrayPrefetchData.class.getDeclaredConstructor(Object.class, Integer.TYPE, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ArrayPrefetchData.class.getDeclaredConstructor(Object.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ArrayPrefetchData.class.getDeclaredMethod("share", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ArrayPrefetchData.class.getDeclaredMethod("length", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ArrayPrefetchData.class.getDeclaredMethod("copy", Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static interface PrefetchData<T> {
        public static <T> PrefetchData<T> wrapArray(T t2, int n2) {
            if (!(1.$assertionsDisabled || t2 != null && t2.getClass().isArray())) {
                throw new AssertionError((Object)("Not an array: " + t2));
            }
            return new ArrayPrefetchData(t2, n2);
        }

        public int copy(int var1, T var2, int var3, int var4);

        public int length();

        public T share();

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }
}

