/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4CTTIokeyval
extends T4CTTIfun {
    static final byte KVASET_KPDUSR = 1;
    static final byte KVACLA_KPDUSR = 2;
    static final int KVALDF_KVALKYL_MAX = 128;
    static final int KVALDF_KVALVLL_MAX = 65536;
    private byte[] namespaceByteArr;
    private char[] charArr;
    private byte[][] attrArr;
    private int[] attrArrSize;
    private byte[][] valueArr;
    private int[] valueArrSize;
    private byte[] kvalflg;
    private int nbNamespaceBytes;
    private int nbKeyVal;
    private boolean clear;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    T4CTTIokeyval(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)17);
        this.setFunCode((short)154);
        this.namespaceByteArr = new byte[100];
        this.charArr = new char[100];
        this.attrArr = new byte[10][];
        this.attrArrSize = new int[10];
        this.valueArr = new byte[10][];
        this.valueArrSize = new int[10];
        this.kvalflg = new byte[10];
    }

    void doOKEYVAL(Namespace namespace) throws IOException, SQLException {
        String string = namespace.name;
        String[] stringArray = namespace.keys;
        String[] stringArray2 = namespace.values;
        this.clear = namespace.clear;
        this.nbKeyVal = namespace.nbPairs;
        int n2 = string.length() * this.meg.conv.cMaxCharSize;
        if (n2 > this.namespaceByteArr.length) {
            this.namespaceByteArr = new byte[n2];
        }
        if (string.length() > this.charArr.length) {
            this.charArr = new char[string.length()];
        }
        string.getChars(0, string.length(), this.charArr, 0);
        this.nbNamespaceBytes = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.namespaceByteArr, 0, string.length());
        if (this.nbKeyVal > 0) {
            if (this.nbKeyVal > this.attrArr.length) {
                this.attrArr = new byte[this.nbKeyVal][];
                this.attrArrSize = new int[this.nbKeyVal];
                this.valueArr = new byte[this.nbKeyVal][];
                this.valueArrSize = new int[this.nbKeyVal];
                this.kvalflg = new byte[this.nbKeyVal];
            }
            for (int i2 = 0; i2 < this.nbKeyVal; ++i2) {
                String string2 = stringArray[i2];
                String string3 = stringArray2[i2];
                int n3 = string2.length() * this.meg.conv.cMaxCharSize;
                if (this.attrArr[i2] == null || this.attrArr[i2].length < n3) {
                    this.attrArr[i2] = new byte[n3];
                }
                int n4 = string3.length() * this.meg.conv.cMaxCharSize;
                if (this.valueArr[i2] == null || this.valueArr[i2].length < n4) {
                    this.valueArr[i2] = new byte[n4];
                }
                if (string2.length() > this.charArr.length) {
                    this.charArr = new char[string2.length()];
                }
                string2.getChars(0, string2.length(), this.charArr, 0);
                this.attrArrSize[i2] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.attrArr[i2], 0, string2.length());
                if (this.attrArrSize[i2] > 128) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 406, String.format("[%s] length %d, %d, %d", string2.length() > 128 ? string2.substring(0, 128) : string2, this.attrArrSize[i2], this.meg.conv.cMaxCharSize, string2.length())).fillInStackTrace();
                }
                if (string3.length() > this.charArr.length) {
                    this.charArr = new char[string3.length()];
                }
                string3.getChars(0, string3.length(), this.charArr, 0);
                this.valueArrSize[i2] = this.meg.conv.javaCharsToCHARBytes(this.charArr, 0, this.valueArr[i2], 0, string3.length());
                if (this.valueArrSize[i2] <= 65536) continue;
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 406, String.format("[%s] value length %d, %d, %d", string2, this.valueArrSize[i2], this.meg.conv.cMaxCharSize, string3.length())).fillInStackTrace();
            }
        }
        this.doPigRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.nbNamespaceBytes);
        if (this.nbKeyVal > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUB4(this.nbKeyVal);
        int n2 = 0;
        if (this.nbKeyVal > 0) {
            n2 = 1;
        }
        if (this.clear) {
            n2 |= 2;
        }
        this.meg.marshalUB2(n2);
        this.meg.marshalNULLPTR();
        this.meg.marshalCHR(this.namespaceByteArr, 0, this.nbNamespaceBytes);
        if (this.nbKeyVal > 0) {
            this.meg.marshalKEYVAL(this.attrArr, this.attrArrSize, this.valueArr, this.valueArrSize, this.kvalflg, this.nbKeyVal);
        }
    }

    static {
        try {
            $$$methodRef$$$2 = T4CTTIokeyval.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIokeyval.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIokeyval.class.getDeclaredMethod("doOKEYVAL", Namespace.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

