/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    T4C8TTIClob(T4CConnection t4CConnection) {
        super(t4CConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long read(byte[] byArray, long l2, long l3, boolean bl, char[] cArray, int n2) throws SQLException, IOException {
        long l4 = 0L;
        long l5 = l3;
        boolean bl2 = false;
        byte[] byArray2 = null;
        try {
            this.initializeLobdef();
            if ((byArray[6] & 0x80) == 128) {
                bl2 = true;
            }
            int n3 = 0;
            n3 = bl2 ? (int)l3 * 2 : (int)l3 * 3;
            byArray2 = this.connection.getByteBuffer(n3);
            if ((byArray[7] & 0x40) > 0) {
                this.littleEndianClob = true;
            }
            this.lobops = 2L;
            this.sourceLobLocator = byArray;
            this.sourceOffset = l2;
            this.lobamt = l3;
            this.sendLobamt = true;
            this.outBuffer = byArray2;
            this.doRPC();
            l5 = this.lobamt;
            long l6 = 0L;
            if (bl2) {
                if (this.connection.versionNumber < 10101) {
                    DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, cArray);
                } else if (this.littleEndianClob) {
                    CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
                } else {
                    CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
                }
            } else if (!bl) {
                this.nBytes[0] = (int)this.lobBytesRead;
                this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
            } else {
                this.nBytes[0] = (int)this.lobBytesRead;
                this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
            }
            this.outBuffer = null;
        }
        catch (Throwable throwable) {
            this.outBuffer = null;
            this.connection.cacheBuffer(byArray2);
            throw throwable;
        }
        this.connection.cacheBuffer(byArray2);
        return l5;
    }

    long write(byte[] byArray, long l2, boolean bl, char[] cArray, long l3, long l4) throws SQLException, IOException {
        boolean bl2 = false;
        if ((byArray[6] & 0x80) == 128) {
            bl2 = true;
        }
        if ((byArray[7] & 0x40) == 64) {
            this.littleEndianClob = true;
        }
        long l5 = 0L;
        byte[] byArray2 = null;
        int[] nArray = new int[]{-1};
        if (bl2) {
            byArray2 = new byte[(int)l4 * 2];
            nArray[0] = (int)l4;
            if (this.connection.versionNumber < 10101) {
                DBConversion.javaCharsToUcs2Bytes(cArray, (int)l3, byArray2, 0, (int)l4);
            } else if (this.littleEndianClob) {
                CharacterSet.convertJavaCharsToAL16UTF16LEBytes(cArray, (int)l3, byArray2, 0, (int)l4);
            } else {
                CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, (int)l3, byArray2, 0, (int)l4);
            }
        } else {
            boolean bl3;
            short s2;
            short s3;
            if (bl) {
                s2 = s3 = this.meg.conv.serverNCharSetId;
            } else {
                s2 = this.meg.conv.clientCharSetId;
                s3 = this.meg.conv.serverCharSetId;
            }
            LobAmtUnit lobAmtUnit = LobAmtUnit.get(s2, s3);
            if (nArray == null || nArray.length == 0) {
                bl3 = false;
            } else if (lobAmtUnit == LobAmtUnit.CODE_POINT) {
                bl3 = true;
            } else if (lobAmtUnit == LobAmtUnit.CODE_UNIT && s2 == 2000) {
                bl3 = false;
                nArray[0] = (int)l4;
            } else {
                bl3 = false;
                nArray[0] = -1;
            }
            byArray2 = new byte[(int)l4 * 3];
            l5 = this.meg.conv.javaCharsToCHARBytes(cArray, (int)l3, byArray2, 0, s2, (int)l4, (int[])(bl3 ? nArray : null));
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = nArray[0];
        this.sendLobamt = this.lobamt != -1L;
        this.inBuffer = byArray2;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = bl2 ? (this.connection.versionNumber < 10101 ? l4 : l4 * 2L) : l5;
        this.doRPC();
        long l6 = this.lobamt;
        return l6;
    }

    @Override
    Datum createTemporaryLob(Connection connection, boolean bl, int n2) throws SQLException, IOException {
        return this.createTemporaryLob(connection, bl, n2, (short)1);
    }

    Datum createTemporaryLob(Connection connection, boolean bl, int n2, short s2) throws SQLException, IOException {
        if (n2 == 12) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158).fillInStackTrace();
        }
        CLOB cLOB = null;
        this.initializeLobdef();
        this.lobops = 272L;
        int n3 = this.getTemporaryLobSize();
        this.sourceLobLocator = new byte[n3];
        this.sourceLobLocator[1] = (byte)(n3 - 2);
        this.sourceOffset = s2 == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = n2;
        this.lobamt = n2;
        this.sendLobamt = true;
        this.nullO2U = true;
        short s3 = this.characterSet = s2 == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = bl ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            cLOB = s2 == 1 ? new CLOB((OracleConnection)connection, this.sourceLobLocator) : new NCLOB((OracleConnection)connection, this.sourceLobLocator);
        }
        return cLOB;
    }

    @Override
    boolean open(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = false;
        int n3 = 2;
        if (n2 == 0) {
            n3 = 1;
        }
        bl = this._open(byArray, n3, 32768);
        return bl;
    }

    @Override
    boolean close(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._close(byArray, 65536);
        return bl;
    }

    @Override
    boolean isOpen(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._isOpen(byArray, 69632);
        return bl;
    }

    static {
        try {
            $$$methodRef$$$7 = T4C8TTIClob.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4C8TTIClob.class.getDeclaredMethod("isOpen", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4C8TTIClob.class.getDeclaredMethod("close", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4C8TTIClob.class.getDeclaredMethod("open", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4C8TTIClob.class.getDeclaredMethod("createTemporaryLob", Connection.class, Boolean.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4C8TTIClob.class.getDeclaredMethod("createTemporaryLob", Connection.class, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4C8TTIClob.class.getDeclaredMethod("write", byte[].class, Long.TYPE, Boolean.TYPE, char[].class, Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4C8TTIClob.class.getDeclaredMethod("read", byte[].class, Long.TYPE, Long.TYPE, Boolean.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static final class LobAmtUnit
    extends Enum<LobAmtUnit> {
        public static final /* enum */ LobAmtUnit CODE_UNIT;
        public static final /* enum */ LobAmtUnit CODE_POINT;
        public static final /* enum */ LobAmtUnit UNKNOWN;
        private static final /* synthetic */ LobAmtUnit[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        public static LobAmtUnit[] values() {
            return (LobAmtUnit[])$VALUES.clone();
        }

        public static LobAmtUnit valueOf(String string) {
            return Enum.valueOf(LobAmtUnit.class, string);
        }

        private static LobAmtUnit get(short s2, short s3) {
            if (s2 != s3) {
                return UNKNOWN;
            }
            switch (s2) {
                case 2000: {
                    return CODE_UNIT;
                }
                case 1: 
                case 2: 
                case 31: 
                case 46: 
                case 178: 
                case 871: 
                case 873: {
                    return CODE_POINT;
                }
            }
            return UNKNOWN;
        }

        static {
            try {
                $$$methodRef$$$4 = LobAmtUnit.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = LobAmtUnit.class.getDeclaredMethod("access$000", Short.TYPE, Short.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = LobAmtUnit.class.getDeclaredMethod("get", Short.TYPE, Short.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = LobAmtUnit.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = LobAmtUnit.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            CODE_UNIT = new LobAmtUnit();
            CODE_POINT = new LobAmtUnit();
            UNKNOWN = new LobAmtUnit();
            $VALUES = new LobAmtUnit[]{CODE_UNIT, CODE_POINT, UNKNOWN};
        }
    }
}

