/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.PickleOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public final class PickleContext {
    private PickleOutputStream outStream;
    byte[] image;
    int imageOffset;
    private byte[] byteBuffer = new byte[5];
    private int userCode = 0;
    static short KOPI20_LN_ELNL;
    static short KOPI20_LN_5BLN;
    static short KOPI20_LN_ATMN;
    static short KOPI20_LN_IEMN;
    static short KOPI20_LN_MAXV;
    static short KOPI20_IF_IS81;
    static short KOPI20_IF_CMSB;
    static short KOPI20_IF_CLSB;
    static short KOPI20_IF_DEGN;
    static short KOPI20_IF_COLL;
    static short KOPI20_IF_NOPS;
    static short KOPI20_IF_ANY;
    static short KOPI20_IF_NONL;
    static short KOPI20_CF_CMSB;
    static short KOPI20_CF_CLSB;
    static short KOPI20_CF_INDX;
    static short KOPI20_CF_NOLN;
    static short KOPI20_VERSION;
    public static final byte KOPU_UPT_INDEX_TBL = 1;
    public static final byte KOPU_UPT_NEST_TBL = 2;
    public static final byte KOPU_UPT_VARRAY = 3;
    public static final byte KOPU_UPT_ASSOC_ARRAY = 4;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;

    public PickleContext() {
    }

    public PickleContext(byte[] byArray) {
        this.image = byArray;
        this.imageOffset = 0;
    }

    public PickleContext(byte[] byArray, long l2) {
        this.image = byArray;
        this.imageOffset = (int)l2;
    }

    public void initStream(int n2) {
        this.outStream = new PickleOutputStream(n2);
    }

    public void initStream() {
        this.outStream = new PickleOutputStream();
    }

    public int lengthInBytes(int n2) {
        return n2 <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int writeElementNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeImmediatelyEmbeddedElementNull(byte by) throws SQLException {
        this.byteBuffer[0] = (byte)KOPI20_LN_IEMN;
        this.byteBuffer[1] = by;
        this.outStream.write(this.byteBuffer, 0, 2);
        return 2;
    }

    public int writeSB2(int n2) throws SQLException {
        this.byteBuffer[0] = (byte)(n2 >> 8 & 0xFF);
        this.byteBuffer[1] = (byte)(n2 & 0xFF);
        this.outStream.write(this.byteBuffer, 0, 2);
        return 2;
    }

    public int writeUB4(int n2) throws SQLException {
        this.byteBuffer[0] = (byte)(n2 >> 24 & 0xFF);
        this.byteBuffer[1] = (byte)(n2 >> 16 & 0xFF);
        this.byteBuffer[2] = (byte)(n2 >> 8 & 0xFF);
        this.byteBuffer[3] = (byte)(n2 & 0xFF);
        this.outStream.write(this.byteBuffer, 0, 4);
        return 4;
    }

    public int writeLength(int n2) throws SQLException {
        if (n2 <= KOPI20_LN_MAXV) {
            this.outStream.write((byte)n2);
            return 1;
        }
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)(n2 >> 24);
        this.byteBuffer[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(n2 &= 0xFF);
        try {
            this.outStream.write(this.byteBuffer);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return 5;
    }

    public int writeLength(int n2, boolean bl) throws SQLException {
        if (!bl) {
            return this.writeLength(n2);
        }
        if (n2 <= KOPI20_LN_MAXV - 1) {
            this.outStream.write((byte)n2 + 1);
            return 1;
        }
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)((n2 += 5) >> 24);
        this.byteBuffer[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(n2 &= 0xFF);
        try {
            this.outStream.write(this.byteBuffer);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return 5;
    }

    public byte[] to5bLengthBytes_pctx(int n2) throws SQLException {
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)(n2 >> 24);
        this.byteBuffer[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(n2 &= 0xFF);
        return this.byteBuffer;
    }

    public int writeData(byte by) throws SQLException {
        this.outStream.write(by);
        return 1;
    }

    public int writeData(byte[] byArray) throws SQLException {
        try {
            this.outStream.write(byArray);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return byArray.length;
    }

    public void patchImageLen(int n2, int n3) throws SQLException {
        byte[] byArray = this.to5bLengthBytes_pctx(n3);
        this.outStream.overwrite(n2, byArray, 0, byArray.length);
    }

    public int writeImageHeader(boolean bl) throws SQLException {
        return this.writeImageHeader(KOPI20_LN_MAXV + 1, bl);
    }

    public int writeOpaqueImageHeader(int n2) throws SQLException {
        int n3 = 2;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        return n3 += this.writeLength(n2 + 2, true);
    }

    public int writeImageHeader(int n2, boolean bl) throws SQLException {
        int n3 = 2;
        this.byteBuffer[0] = bl ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        return n3 += this.writeLength(n2);
    }

    public int writeCollImageHeader(int n2, int n3) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, n2, n3);
    }

    public int writeCollImageHeader(int n2, int n3, int n4) throws SQLException {
        int n5 = 5;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        n5 += this.writeLength(n2);
        this.byteBuffer[0] = 1;
        this.byteBuffer[1] = 17;
        if (n4 > KOPI20_LN_MAXV) {
            this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 5);
            n5 += 5;
            this.outStream.write(this.byteBuffer, 0, 2);
            this.writeLength(n4);
        } else {
            this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 2);
            n5 += 2;
            this.outStream.write(this.byteBuffer, 0, 2);
            this.writeSB2(n4);
        }
        this.byteBuffer[0] = this.userCode == 1 ? (byte)KOPI20_CF_INDX : (byte)0;
        this.outStream.write(this.byteBuffer, 0, 1);
        return n5 += this.writeLength(n3);
    }

    public int writeCollImageHeader(byte[] byArray) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, byArray);
    }

    public int writeCollImageHeader(int n2, byte[] byArray) throws SQLException {
        int n3 = byArray.length;
        int n4 = 3 + n3;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        n4 += this.writeLength(n2);
        this.byteBuffer[0] = 0;
        this.outStream.write(this.byteBuffer, 0, 1);
        this.outStream.write(byArray, 0, n3);
        return n4 += this.writeLength(n3 + 1);
    }

    public byte[] stream2Bytes() throws SQLException {
        return this.outStream.toByteArray();
    }

    public byte readByte() throws SQLException {
        try {
            byte by = this.image[this.imageOffset];
            return by;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public boolean readAndCheckVersion() throws SQLException {
        try {
            boolean bl = (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
            return bl;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public int readLength() throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        if (n2 > KOPI20_LN_MAXV) {
            if (n2 == KOPI20_LN_ELNL) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid null flag read").fillInStackTrace();
            }
            n2 = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        return n2;
    }

    public void skipLength() throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        this.imageOffset = n2 > KOPI20_LN_MAXV ? (this.imageOffset += 5) : ++this.imageOffset;
    }

    public int readRestOfLength(byte by) throws SQLException {
        if ((by & 0xFF) != KOPI20_LN_5BLN) {
            return by & 0xFF;
        }
        try {
            int n2 = (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[this.imageOffset + 1] & 0xFF)) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF);
            return n2;
        }
        finally {
            this.imageOffset += 4;
        }
    }

    public void skipRestOfLength(byte by) throws SQLException {
        if ((by & 0xFF) > KOPI20_LN_MAXV) {
            if ((by & 0xFF) == KOPI20_LN_5BLN) {
                this.imageOffset += 4;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid first length byte").fillInStackTrace();
            }
        }
    }

    public int readLength(boolean bl) throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        if (n2 > KOPI20_LN_MAXV) {
            n2 = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            if (bl) {
                n2 -= 5;
            }
            this.imageOffset += 5;
        } else {
            if (bl) {
                --n2;
            }
            ++this.imageOffset;
        }
        return n2;
    }

    public byte[] readPrefixSegment() throws SQLException {
        byte[] byArray = new byte[this.readLength()];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue() throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        if (n2 == KOPI20_LN_ELNL) {
            ++this.imageOffset;
            return null;
        }
        if (n2 > KOPI20_LN_MAXV) {
            n2 = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readBytes(int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, n2);
        this.imageOffset += n2;
        return byArray;
    }

    public byte[] read1ByteDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] byArray = new byte[this.image[this.imageOffset] & 0xFF];
        System.arraycopy(this.image, this.imageOffset + 1, byArray, 0, byArray.length);
        this.imageOffset += byArray.length + 1;
        return byArray;
    }

    public byte[] readDataValue(byte by) throws SQLException {
        byte[] byArray = new byte[this.readRestOfLength(by)];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue(int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, n2);
        this.imageOffset += n2;
        return byArray;
    }

    public long readUB4() throws SQLException {
        long l2 = (long)this.image[this.imageOffset++] << 24 & 0xFFFFFFFFFF000000L | (long)this.image[this.imageOffset++] << 16 & 0xFF0000L | (long)this.image[this.imageOffset++] << 8 & 0xFF00L | (long)this.image[this.imageOffset++] & 0xFFL;
        return l2;
    }

    public int readUB2() throws SQLException {
        int n2 = this.image[this.imageOffset++] << 8 & 0xFF00 | this.image[this.imageOffset++] & 0xFF;
        return n2;
    }

    public void skipDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.imageOffset;
        } else {
            this.skipBytes(this.readLength());
        }
    }

    public void skipDataValue(byte by) throws SQLException {
        this.skipBytes(this.readRestOfLength(by));
    }

    public void skipBytes(int n2) throws SQLException {
        if (n2 > 0) {
            this.imageOffset += n2;
        }
    }

    public int offset() throws SQLException {
        if (this.outStream != null) {
            return this.outStream.offset();
        }
        return this.imageOffset;
    }

    public int absoluteOffset() throws SQLException {
        return this.imageOffset;
    }

    public void skipTo(long l2) throws SQLException {
        if (l2 > (long)this.imageOffset) {
            this.imageOffset = (int)l2;
        }
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    public static boolean is81format(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isCollectionImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean hasPrefix(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public static boolean isAtomicNull(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isImmediatelyEmbeddedNull(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_IEMN;
    }

    public static boolean isElementNull(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ELNL;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    void setCollectionUserCode(int n2) {
        this.userCode = n2;
    }

    static {
        try {
            $$$methodRef$$$55 = PickleContext.class.getDeclaredConstructor(byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = PickleContext.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = PickleContext.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = PickleContext.class.getDeclaredMethod("setCollectionUserCode", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = PickleContext.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = PickleContext.class.getDeclaredMethod("isElementNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = PickleContext.class.getDeclaredMethod("isImmediatelyEmbeddedNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = PickleContext.class.getDeclaredMethod("isAtomicNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = PickleContext.class.getDeclaredMethod("hasPrefix", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = PickleContext.class.getDeclaredMethod("isDegenerateImage_pctx", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = PickleContext.class.getDeclaredMethod("isCollectionImage_pctx", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = PickleContext.class.getDeclaredMethod("is81format", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = PickleContext.class.getDeclaredMethod("image", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = PickleContext.class.getDeclaredMethod("skipTo", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = PickleContext.class.getDeclaredMethod("absoluteOffset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = PickleContext.class.getDeclaredMethod("offset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = PickleContext.class.getDeclaredMethod("skipBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = PickleContext.class.getDeclaredMethod("skipDataValue", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = PickleContext.class.getDeclaredMethod("skipDataValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = PickleContext.class.getDeclaredMethod("readUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = PickleContext.class.getDeclaredMethod("readUB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = PickleContext.class.getDeclaredMethod("readDataValue", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = PickleContext.class.getDeclaredMethod("readDataValue", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = PickleContext.class.getDeclaredMethod("read1ByteDataValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = PickleContext.class.getDeclaredMethod("readBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = PickleContext.class.getDeclaredMethod("readDataValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = PickleContext.class.getDeclaredMethod("readPrefixSegment", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = PickleContext.class.getDeclaredMethod("readLength", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = PickleContext.class.getDeclaredMethod("skipRestOfLength", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = PickleContext.class.getDeclaredMethod("readRestOfLength", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = PickleContext.class.getDeclaredMethod("skipLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = PickleContext.class.getDeclaredMethod("readLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = PickleContext.class.getDeclaredMethod("readAndCheckVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = PickleContext.class.getDeclaredMethod("readByte", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = PickleContext.class.getDeclaredMethod("stream2Bytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = PickleContext.class.getDeclaredMethod("writeCollImageHeader", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = PickleContext.class.getDeclaredMethod("writeImageHeader", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = PickleContext.class.getDeclaredMethod("writeOpaqueImageHeader", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = PickleContext.class.getDeclaredMethod("writeImageHeader", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = PickleContext.class.getDeclaredMethod("patchImageLen", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = PickleContext.class.getDeclaredMethod("writeData", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = PickleContext.class.getDeclaredMethod("writeData", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = PickleContext.class.getDeclaredMethod("to5bLengthBytes_pctx", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = PickleContext.class.getDeclaredMethod("writeLength", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = PickleContext.class.getDeclaredMethod("writeLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = PickleContext.class.getDeclaredMethod("writeUB4", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = PickleContext.class.getDeclaredMethod("writeSB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = PickleContext.class.getDeclaredMethod("writeImmediatelyEmbeddedElementNull", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = PickleContext.class.getDeclaredMethod("writeAtomicNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = PickleContext.class.getDeclaredMethod("writeElementNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = PickleContext.class.getDeclaredMethod("lengthInBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = PickleContext.class.getDeclaredMethod("initStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = PickleContext.class.getDeclaredMethod("initStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        KOPI20_LN_ELNL = (short)255;
        KOPI20_LN_5BLN = (short)254;
        KOPI20_LN_ATMN = (short)253;
        KOPI20_LN_IEMN = (short)252;
        KOPI20_LN_MAXV = (short)245;
        KOPI20_IF_IS81 = (short)128;
        KOPI20_IF_CMSB = (short)64;
        KOPI20_IF_CLSB = (short)32;
        KOPI20_IF_DEGN = (short)16;
        KOPI20_IF_COLL = (short)8;
        KOPI20_IF_NOPS = (short)4;
        KOPI20_IF_ANY = (short)2;
        KOPI20_IF_NONL = 1;
        KOPI20_CF_CMSB = (short)64;
        KOPI20_CF_CLSB = (short)32;
        KOPI20_CF_INDX = (short)16;
        KOPI20_CF_NOLN = (short)8;
        KOPI20_VERSION = 1;
    }
}

