/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.internal.NetStat;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.NTAdapter;
import org.ietf.jgss.GSSCredential;

public interface Communication {
    public void connect(String var1, Properties var2, NounIntf var3) throws IOException, NetException;

    public void connect(String var1, Properties var2, GSSCredential var3, SSLContext var4, NounIntf var5) throws IOException, NetException;

    public SessionAtts getSessionAttributes();

    public void cancelTimeout();

    public void disconnect() throws IOException, NetException;

    public void sendBreak() throws IOException, NetException;

    public void sendInterrupt() throws IOException, NetException;

    public void sendReset() throws IOException, NetException;

    public NetInputStream getNetInputStream() throws NetException, IOException;

    public InputStream getInputStream() throws NetException, IOException;

    public NetOutputStream getNetOutputStream() throws NetException, IOException;

    public OutputStream getOutputStream() throws NetException, IOException;

    public void setAuthSessionKey(byte[] var1) throws NetException, NetException;

    public void doKeyFoldinForExternalAuth();

    public void setOption(int var1, Object var2) throws NetException, IOException;

    public Object getOption(int var1) throws NetException, IOException;

    public void abort() throws NetException, IOException;

    public String getEncryptionName();

    public String getDataIntegrityName();

    public String getAuthenticationAdaptorName();

    public boolean readZeroCopyIO(byte[] var1, int var2, int[] var3) throws IOException;

    public void writeZeroCopyIO(byte[] var1, int var2, int var3) throws IOException;

    public boolean isConnectionSocketKeepAlive() throws SocketException;

    public int getSocketReadTimeout() throws NetException, IOException;

    public void setSocketReadTimeout(int var1) throws NetException, IOException;

    public String getConnectionString();

    public int getNegotiatedSDU() throws NetException;

    public String getAccessBanner();

    public NetStat getNetworkStat();

    public boolean isNetworkCompressionEnabled();

    public void sendZDP() throws IOException;

    public boolean needsToBeClosed();

    public void readInbandNotification();

    default public boolean isTLSEnabled() {
        SessionAtts sessionAtts = this.getSessionAttributes();
        if (sessionAtts == null) {
            return false;
        }
        NTAdapter nTAdapter = sessionAtts.getNTAdapter();
        if (nTAdapter == null) {
            return false;
        }
        return nTAdapter.getNetworkAdapterType() == NTAdapter.NetworkAdapterType.TCPS;
    }

    default public boolean isDnMatchingEnabled() {
        SessionAtts sessionAtts = this.getSessionAttributes();
        if (sessionAtts == null) {
            return false;
        }
        NTAdapter nTAdapter = sessionAtts.getNTAdapter();
        if (nTAdapter == null) {
            return false;
        }
        return nTAdapter.isDnMatchingEnabled();
    }
}

