/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonDecimalImpl
extends OracleJsonNumberImpl
implements OracleJsonDecimal {
    public static String NEGATIVE_INF;
    public static String POSITIVE_INF;
    byte[] raw;
    OracleJsonDecimal.TargetType type;
    private static DecimalFormat SCIENTIFIC_FORMAT_POSITIVE_EXP;
    private static DecimalFormat SCIENTIFIC_FORMAT_NEGATIVE_EXP;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public OracleJsonDecimalImpl(BigDecimal bigDecimal) {
        this.raw = OsonPrimitiveConversions.toNumber(bigDecimal);
    }

    public OracleJsonDecimalImpl(long l2) {
        this.raw = OsonPrimitiveConversions.toNumber(l2);
        this.type = OracleJsonDecimal.TargetType.LONG;
    }

    public OracleJsonDecimalImpl(int n2) {
        this.raw = OsonPrimitiveConversions.toNumber((long)n2);
        this.type = OracleJsonDecimal.TargetType.INT;
    }

    public OracleJsonDecimalImpl(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        this.raw = byArray;
        this.type = targetType;
    }

    public OracleJsonDecimalImpl(long l2, OracleJsonDecimal.TargetType targetType) {
        this.raw = OsonPrimitiveConversions.toNumber(l2);
        this.type = targetType;
    }

    public OracleJsonDecimalImpl(int n2, OracleJsonDecimal.TargetType targetType) {
        this.raw = OsonPrimitiveConversions.toNumber((long)n2);
        this.type = targetType;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DECIMAL;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonDecimal)) {
            return false;
        }
        OracleJsonDecimal oracleJsonDecimal = (OracleJsonDecimal)object;
        return this.bigDecimalValue().equals(oracleJsonDecimal.bigDecimalValue());
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    public void reset(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
        this.raw = byArray;
        this.type = targetType;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return OsonPrimitiveConversions.toBigDecimal(this.raw);
    }

    public byte[] raw() {
        return this.raw;
    }

    @Override
    public String getString() {
        BigDecimal bigDecimal;
        int n2;
        int n3 = this.raw.length;
        if (n3 <= 2) {
            if (OsonPrimitiveConversions.isNegInf(this.raw, n3, 0)) {
                return NEGATIVE_INF;
            }
            if (OsonPrimitiveConversions.isPosInf(this.raw)) {
                return POSITIVE_INF;
            }
        }
        if ((n2 = (bigDecimal = OsonPrimitiveConversions.toBigDecimal(this.raw)).precision()) <= 40) {
            return bigDecimal.toPlainString();
        }
        return OracleJsonDecimalImpl.format(bigDecimal);
    }

    private static String format(BigDecimal bigDecimal) {
        DecimalFormat decimalFormat = bigDecimal.scale() < 0 ? (DecimalFormat)SCIENTIFIC_FORMAT_NEGATIVE_EXP.clone() : (DecimalFormat)SCIENTIFIC_FORMAT_POSITIVE_EXP.clone();
        return decimalFormat.format(bigDecimal);
    }

    public boolean isDec() {
        return this.type == OracleJsonDecimal.TargetType.DECIMAL;
    }

    public boolean isSB4() {
        return this.type == OracleJsonDecimal.TargetType.INT;
    }

    public boolean isSB8() {
        return this.type == OracleJsonDecimal.TargetType.LONG;
    }

    @Override
    public NUMBER getNUMBER() {
        return new NUMBER(this.raw());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createNumber(this.raw, this.type));
    }

    @Override
    public OracleJsonDecimal.TargetType getTargetType() {
        return this.type;
    }

    static {
        try {
            $$$methodRef$$$19 = OracleJsonDecimalImpl.class.getDeclaredConstructor(Integer.TYPE, OracleJsonDecimal.TargetType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleJsonDecimalImpl.class.getDeclaredConstructor(Long.TYPE, OracleJsonDecimal.TargetType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleJsonDecimalImpl.class.getDeclaredConstructor(byte[].class, OracleJsonDecimal.TargetType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleJsonDecimalImpl.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleJsonDecimalImpl.class.getDeclaredConstructor(Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleJsonDecimalImpl.class.getDeclaredConstructor(BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleJsonDecimalImpl.class.getDeclaredMethod("getTargetType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleJsonDecimalImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleJsonDecimalImpl.class.getDeclaredMethod("getNUMBER", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleJsonDecimalImpl.class.getDeclaredMethod("isSB8", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleJsonDecimalImpl.class.getDeclaredMethod("isSB4", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleJsonDecimalImpl.class.getDeclaredMethod("isDec", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleJsonDecimalImpl.class.getDeclaredMethod("format", BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleJsonDecimalImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleJsonDecimalImpl.class.getDeclaredMethod("raw", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleJsonDecimalImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleJsonDecimalImpl.class.getDeclaredMethod("reset", byte[].class, OracleJsonDecimal.TargetType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleJsonDecimalImpl.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleJsonDecimalImpl.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleJsonDecimalImpl.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NEGATIVE_INF = "\"-Inf\"";
        POSITIVE_INF = "\"Inf\"";
        int n2 = 40;
        StringBuilder stringBuilder = new StringBuilder(n2 + 5);
        stringBuilder.append("0.");
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('#');
        }
        stringBuilder.append("E0");
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), DecimalFormatSymbols.getInstance(Locale.US));
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        SCIENTIFIC_FORMAT_POSITIVE_EXP = decimalFormat;
        SCIENTIFIC_FORMAT_NEGATIVE_EXP = (DecimalFormat)decimalFormat.clone();
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setExponentSeparator("E+");
        SCIENTIFIC_FORMAT_POSITIVE_EXP.setDecimalFormatSymbols(decimalFormatSymbols);
    }

    public static final class NumberType
    extends Enum<NumberType> {
        public static final /* enum */ NumberType NONE;
        public static final /* enum */ NumberType SB4;
        public static final /* enum */ NumberType SB8;
        public static final /* enum */ NumberType DEC128;
        private static final /* synthetic */ NumberType[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static NumberType[] values() {
            return (NumberType[])$VALUES.clone();
        }

        public static NumberType valueOf(String string) {
            return Enum.valueOf(NumberType.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = NumberType.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = NumberType.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = NumberType.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            NONE = new NumberType();
            SB4 = new NumberType();
            SB8 = new NumberType();
            DEC128 = new NumberType();
            $VALUES = new NumberType[]{NONE, SB4, SB8, DEC128};
        }
    }
}

