/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.METADATA})
class ArrayDataResultSet
extends OracleResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    private Boolean wasNull;
    private int fetchSize;
    OracleArray array;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;

    ArrayDataResultSet(PhysicalConnection physicalConnection, Datum[] datumArray, Map map) throws SQLException {
        super(physicalConnection);
        this.connection = physicalConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    ArrayDataResultSet(PhysicalConnection physicalConnection, Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        super(physicalConnection);
        this.connection = physicalConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(n3 - this.currentIndex, n2);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    ArrayDataResultSet(PhysicalConnection physicalConnection, OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        super(physicalConnection);
        this.connection = physicalConnection;
        this.array = oracleArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.array == null ? 0 : oracleArray.length();
        this.lastIndex = this.currentIndex + (n2 == -1 ? n3 - this.currentIndex : Math.min(n3 - this.currentIndex, n2));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    void ensureOpen() throws SQLException {
        this.ensureOpen(null);
    }

    void ensureOpen(String string) throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, string).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, string).fillInStackTrace();
        }
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        this.ensureOpen("getOracleStatement");
        return null;
    }

    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        this.ensureOpen("refreshRows");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return false;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return null;
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return null;
    }

    @Override
    int getColumnCount() throws SQLException {
        this.ensureOpen("getColumnCount");
        return 2;
    }

    @Override
    protected void doneFetchingRows(boolean bl) throws SQLException {
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen("next");
        ++this.currentIndex;
        return this.currentIndex <= this.lastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
        }
    }

    @Override
    public int getCursorId() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "getCursorId()").fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("wasNull");
            if (this.wasNull == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24, null).fillInStackTrace();
            }
            return this.wasNull;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ensureOpen("beforeFirst");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
    }

    @Override
    public void afterLast() throws SQLException {
        this.ensureOpen("afterLast");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "afterLast").fillInStackTrace();
    }

    @Override
    public boolean first() throws SQLException {
        this.ensureOpen("first");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first").fillInStackTrace();
    }

    @Override
    public boolean last() throws SQLException {
        this.ensureOpen("last");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "last").fillInStackTrace();
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.ensureOpen("absolute");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute").fillInStackTrace();
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        this.ensureOpen("relative");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "relative").fillInStackTrace();
    }

    @Override
    public boolean previous() throws SQLException {
        this.ensureOpen("previous");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "previous").fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getString");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ || datum instanceof TIMESTAMPLTZ) {
                    return datum.stringValue(this.connection);
                }
                return JavaToJavaConverter.convert(datum, String.class, this.connection, null, null);
            }
            return null;
        }
    }

    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCursor");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor").fillInStackTrace();
        }
    }

    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        this.ensureOpen("getOracleObject");
        if (this.currentIndex <= 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, null).fillInStackTrace();
        }
        if (this.currentIndex > this.lastIndex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, null).fillInStackTrace();
        }
        if (n2 == 1) {
            this.wasNull = Boolean.FALSE;
            return new NUMBER(this.currentIndex);
        }
        if (n2 == 2) {
            Datum[] datumArray;
            if (this.data != null) {
                this.wasNull = this.data[this.currentIndex - 1] == null ? Boolean.TRUE : Boolean.FALSE;
                return this.data[this.currentIndex - 1];
            }
            if (this.array != null && (datumArray = this.array.getOracleArray(this.currentIndex, 1)) != null && datumArray.length >= 1) {
                this.wasNull = datumArray[0] == null ? Boolean.TRUE : Boolean.FALSE;
                return datumArray[0];
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync").fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, null).fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getROWID");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    return (ROWID)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getNUMBER");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    return (NUMBER)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDATE");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof DATE) {
                    return (DATE)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getARRAY");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    return (ARRAY)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getSTRUCT");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return (STRUCT)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getOPAQUE");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    return (OPAQUE)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getREF");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof REF) {
                    return (REF)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCHAR");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    return (CHAR)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getRAW");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return (RAW)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBLOB");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    return (BLOB)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCLOB");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    return (CLOB)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBFILE");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    return (BFILE)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getINTERVALDS");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    return (INTERVALDS)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getINTERVALYM");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    return (INTERVALYM)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM").fillInStackTrace();
            }
            return null;
        }
    }

    @Override
    public BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTIMESTAMP");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    return (TIMESTAMP)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTIMESTAMPTZ");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    return (TIMESTAMPTZ)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTIMESTAMPLTZ");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    return (TIMESTAMPLTZ)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBoolean");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Boolean.class, this.connection, null, null);
            }
            return false;
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        this.ensureOpen("getAuthorizationIndicator");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getByte");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Byte.class, this.connection, null, null);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getShort");
            long l2 = this.getLong(n2);
            if (l2 > 32767L || l2 < -32768L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort").fillInStackTrace();
            }
            return (short)l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getInt");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Integer.class, this.connection, null, null);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getLong");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Long.class, this.connection, null, null);
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getFloat");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Float.class, this.connection, null, null).floatValue();
            }
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDouble");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Double.class, this.connection, null, null);
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBigDecimal");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, BigDecimal.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBytes");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return ((RAW)datum).shareBytes();
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDate");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, Date.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTime");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, Time.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTimestamp");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, Timestamp.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getAsciiStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.asciiStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getUnicodeStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBinaryStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.binaryStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            Object object = this.getObject(n2);
            return oracleDataFactory.create(object, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            return this.getObject(n2, this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCustomDatum");
            Datum datum = this.getOracleObject(n2);
            return customDatumFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getORAData");
            Datum datum = this.getOracleObject(n2);
            return oRADataFactory.create(datum, 0);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getMetaData");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData").fillInStackTrace();
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("findColumn");
            if (string.equalsIgnoreCase("index")) {
                return 1;
            }
            if (string.equalsIgnoreCase("value")) {
                return 2;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "findColumn").fillInStackTrace();
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureOpen("getStatement");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                return datum.toJdbc();
            }
            return null;
        }
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCharacterStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.characterStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBigDecimal");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, BigDecimal.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDate");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dATE != null) {
                    return JavaToJavaConverter.convert(datum, Date.class, this.connection, calendar, null);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTime");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dATE != null) {
                    return JavaToJavaConverter.convert(datum, Time.class, this.connection, calendar, null);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTimestamp");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dATE != null) {
                    return JavaToJavaConverter.convert(datum, Timestamp.class, this.connection, calendar, null);
                }
            }
            return null;
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getURL");
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getURL").fillInStackTrace();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCursorName");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        this.ensureOpen("getNClob");
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof NCLOB) {
                return (NCLOB)datum;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNClob").fillInStackTrace();
        }
        return null;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        this.ensureOpen("getNString");
        Datum datum = this.getOracleObject(n2);
        return JavaToJavaConverter.convert(datum, String.class, this.connection, null, null);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        this.ensureOpen("getNCharacterStream");
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        this.ensureOpen("getSQLXML");
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof SQLXML) {
                return (SQLXML)((Object)datum);
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML").fillInStackTrace();
        }
        return null;
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            Object object = this.getObject(n2);
            if (clazz.isInstance(object)) {
                return (T)object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getObject").fillInStackTrace();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureOpen("isBeforeFirst");
        return this.currentIndex < 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureOpen("isAfterLast");
        return this.currentIndex > this.lastIndex;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureOpen("isFirst");
        return this.currentIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureOpen("isLast");
        return this.currentIndex == this.lastIndex;
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureOpen("getRow");
        return this.currentIndex;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.ensureOpen("setFetchSize");
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize").fillInStackTrace();
        }
        this.fetchSize = n2 == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n2;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen("getType");
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen("getConcurrency");
        return 1007;
    }

    static {
        try {
            $$$methodRef$$$94 = ArrayDataResultSet.class.getDeclaredConstructor(PhysicalConnection.class, OracleArray.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$93 = ArrayDataResultSet.class.getDeclaredConstructor(PhysicalConnection.class, Datum[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$92 = ArrayDataResultSet.class.getDeclaredConstructor(PhysicalConnection.class, Datum[].class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$91 = ArrayDataResultSet.class.getDeclaredMethod("getConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$90 = ArrayDataResultSet.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$89 = ArrayDataResultSet.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$88 = ArrayDataResultSet.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$87 = ArrayDataResultSet.class.getDeclaredMethod("getRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$86 = ArrayDataResultSet.class.getDeclaredMethod("isLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$85 = ArrayDataResultSet.class.getDeclaredMethod("isFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$84 = ArrayDataResultSet.class.getDeclaredMethod("isAfterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$83 = ArrayDataResultSet.class.getDeclaredMethod("isBeforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = ArrayDataResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = ArrayDataResultSet.class.getDeclaredMethod("getSQLXML", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = ArrayDataResultSet.class.getDeclaredMethod("getRowId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = ArrayDataResultSet.class.getDeclaredMethod("getNCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = ArrayDataResultSet.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = ArrayDataResultSet.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = ArrayDataResultSet.class.getDeclaredMethod("getCursorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = ArrayDataResultSet.class.getDeclaredMethod("getURL", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = ArrayDataResultSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = ArrayDataResultSet.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = ArrayDataResultSet.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = ArrayDataResultSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = ArrayDataResultSet.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = ArrayDataResultSet.class.getDeclaredMethod("getArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = ArrayDataResultSet.class.getDeclaredMethod("getClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = ArrayDataResultSet.class.getDeclaredMethod("getBlob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = ArrayDataResultSet.class.getDeclaredMethod("getRef", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = ArrayDataResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = ArrayDataResultSet.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = ArrayDataResultSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = ArrayDataResultSet.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = ArrayDataResultSet.class.getDeclaredMethod("getORAData", Integer.TYPE, ORADataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = ArrayDataResultSet.class.getDeclaredMethod("getCustomDatum", Integer.TYPE, CustomDatumFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = ArrayDataResultSet.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = ArrayDataResultSet.class.getDeclaredMethod("getObject", Integer.TYPE, OracleDataFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = ArrayDataResultSet.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = ArrayDataResultSet.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = ArrayDataResultSet.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = ArrayDataResultSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = ArrayDataResultSet.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = ArrayDataResultSet.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = ArrayDataResultSet.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = ArrayDataResultSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = ArrayDataResultSet.class.getDeclaredMethod("getDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = ArrayDataResultSet.class.getDeclaredMethod("getFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = ArrayDataResultSet.class.getDeclaredMethod("getLong", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = ArrayDataResultSet.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = ArrayDataResultSet.class.getDeclaredMethod("getShort", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = ArrayDataResultSet.class.getDeclaredMethod("getByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = ArrayDataResultSet.class.getDeclaredMethod("getAuthorizationIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = ArrayDataResultSet.class.getDeclaredMethod("getBoolean", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = ArrayDataResultSet.class.getDeclaredMethod("getTIMESTAMPLTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = ArrayDataResultSet.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = ArrayDataResultSet.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = ArrayDataResultSet.class.getDeclaredMethod("getBfile", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = ArrayDataResultSet.class.getDeclaredMethod("getINTERVALYM", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = ArrayDataResultSet.class.getDeclaredMethod("getINTERVALDS", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = ArrayDataResultSet.class.getDeclaredMethod("getBFILE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = ArrayDataResultSet.class.getDeclaredMethod("getCLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = ArrayDataResultSet.class.getDeclaredMethod("getBLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = ArrayDataResultSet.class.getDeclaredMethod("getRAW", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = ArrayDataResultSet.class.getDeclaredMethod("getCHAR", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = ArrayDataResultSet.class.getDeclaredMethod("getREF", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = ArrayDataResultSet.class.getDeclaredMethod("getOPAQUE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = ArrayDataResultSet.class.getDeclaredMethod("getSTRUCT", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = ArrayDataResultSet.class.getDeclaredMethod("getARRAY", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ArrayDataResultSet.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ArrayDataResultSet.class.getDeclaredMethod("getNUMBER", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ArrayDataResultSet.class.getDeclaredMethod("getROWID", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ArrayDataResultSet.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ArrayDataResultSet.class.getDeclaredMethod("getCursor", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ArrayDataResultSet.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ArrayDataResultSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ArrayDataResultSet.class.getDeclaredMethod("relative", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ArrayDataResultSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ArrayDataResultSet.class.getDeclaredMethod("last", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ArrayDataResultSet.class.getDeclaredMethod("first", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ArrayDataResultSet.class.getDeclaredMethod("afterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ArrayDataResultSet.class.getDeclaredMethod("beforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ArrayDataResultSet.class.getDeclaredMethod("wasNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ArrayDataResultSet.class.getDeclaredMethod("getCursorId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ArrayDataResultSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ArrayDataResultSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ArrayDataResultSet.class.getDeclaredMethod("doneFetchingRows", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ArrayDataResultSet.class.getDeclaredMethod("getColumnCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ArrayDataResultSet.class.getDeclaredMethod("getRuntimeKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ArrayDataResultSet.class.getDeclaredMethod("getCompileKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ArrayDataResultSet.class.getDeclaredMethod("isFromResultSetCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ArrayDataResultSet.class.getDeclaredMethod("removeCurrentRowFromCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ArrayDataResultSet.class.getDeclaredMethod("refreshRows", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ArrayDataResultSet.class.getDeclaredMethod("getOracleStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ArrayDataResultSet.class.getDeclaredMethod("ensureOpen", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ArrayDataResultSet.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

