/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_METADATA})
public class OpaqueDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Opaque,
Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public OpaqueDescriptor(String string, Connection connection) throws SQLException {
        super((short)58, string, connection);
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$17, null, string, connection);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$17, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    public OpaqueDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)58, sQLName, connection);
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$18, null, sQLName, connection);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$18, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    public OpaqueDescriptor(SQLName sQLName, OracleTypeOPAQUE oracleTypeOPAQUE, Connection connection) throws SQLException {
        super((short)58, sQLName, oracleTypeOPAQUE, connection);
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$19, null, sQLName, oracleTypeOPAQUE, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$19, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    public OpaqueDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)58, oracleTypeADT, connection);
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$20, null, oracleTypeADT, connection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$20, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    OpaqueDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    public static OpaqueDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$0, null, string, connection);
            }
            if (string == null || string.length() == 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(60, "Invalid argument, 'name' shouldn't be null nor an empty string and 'conn' should not be null").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$0, null, sQLException);
                }
                throw sQLException;
            }
            SQLName sQLName = new SQLName(string, (OracleConnection)connection);
            String string2 = sQLName.getName();
            OpaqueDescriptor opaqueDescriptor = null;
            if (connection != null) {
                opaqueDescriptor = (OpaqueDescriptor)((OracleConnection)connection).getDescriptor(string2);
            }
            if (opaqueDescriptor == null) {
                if (string2.equals("SYS.ANYTYPE")) {
                    OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, string2, 7L);
                    opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
                } else if (string2.equals("SYS.ANYDATA")) {
                    OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, string2, 7L);
                    opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
                } else {
                    short s2 = ((OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
                    opaqueDescriptor = s2 >= 12000 ? new OpaqueDescriptor(string, connection) : new OpaqueDescriptor(sQLName, connection);
                }
                if (connection != null) {
                    ((OracleConnection)connection).putDescriptor(string2, opaqueDescriptor);
                }
            }
            return opaqueDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static OpaqueDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$1, null, sQLName, connection);
            }
            String string = sQLName.getName();
            OpaqueDescriptor opaqueDescriptor = null;
            if (connection != null) {
                opaqueDescriptor = (OpaqueDescriptor)((OracleConnection)connection).getDescriptor(string);
            }
            if (opaqueDescriptor == null) {
                if (string.equals("SYS.ANYTYPE")) {
                    OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, 0, string, 7L);
                    opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
                } else if (string.equals("SYS.ANYDATA")) {
                    OracleTypeOPAQUE oracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, 0, string, 7L);
                    opaqueDescriptor = new OpaqueDescriptor(sQLName, oracleTypeOPAQUE, connection);
                } else {
                    opaqueDescriptor = new OpaqueDescriptor(sQLName, connection);
                }
                if (connection != null) {
                    ((OracleConnection)connection).putDescriptor(string, opaqueDescriptor);
                }
            }
            return opaqueDescriptor;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$2, this, new Object[0]);
            }
            return OracleTypeMetaData.Kind.OPAQUE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initPickler() throws SQLException {
        try {
            String string = this.typeNameByUser;
            if (string == null) {
                string = this.getName();
            }
            this.pickler = new OracleTypeADT(string, (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup();
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (SQLException)DatabaseError.createSqlException(60, "Unable to resolve type \"" + this.getName() + "\"").fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toBytes(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.shareBytes() != null) {
            byArray = oPAQUE.shareBytes();
        } else {
            try {
                byArray = this.pickler.linearize(oPAQUE);
            }
            finally {
                if (!bl) {
                    oPAQUE.setShareBytes(null);
                }
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.value != null) {
            byArray = oPAQUE.value;
        } else {
            try {
                this.pickler.unlinearize(oPAQUE.shareBytes(), 0L, oPAQUE, 1, null);
                byArray = oPAQUE.value;
            }
            finally {
                if (!bl) {
                    oPAQUE.value = null;
                }
            }
        }
        return byArray;
    }

    @Override
    public int getTypeCode() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            if (this.sqlName != null && "SYS.XMLTYPE".equalsIgnoreCase(this.sqlName.getName()) || this.typeNameByUser != null && "SYS.XMLTYPE".equals(this.typeNameByUser)) {
                int n2 = 2009;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$6, this, n2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$6, this, null);
                }
                return 2009;
            }
            int n3 = 2007;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$6, this, n3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$6, this, null);
            }
            return 2007;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$7, this, string);
            }
            OpaqueDescriptor opaqueDescriptor = this;
            String string2 = opaqueDescriptor.getName();
            boolean bl2 = string.equals(string2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$7, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$7, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getMaxLength() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            long l3 = l2 = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$8, this, l3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$8, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isTrustedLibrary() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$9, this, new Object[0]);
            }
            boolean bl2 = ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$9, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$9, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isModeledInC() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$10, this, new Object[0]);
            }
            boolean bl2 = ((OracleTypeOPAQUE)this.pickler).isModeledInC();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$10, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$10, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean hasUnboundedSize() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$11, this, new Object[0]);
            }
            boolean bl2 = ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$11, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$11, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean hasFixedSize() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$12, this, new Object[0]);
            }
            boolean bl2 = ((OracleTypeOPAQUE)this.pickler).isFixedSized();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$12, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$12, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public String descType() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$13, this, new Object[0]);
            }
            StringBuffer stringBuffer = new StringBuffer();
            return this.descType(stringBuffer, 0);
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OpaqueDescriptor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    static {
        try {
            $$$methodRef$$$21 = OpaqueDescriptor.class.getDeclaredConstructor(byte[].class, Integer.TYPE, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = OpaqueDescriptor.class.getDeclaredConstructor(OracleTypeADT.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = OpaqueDescriptor.class.getDeclaredConstructor(SQLName.class, OracleTypeOPAQUE.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = OpaqueDescriptor.class.getDeclaredConstructor(SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = OpaqueDescriptor.class.getDeclaredConstructor(String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = OpaqueDescriptor.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = OpaqueDescriptor.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = OpaqueDescriptor.class.getDeclaredMethod("descType", StringBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = OpaqueDescriptor.class.getDeclaredMethod("descType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = OpaqueDescriptor.class.getDeclaredMethod("hasFixedSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = OpaqueDescriptor.class.getDeclaredMethod("hasUnboundedSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = OpaqueDescriptor.class.getDeclaredMethod("isModeledInC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = OpaqueDescriptor.class.getDeclaredMethod("isTrustedLibrary", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = OpaqueDescriptor.class.getDeclaredMethod("getMaxLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = OpaqueDescriptor.class.getDeclaredMethod("isInHierarchyOf", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = OpaqueDescriptor.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = OpaqueDescriptor.class.getDeclaredMethod("toValue", OPAQUE.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = OpaqueDescriptor.class.getDeclaredMethod("toBytes", OPAQUE.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = OpaqueDescriptor.class.getDeclaredMethod("initPickler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = OpaqueDescriptor.class.getDeclaredMethod("getKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = OpaqueDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = OpaqueDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

