/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleClob.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableClob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETASCIISTREAM_METHOD;
    private static final Method GETASCIISTREAM_LONG_METHOD;
    private static final Method GETCHARSTREAM_METHOD;
    private static final Method GETCHARSTREAM_LONG_METHOD;
    private static final Method GETCHARSTREAM_LONG_LONG_METHOD;
    private static final Method SETASCIISTREAM_LONG_METHOD;
    private static final Method SETCHARSTREAM_LONG_METHOD;
    protected boolean isFreed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    protected TxnReplayableClob() {
        this.thisProxyNameInLog = "CLOB" + this.thisProxyNameInLog;
    }

    private static final Method getGetAsciiStreamMethod() {
        try {
            return OracleClob.class.getMethod("getAsciiStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetAsciiStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("getAsciiStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamMethod() {
        try {
            return OracleClob.class.getMethod("getCharacterStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("getCharacterStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongLongMethod() {
        try {
            return OracleClob.class.getMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetAsciiStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("setAsciiStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetCharacterStreamLongMethod() {
        try {
            return OracleClob.class.getMethod("setCharacterStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof TxnReplayableBase) {
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)object;
            txnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method method) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle;
        super.postForAll(method);
        if (!this.isFreed && (replayLifecycle = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
        this.isFreed = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (callHistoryEntry == this.headSameProxy) {
            this.isFreed = false;
        }
        return super.replayOneCall(callHistoryEntry, sQLRecoverableException);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (GETASCIISTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method method = GETASCIISTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getAsciiStream() : oracleClob.getDBAccess().newInputStream((OracleClob)((Object)this), oracleClob.getBufferSize(), 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        if (GETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method method = GETASCIISTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            InputStream inputStream;
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                inputStream = oracleClob.getAsciiStream(l2);
            } else {
                if (l2 < 1L) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleClob.getDBAccess().newInputStream((OracleClob)((Object)this), oracleClob.getBufferSize(), l2);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (GETCHARSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Reader reader = oracleClob.canReadBasicLobDataInLocator() ? oracleClob.getCharacterStream() : oracleClob.getDBAccess().newReader((OracleClob)((Object)this), oracleClob.getBufferSize(), 0L);
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (GETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            Reader reader;
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                reader = oracleClob.getCharacterStream(l2);
            } else {
                if (l2 < 1L) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = oracleClob.getDBAccess().newReader((OracleClob)((Object)this), oracleClob.getBufferSize(), l2);
            }
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (GETCHARSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method method = GETCHARSTREAM_LONG_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2, l3);
        try {
            Reader reader;
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleClob.canReadBasicLobDataInLocator()) {
                reader = oracleClob.getCharacterStream(l2, l3);
            } else {
                long l4 = oracleClob.length();
                if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                reader = oracleClob.getDBAccess().newReader((OracleClob)((Object)this), oracleClob.getBufferSize(), l2, l3);
            }
            return (Reader)this.postForAll(method, reader);
        }
        catch (SQLException sQLException) {
            return (Reader)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (SETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
        }
        Method method = SETASCIISTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OutputStream outputStream = oracleClob.getDBAccess().newOutputStream((OracleClob)((Object)this), oracleClob.getBufferSize(), l2, true);
            return (OutputStream)this.postForAll(method, outputStream);
        }
        catch (SQLException sQLException) {
            return (OutputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        if (SETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set character stream");
        }
        Method method = SETCHARSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleClob oracleClob = (OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleClob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Writer writer = oracleClob.getDBAccess().newWriter((OracleClob)((Object)this), oracleClob.getBufferSize(), l2, true);
            return (Writer)this.postForAll(method, writer);
        }
        catch (SQLException sQLException) {
            return (Writer)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(1L);
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        return this.setAsciiStream(l2);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(1L);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        return this.setCharacterStream(l2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleClob oracleClob = (OracleClob)this.getDelegate();
        return oracleClob.getInternalConnection();
    }

    static {
        try {
            $$$methodRef$$$27 = TxnReplayableClob.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnReplayableClob.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnReplayableClob.class.getDeclaredMethod("getCharacterOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnReplayableClob.class.getDeclaredMethod("getCharacterOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnReplayableClob.class.getDeclaredMethod("getAsciiOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnReplayableClob.class.getDeclaredMethod("getAsciiOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnReplayableClob.class.getDeclaredMethod("setCharacterStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnReplayableClob.class.getDeclaredMethod("setAsciiStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableClob.class.getDeclaredMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableClob.class.getDeclaredMethod("getCharacterStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableClob.class.getDeclaredMethod("getCharacterStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableClob.class.getDeclaredMethod("getAsciiStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableClob.class.getDeclaredMethod("getAsciiStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableClob.class.getDeclaredMethod("replayOneCall", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableClob.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableClob.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableClob.class.getDeclaredMethod("postForFree", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableClob.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableClob.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableClob.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableClob.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableClob.class.getDeclaredMethod("getSetCharacterStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableClob.class.getDeclaredMethod("getSetAsciiStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableClob.class.getDeclaredMethod("getGetCharacterStreamLongLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableClob.class.getDeclaredMethod("getGetCharacterStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableClob.class.getDeclaredMethod("getGetCharacterStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableClob.class.getDeclaredMethod("getGetAsciiStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableClob.class.getDeclaredMethod("getGetAsciiStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETASCIISTREAM_METHOD = TxnReplayableClob.getGetAsciiStreamMethod();
        GETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getGetAsciiStreamLongMethod();
        GETCHARSTREAM_METHOD = TxnReplayableClob.getGetCharacterStreamMethod();
        GETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongMethod();
        GETCHARSTREAM_LONG_LONG_METHOD = TxnReplayableClob.getGetCharacterStreamLongLongMethod();
        SETASCIISTREAM_LONG_METHOD = TxnReplayableClob.getSetAsciiStreamLongMethod();
        SETCHARSTREAM_LONG_METHOD = TxnReplayableClob.getSetCharacterStreamLongMethod();
    }
}

