/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pooling.kdtree;

import java.lang.reflect.Executable;
import java.util.Objects;
import java.util.logging.Logger;

public class Range {
    private final boolean infinite;
    private final Comparable low;
    private final Comparable high;
    private int hashCode;
    public static final Range INFINITE;
    private static final String IR = "infinite range";
    private static final IllegalStateException IRE;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public Range(Comparable comparable, Comparable comparable2) {
        this.infinite = false;
        this.low = comparable;
        this.high = comparable2;
        this.hashCode = Objects.hash(comparable, comparable2, this.infinite);
        if (!comparable.getClass().equals(comparable2.getClass())) {
            throw new IllegalArgumentException("incompatible coordinates");
        }
    }

    public Range(Comparable comparable) {
        this(comparable, comparable);
    }

    private Range() {
        this.high = IR;
        this.low = IR;
        this.infinite = true;
    }

    public Comparable low() {
        if (this.infinite) {
            throw IRE;
        }
        return this.low;
    }

    public Comparable high() {
        if (this.infinite) {
            throw IRE;
        }
        return this.high;
    }

    public boolean infinite() {
        return this.infinite;
    }

    public String toString() {
        if (this.infinite()) {
            return "[INFINITE]";
        }
        return "[" + this.low + ", " + this.high + "]";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (null != object && object instanceof Range) {
            Range range = (Range)object;
            if (this.hashCode() != range.hashCode()) {
                return false;
            }
            return Objects.equals(this.low, range.low) && Objects.equals(this.high, range.high) && Objects.equals(this.infinite, range.infinite);
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$8 = Range.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = Range.class.getDeclaredConstructor(Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = Range.class.getDeclaredConstructor(Comparable.class, Comparable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = Range.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Range.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Range.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Range.class.getDeclaredMethod("infinite", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Range.class.getDeclaredMethod("high", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Range.class.getDeclaredMethod("low", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        INFINITE = new Range();
        IRE = new IllegalStateException(IR);
    }
}

