/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderContHandler;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderDomHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
class OracleWebRowSetXmlReaderImpl
implements OracleWebRowSetXmlReader {
    private static final String JAVA_SAXPARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    private static final String JAVA_DOMPARSER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String ORACLE_JAXP_SAXPARSER_FACTORY = "oracle.xml.jaxp.JXSAXParserFactory";
    private static final String ORACLE_JAXP_DOMPARSER_FACTORY = "oracle.xml.jaxp.JXDocumentBuilderFactory";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String WEBROWSET_SCHEMA = "http://oracle.com/webfolder/technetwork/jsc/xml/ns/jdbc/webrowset.xsd";
    private Document document = null;
    private String parserStr = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    OracleWebRowSetXmlReaderImpl() {
    }

    @Override
    public void readXML(WebRowSet webRowSet, Reader reader) throws SQLException {
        this.parserStr = this.getSystemProperty(JAVA_SAXPARSER_PROPERTY);
        if (this.parserStr != null) {
            this.readXMLSax((OracleWebRowSet)webRowSet, reader);
        } else {
            this.parserStr = this.getSystemProperty(JAVA_DOMPARSER_PROPERTY);
            if (this.parserStr != null) {
                this.readXMLDom((OracleWebRowSet)webRowSet, reader);
            } else {
                throw new SQLException("No valid JAXP parser property specified");
            }
        }
    }

    @Override
    public void readData(RowSetInternal rowSetInternal) throws SQLException {
    }

    private void readXMLSax(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            OracleWebRowSetXmlReaderContHandler oracleWebRowSetXmlReaderContHandler = new OracleWebRowSetXmlReaderContHandler(oracleWebRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            sAXParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            sAXParser.setProperty(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(oracleWebRowSetXmlReaderContHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            sAXParseException.printStackTrace();
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
            throw new SQLException("readXMLSax: SAXNotRecognizedException: " + sAXNotRecognizedException.getMessage());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new SQLException("readXMLSax: SAXException: " + sAXException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            throw new SQLException("readXMLSax: Parser factory config: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SQLException("readXMLSax: Parser config: " + parserConfigurationException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("readXMLSax: " + exception.getMessage());
        }
    }

    private void readXMLDom(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            OracleWebRowSetXmlReaderDomHandler oracleWebRowSetXmlReaderDomHandler = new OracleWebRowSetXmlReaderDomHandler(oracleWebRowSet);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.parse(inputSource);
            oracleWebRowSetXmlReaderDomHandler.readXMLDocument(this.document);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new SQLException("readXMLDom: SAXException: " + sAXException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            throw new SQLException("readXMLDom: Parser factory config: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SQLException("readXMLDom: Parser config: " + parserConfigurationException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("readXMLDom: " + exception.getMessage());
        }
    }

    private String getSystemProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    static {
        try {
            $$$methodRef$$$5 = OracleWebRowSetXmlReaderImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("getSystemProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readXMLDom", OracleWebRowSet.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readXMLSax", OracleWebRowSet.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readData", RowSetInternal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleWebRowSetXmlReaderImpl.class.getDeclaredMethod("readXML", WebRowSet.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

