/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.driver.FailoverManager;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
class FailoverManagerImpl
implements FailoverManager,
Monitor {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private boolean replayInCurrentMode = false;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 900L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private OracleDataSource replayDataSource = null;
    private NonTxnReplayableBase connectionProxy;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private static final ExecutorService executor;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    private FailoverManagerImpl(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        this.connectionProxy = nonTxnReplayableBase;
        this.replayDataSource = oracleDataSource;
        this.enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
    }

    static FailoverManager getFailoverManager(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        return new FailoverManagerImpl(nonTxnReplayableBase, oracleDataSource);
    }

    private void append(CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntry = this.tail;
        callHistoryEntry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = callHistoryEntry;
        }
        this.tail = callHistoryEntry;
        if (this.head == null) {
            this.head = callHistoryEntry;
        }
        Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
        replayable.addToSameProxyList(callHistoryEntry);
    }

    private void remove(CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntry != null) {
            callHistoryEntry.nextEntry.prevEntry = callHistoryEntry.prevEntry;
        }
        if (callHistoryEntry.prevEntry != null) {
            callHistoryEntry.prevEntry.nextEntry = callHistoryEntry.nextEntry;
        }
        if (this.head == callHistoryEntry) {
            this.head = callHistoryEntry.nextEntry;
        }
        if (this.tail == callHistoryEntry) {
            this.tail = callHistoryEntry.prevEntry;
        }
        Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
        replayable.removeFromSameProxyList(callHistoryEntry);
    }

    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            String string2 = method == null ? "NULL METHOD" : method.getName();
            StringBuilder stringBuilder = new StringBuilder();
            if (objectArray != null && objectArray.length > 0) {
                for (int i2 = 0; i2 < objectArray.length - 1; ++i2) {
                    stringBuilder.append(objectArray[i2]);
                    stringBuilder.append(",");
                }
                stringBuilder.append(objectArray[objectArray.length - 1]);
            }
            CallHistoryEntry callHistoryEntry = new CallHistoryEntry(object, method, objectArray, string);
            this.append(callHistoryEntry);
            CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
            return callHistoryEntry2;
        }
    }

    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, long l3, SQLException sQLException) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            CallHistoryEntry callHistoryEntry2 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            String string2 = callHistoryEntry2 == null || callHistoryEntry2.method == null ? "NULL METHOD" : callHistoryEntry2.method.getName();
            callHistoryEntry2.result = object2;
            callHistoryEntry2.checksum = l2;
            callHistoryEntry2.scn = l3;
            callHistoryEntry2.callException = sQLException;
            callHistoryEntry2.callStatus = string;
        }
    }

    void purge() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            CallHistoryEntry callHistoryEntry = this.head;
            while (callHistoryEntry != null) {
                this.remove(callHistoryEntry);
                callHistoryEntry = callHistoryEntry.nextEntry;
            }
        }
    }

    void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            Object object = callHistoryEntry == null ? null : callHistoryEntry.jdbcProxy;
            CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
            while (callHistoryEntry2 != null) {
                Object object2 = callHistoryEntry2.result;
                if (object2 != null && object2 instanceof Replayable && !set.contains(object2)) {
                    Replayable replayable = (Replayable)object2;
                    replayable.purgeSameProxyList();
                    set.add(replayable);
                }
                this.remove(callHistoryEntry2);
                callHistoryEntry2 = callHistoryEntry2.nextEntrySameProxy;
            }
        }
    }

    boolean isEmpty() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            boolean bl = this.head == null;
            return bl;
        }
    }

    void fillInAllChecksums() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            HashSet<Object> hashSet = new HashSet<Object>();
            CallHistoryEntry callHistoryEntry = this.tail.prevEntry;
            while (callHistoryEntry != null) {
                if (!hashSet.contains(callHistoryEntry.jdbcProxy)) {
                    NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)callHistoryEntry.jdbcProxy;
                    nonTxnReplayableBase.fillInChecksum(callHistoryEntry);
                    hashSet.add(callHistoryEntry.jdbcProxy);
                    if (callHistoryEntry.jdbcProxy instanceof ResultSet) {
                        hashSet.add(nonTxnReplayableBase.getCreator());
                    }
                }
                callHistoryEntry = callHistoryEntry.prevEntry;
            }
        }
    }

    /*
     * Exception decompiling
     */
    Object replayAll(SQLRecoverableException var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Object replayAllInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            Object object;
            OracleConnection oracleConnection;
            ReplayLifecycle replayLifecycle = this.lifecycle;
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
            }
            if ((oracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((NonTxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
            }
            long l2 = System.currentTimeMillis();
            if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
                this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
            }
            this.connectionProxy.setDelegate(oracleConnection);
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
            this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
            ConnectionInitializationCallback connectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
            if (connectionInitializationCallback != null) {
                try {
                    connectionInitializationCallback.initialize((Connection)((Object)this.connectionProxy));
                }
                catch (SQLException sQLException) {
                    this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", sQLRecoverableException);
                }
                object = oracleConnection.getTransactionState();
                if (((AbstractCollection)object).contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                    this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", sQLRecoverableException);
                }
            }
            this.lifecycle = ReplayLifecycle.REPLAYING;
            if (n2 == 0) {
                this.fillInAllChecksums();
            }
            this.beginReplay(oracleConnection, sQLRecoverableException);
            this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
            this.endReplay(oracleConnection, sQLRecoverableException);
            if (this.tail != null) {
                this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, sQLRecoverableException);
            }
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
            object = this.replayResult;
            return object;
        }
    }

    private Object replayAllBeforeLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            Object object = null;
            CallHistoryEntry callHistoryEntry = this.head;
            while (callHistoryEntry != this.tail) {
                Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
                object = replayable.replayOneCall(callHistoryEntry, sQLRecoverableException);
                if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                    this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                }
                callHistoryEntry = callHistoryEntry.nextEntry;
            }
            callHistoryEntry = object;
            return callHistoryEntry;
        }
    }

    boolean isReplayInCurrentMode() {
        return this.replayInCurrentMode;
    }

    void setReplayInCurrentMode() {
        this.replayInCurrentMode = true;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource oracleDataSource) {
        this.replayDataSource = oracleDataSource;
    }

    void setReplayInitiationTimeout(int n2) throws SQLException {
        this.replayInitiationTimeout = n2;
    }

    void beginRequest() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(391);
        }
        this.requestStartTime = System.currentTimeMillis();
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(392);
            throw sQLException;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
    }

    void endRequest() throws SQLException {
        block9: {
            block8: {
                OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
                EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                    try {
                        oracleConnection.rollback();
                    }
                    catch (SQLException sQLException) {
                    }
                    SQLException sQLException = DatabaseError.createSqlException(393);
                    throw sQLException;
                }
                if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                    return;
                }
                if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED) break block8;
                if (this.lifecycle != ReplayLifecycle.EXTERNALLY_DISABLED) break block9;
            }
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
    }

    void disableReplay() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
    }

    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        try {
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
        }
        catch (SQLException sQLException) {
        }
    }

    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
    }

    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (n2 == 0) {
            return;
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        throw sQLException;
    }

    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwOriginalExceptionWithReplayError(n2, string, sQLRecoverableException);
    }

    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.failReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        this.killConnectionBeforeReplayDisabledException();
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        sQLRecoverableException.setNextException(sQLException);
        throw sQLRecoverableException;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oracleConnection.abort();
        }
        catch (SQLException sQLException) {
        }
        try {
            executor.submit(new Runnable(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    FailoverManagerImpl.this.closePhysicalConnection(oracleConnection);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(FailoverManagerImpl.class, OracleConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
        }
        catch (Exception exception) {
        }
    }

    void enableTxnMonitoring(OracleConnection oracleConnection) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(MONITOR_TXN);
            statement.close();
        }
        catch (SQLException sQLException) {
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(BEGIN_REPLAY);
            statement.close();
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", sQLRecoverableException);
        }
    }

    void endReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(END_REPLAY);
            statement.close();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", sQLRecoverableException);
        }
    }

    Replayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException sQLException) {
        int n2;
        boolean bl = false;
        if (sQLException != null && (n2 = sQLException.getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    private void closePhysicalConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    static {
        try {
            $$$methodRef$$$35 = FailoverManagerImpl.class.getDeclaredConstructor(NonTxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = FailoverManagerImpl.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = FailoverManagerImpl.class.getDeclaredMethod("closePhysicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = FailoverManagerImpl.class.getDeclaredMethod("isReplayFailure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = FailoverManagerImpl.class.getDeclaredMethod("getConnectionProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = FailoverManagerImpl.class.getDeclaredMethod("endReplay", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = FailoverManagerImpl.class.getDeclaredMethod("beginReplay", OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = FailoverManagerImpl.class.getDeclaredMethod("enableTxnMonitoring", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = FailoverManagerImpl.class.getDeclaredMethod("killConnectionBeforeReplayDisabledException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = FailoverManagerImpl.class.getDeclaredMethod("throwOriginalExceptionWithReplayError", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = FailoverManagerImpl.class.getDeclaredMethod("failReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = FailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowOriginalError", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = FailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = FailoverManagerImpl.class.getDeclaredMethod("throwReplayExceptionInternal", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = FailoverManagerImpl.class.getDeclaredMethod("failReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = FailoverManagerImpl.class.getDeclaredMethod("disableReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = FailoverManagerImpl.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = FailoverManagerImpl.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = FailoverManagerImpl.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = FailoverManagerImpl.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = FailoverManagerImpl.class.getDeclaredMethod("setDataSource", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = FailoverManagerImpl.class.getDeclaredMethod("getReplayLifecycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = FailoverManagerImpl.class.getDeclaredMethod("setReplayInCurrentMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = FailoverManagerImpl.class.getDeclaredMethod("isReplayInCurrentMode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = FailoverManagerImpl.class.getDeclaredMethod("replayAllBeforeLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = FailoverManagerImpl.class.getDeclaredMethod("replayAllInternal", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = FailoverManagerImpl.class.getDeclaredMethod("replayAll", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = FailoverManagerImpl.class.getDeclaredMethod("fillInAllChecksums", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = FailoverManagerImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = FailoverManagerImpl.class.getDeclaredMethod("purgeForSameProxy", Set.class, CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = FailoverManagerImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = FailoverManagerImpl.class.getDeclaredMethod("update", Object.class, CallHistoryEntry.class, Object.class, String.class, Long.TYPE, Long.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = FailoverManagerImpl.class.getDeclaredMethod("record", Object.class, Method.class, Object[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = FailoverManagerImpl.class.getDeclaredMethod("remove", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = FailoverManagerImpl.class.getDeclaredMethod("append", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = FailoverManagerImpl.class.getDeclaredMethod("getFailoverManager", NonTxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(null, runnable, THREAD_NAME);
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    static final class ReplayLifecycle
    extends Enum<ReplayLifecycle> {
        public static final /* enum */ ReplayLifecycle ENABLED_NOT_REPLAYING;
        public static final /* enum */ ReplayLifecycle INTERNALLY_FAILED;
        public static final /* enum */ ReplayLifecycle INTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle ALWAYS_DISABLED;
        public static final /* enum */ ReplayLifecycle EXTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle REPLAYING_CALLBACK;
        public static final /* enum */ ReplayLifecycle REPLAYING;
        public static final /* enum */ ReplayLifecycle REPLAYING_LASTCALL;
        private static final /* synthetic */ ReplayLifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ReplayLifecycle[] values() {
            return (ReplayLifecycle[])$VALUES.clone();
        }

        public static ReplayLifecycle valueOf(String string) {
            return Enum.valueOf(ReplayLifecycle.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = ReplayLifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ReplayLifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ReplayLifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ENABLED_NOT_REPLAYING = new ReplayLifecycle();
            INTERNALLY_FAILED = new ReplayLifecycle();
            INTERNALLY_DISABLED = new ReplayLifecycle();
            ALWAYS_DISABLED = new ReplayLifecycle();
            EXTERNALLY_DISABLED = new ReplayLifecycle();
            REPLAYING_CALLBACK = new ReplayLifecycle();
            REPLAYING = new ReplayLifecycle();
            REPLAYING_LASTCALL = new ReplayLifecycle();
            $VALUES = new ReplayLifecycle[]{ENABLED_NOT_REPLAYING, INTERNALLY_FAILED, INTERNALLY_DISABLED, ALWAYS_DISABLED, EXTERNALLY_DISABLED, REPLAYING_CALLBACK, REPLAYING, REPLAYING_LASTCALL};
        }
    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long scn;
        long checksum;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        CallHistoryEntry(Object object, Method method, Object[] objectArray, String string) {
            this.jdbcProxy = object;
            this.method = method;
            this.args = objectArray;
            this.result = null;
            this.callStatus = string;
        }

        static {
            try {
                $$$methodRef$$$0 = CallHistoryEntry.class.getDeclaredConstructor(Object.class, Method.class, Object[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

