/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.util.ArrayDeque;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.JakartaParserWrapper;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.JsonpParserWrapper;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.parser.JsonLocationImpl;
import oracle.jdbc.driver.json.parser.JsonTokenizer;
import oracle.jdbc.driver.json.parser.UnicodeDetectingInputStream;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonValue;

public class JsonParserImpl
implements OracleJsonParser {
    private Context currentContext = new NoneContext();
    private OracleJsonParser.Event currentEvent;
    private final Stack stack = new Stack();
    private final JsonTokenizer tokenizer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    public JsonParserImpl(Reader reader, BufferPoolImpl bufferPoolImpl) {
        this.tokenizer = new JsonTokenizer(reader, bufferPoolImpl);
    }

    public JsonParserImpl(InputStream inputStream, BufferPoolImpl bufferPoolImpl) {
        UnicodeDetectingInputStream unicodeDetectingInputStream = new UnicodeDetectingInputStream(inputStream);
        this.tokenizer = new JsonTokenizer(new InputStreamReader((InputStream)unicodeDetectingInputStream, unicodeDetectingInputStream.getCharset()), bufferPoolImpl);
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    @Override
    public String getString() {
        if (this.currentEvent == OracleJsonParser.Event.KEY_NAME || this.currentEvent == OracleJsonParser.Event.VALUE_STRING || this.currentEvent == OracleJsonParser.Event.VALUE_DECIMAL) {
            return this.tokenizer.getValue();
        }
        throw OracleJsonExceptions.PARSER_GETSTRING_ERR.create(this.factory(), new Object[]{this.currentEvent});
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_ISINTEGRAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.isIntegral();
    }

    @Override
    public int getInt() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getInt();
    }

    @Override
    public double getDouble() {
        return this.getBigDecimal().doubleValue();
    }

    @Override
    public float getFloat() {
        return this.getBigDecimal().floatValue();
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    boolean isDefinitelyInt() {
        return this.tokenizer.isDefinitelyInt();
    }

    boolean isDefinitelyLong() {
        return this.tokenizer.isDefinitelyLong();
    }

    @Override
    public long getLong() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETLONG_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getLong();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.currentEvent != OracleJsonParser.Event.VALUE_DECIMAL) {
            throw OracleJsonExceptions.PARSER_GETBIGDECIMAL_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.tokenizer.getBigDecimal();
    }

    @Override
    public OracleJsonArray getArray() {
        if (this.currentEvent != OracleJsonParser.Event.START_ARRAY) {
            throw OracleJsonExceptions.PARSER_GETARRAY_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.getValue().asJsonArray();
    }

    @Override
    public OracleJsonObject getObject() {
        if (this.currentEvent != OracleJsonParser.Event.START_OBJECT) {
            throw OracleJsonExceptions.PARSER_GETOBJECT_ERR.create(this.factory(), new Object[]{this.currentEvent});
        }
        return this.getValue().asJsonObject();
    }

    @Override
    public OracleJsonValue getValue() {
        ArrayDeque<OracleJsonStructure> arrayDeque = new ArrayDeque<OracleJsonStructure>(4);
        OracleJsonValue oracleJsonValue = null;
        String string = null;
        if (this.currentEvent == null || this.currentEvent == OracleJsonParser.Event.END_ARRAY || this.currentEvent == OracleJsonParser.Event.END_OBJECT) {
            throw OracleJsonExceptions.BAD_PARSER_STATE_VALUE.create(this.factory(), new Object[0]);
        }
        block11: while (true) {
            switch (this.currentEvent) {
                case END_ARRAY: 
                case END_OBJECT: {
                    oracleJsonValue = (OracleJsonValue)arrayDeque.pop();
                    break;
                }
                case KEY_NAME: {
                    string = this.getString();
                    this.next();
                    continue block11;
                }
                case START_ARRAY: {
                    oracleJsonValue = new OracleJsonArrayImpl();
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    arrayDeque.push(oracleJsonValue.asJsonArray());
                    break;
                }
                case START_OBJECT: {
                    oracleJsonValue = new OracleJsonObjectImpl();
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    arrayDeque.push(oracleJsonValue.asJsonObject());
                    break;
                }
                case VALUE_DECIMAL: {
                    oracleJsonValue = this.isDefinitelyInt() ? new OracleJsonDecimalImpl(this.getInt(), null) : (this.isDefinitelyLong() ? new OracleJsonDecimalImpl(this.getLong(), null) : new OracleJsonDecimalImpl(this.getBigDecimal()));
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_STRING: {
                    oracleJsonValue = new OracleJsonStringImpl(this.getString());
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_TRUE: {
                    oracleJsonValue = OracleJsonValue.TRUE;
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_FALSE: {
                    oracleJsonValue = OracleJsonValue.FALSE;
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                case VALUE_NULL: {
                    oracleJsonValue = OracleJsonValue.NULL;
                    JsonParserImpl.addValue(oracleJsonValue, arrayDeque, string);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            string = null;
            if (arrayDeque.isEmpty()) break;
            this.next();
        }
        return oracleJsonValue;
    }

    private static void addValue(OracleJsonValue oracleJsonValue, ArrayDeque<OracleJsonStructure> arrayDeque, String string) {
        if (arrayDeque.isEmpty()) {
            return;
        }
        OracleJsonStructure oracleJsonStructure = arrayDeque.peek();
        if (oracleJsonStructure.getOracleJsonType() == OracleJsonValue.OracleJsonType.OBJECT) {
            oracleJsonStructure.asJsonObject().put(string, oracleJsonValue);
        } else {
            oracleJsonStructure.asJsonArray().add(oracleJsonValue);
        }
    }

    @Override
    public void skipArray() {
        if (this.currentEvent == OracleJsonParser.Event.START_ARRAY) {
            this.currentContext.skip();
            this.currentContext = this.stack.pop();
            this.currentEvent = OracleJsonParser.Event.END_ARRAY;
        }
    }

    @Override
    public void skipObject() {
        if (this.currentEvent == OracleJsonParser.Event.START_OBJECT) {
            this.currentContext.skip();
            this.currentContext = this.stack.pop();
            this.currentEvent = OracleJsonParser.Event.END_OBJECT;
        }
    }

    public JsonLocationImpl getLocation() {
        return this.tokenizer.getLocation();
    }

    public JsonLocationImpl getLastCharLocation() {
        return this.tokenizer.getLastCharLocation();
    }

    @Override
    public boolean hasNext() {
        if (this.stack.isEmpty() && this.currentEvent != null && this.currentEvent.compareTo(OracleJsonParser.Event.KEY_NAME) > 0) {
            JsonTokenizer.JsonToken jsonToken = this.tokenizer.nextToken();
            if (jsonToken != JsonTokenizer.JsonToken.EOF) {
                throw OracleJsonExceptions.PARSER_EXPECTED_EOF.create(this.factory(), new Object[]{this.currentEvent});
            }
            return false;
        }
        if (!this.stack.isEmpty() && !this.tokenizer.hasNextToken()) {
            this.currentEvent = this.currentContext.getNextEvent();
            return false;
        }
        return true;
    }

    @Override
    public OracleJsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEvent = this.currentContext.getNextEvent();
        return this.currentEvent;
    }

    @Override
    public void close() {
        try {
            this.tokenizer.close();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.factory(), new Object[]{this.currentEvent});
        }
    }

    private RuntimeException parsingException(JsonTokenizer.JsonToken jsonToken, String string) {
        JsonLocationImpl jsonLocationImpl = this.getLastCharLocation();
        return OracleJsonExceptions.PARSER_INVALID_TOKEN.create(this.factory(), new Object[]{jsonToken, jsonLocationImpl.getLineNumber(), jsonLocationImpl.getColumnNumber(), string});
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        try {
            if (Jsonp.isJakartaJsonStream(clazz)) {
                return clazz.cast(new JakartaParserWrapper(this));
            }
            return clazz.cast(new JsonpParserWrapper(this));
        }
        catch (ClassCastException classCastException) {
            throw OracleJsonExceptions.BAD_WRAP.create(this.factory(), classCastException, clazz.getName());
        }
    }

    @Override
    public Period getPeriod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Duration getDuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OffsetDateTime getOffsetDateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getBytes(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            $$$methodRef$$$31 = JsonParserImpl.class.getDeclaredConstructor(InputStream.class, BufferPoolImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = JsonParserImpl.class.getDeclaredConstructor(Reader.class, BufferPoolImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = JsonParserImpl.class.getDeclaredMethod("getBytes", OutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = JsonParserImpl.class.getDeclaredMethod("getLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = JsonParserImpl.class.getDeclaredMethod("getOffsetDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = JsonParserImpl.class.getDeclaredMethod("getBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = JsonParserImpl.class.getDeclaredMethod("getDuration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = JsonParserImpl.class.getDeclaredMethod("getPeriod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = JsonParserImpl.class.getDeclaredMethod("wrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = JsonParserImpl.class.getDeclaredMethod("parsingException", JsonTokenizer.JsonToken.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = JsonParserImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = JsonParserImpl.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = JsonParserImpl.class.getDeclaredMethod("hasNext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = JsonParserImpl.class.getDeclaredMethod("getLastCharLocation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = JsonParserImpl.class.getDeclaredMethod("getLocation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = JsonParserImpl.class.getDeclaredMethod("skipObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = JsonParserImpl.class.getDeclaredMethod("skipArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = JsonParserImpl.class.getDeclaredMethod("addValue", OracleJsonValue.class, ArrayDeque.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = JsonParserImpl.class.getDeclaredMethod("getValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = JsonParserImpl.class.getDeclaredMethod("getObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = JsonParserImpl.class.getDeclaredMethod("getArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = JsonParserImpl.class.getDeclaredMethod("getBigDecimal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = JsonParserImpl.class.getDeclaredMethod("getLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = JsonParserImpl.class.getDeclaredMethod("isDefinitelyLong", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = JsonParserImpl.class.getDeclaredMethod("isDefinitelyInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = JsonParserImpl.class.getDeclaredMethod("getBigInteger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = JsonParserImpl.class.getDeclaredMethod("getFloat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = JsonParserImpl.class.getDeclaredMethod("getDouble", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = JsonParserImpl.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = JsonParserImpl.class.getDeclaredMethod("isIntegralNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonParserImpl.class.getDeclaredMethod("getString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonParserImpl.class.getDeclaredMethod("factory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private final class ArrayContext
    extends Context {
        private boolean firstValue;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private ArrayContext() {
            this.firstValue = true;
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            if (jsonToken == JsonTokenizer.JsonToken.EOF) {
                switch (JsonParserImpl.this.currentEvent) {
                    case START_ARRAY: {
                        throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
                    }
                }
                throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA, CURLYCLOSE]");
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUARECLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return OracleJsonParser.Event.END_ARRAY;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (jsonToken != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA]");
                }
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (jsonToken.isValue()) {
                return jsonToken.getEvent();
            }
            if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return OracleJsonParser.Event.START_OBJECT;
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return OracleJsonParser.Event.START_ARRAY;
            }
            throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }

        @Override
        void skip() {
            JsonTokenizer.JsonToken jsonToken;
            int n2 = 1;
            do {
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
                switch (jsonToken) {
                    case SQUARECLOSE: {
                        --n2;
                        break;
                    }
                    case SQUAREOPEN: {
                        ++n2;
                        break;
                    }
                }
            } while (jsonToken != JsonTokenizer.JsonToken.SQUARECLOSE || n2 != 0);
        }

        static {
            try {
                $$$methodRef$$$2 = ArrayContext.class.getDeclaredConstructor(JsonParserImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ArrayContext.class.getDeclaredMethod("skip", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ArrayContext.class.getDeclaredMethod("getNextEvent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private final class ObjectContext
    extends Context {
        private boolean firstValue;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private ObjectContext() {
            this.firstValue = true;
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            if (jsonToken == JsonTokenizer.JsonToken.EOF) {
                switch (JsonParserImpl.this.currentEvent) {
                    case START_OBJECT: {
                        throw JsonParserImpl.this.parsingException(jsonToken, "[STRING, CURLYCLOSE]");
                    }
                    case KEY_NAME: {
                        throw JsonParserImpl.this.parsingException(jsonToken, "[COLON]");
                    }
                }
                throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA, CURLYCLOSE]");
            }
            if (JsonParserImpl.this.currentEvent == OracleJsonParser.Event.KEY_NAME) {
                if (jsonToken != JsonTokenizer.JsonToken.COLON) {
                    throw JsonParserImpl.this.parsingException(jsonToken, "[COLON]");
                }
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
                if (jsonToken.isValue()) {
                    return jsonToken.getEvent();
                }
                if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ObjectContext();
                    return OracleJsonParser.Event.START_OBJECT;
                }
                if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                    JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                    JsonParserImpl.this.currentContext = new ArrayContext();
                    return OracleJsonParser.Event.START_ARRAY;
                }
                throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
            }
            if (jsonToken == JsonTokenizer.JsonToken.CURLYCLOSE) {
                JsonParserImpl.this.currentContext = JsonParserImpl.this.stack.pop();
                return OracleJsonParser.Event.END_OBJECT;
            }
            if (this.firstValue) {
                this.firstValue = false;
            } else {
                if (jsonToken != JsonTokenizer.JsonToken.COMMA) {
                    throw JsonParserImpl.this.parsingException(jsonToken, "[COMMA]");
                }
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            }
            if (jsonToken == JsonTokenizer.JsonToken.STRING) {
                return OracleJsonParser.Event.KEY_NAME;
            }
            throw JsonParserImpl.this.parsingException(jsonToken, "[STRING]");
        }

        @Override
        void skip() {
            JsonTokenizer.JsonToken jsonToken;
            int n2 = 1;
            do {
                jsonToken = JsonParserImpl.this.tokenizer.nextToken();
                switch (jsonToken) {
                    case CURLYCLOSE: {
                        --n2;
                        break;
                    }
                    case CURLYOPEN: {
                        ++n2;
                        break;
                    }
                }
            } while (jsonToken != JsonTokenizer.JsonToken.CURLYCLOSE || n2 != 0);
        }

        static {
            try {
                $$$methodRef$$$2 = ObjectContext.class.getDeclaredConstructor(JsonParserImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ObjectContext.class.getDeclaredMethod("skip", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ObjectContext.class.getDeclaredMethod("getNextEvent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private final class NoneContext
    extends Context {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        private NoneContext() {
        }

        @Override
        public OracleJsonParser.Event getNextEvent() {
            JsonTokenizer.JsonToken jsonToken = JsonParserImpl.this.tokenizer.nextToken();
            if (jsonToken == JsonTokenizer.JsonToken.CURLYOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ObjectContext();
                return OracleJsonParser.Event.START_OBJECT;
            }
            if (jsonToken == JsonTokenizer.JsonToken.SQUAREOPEN) {
                JsonParserImpl.this.stack.push(JsonParserImpl.this.currentContext);
                JsonParserImpl.this.currentContext = new ArrayContext();
                return OracleJsonParser.Event.START_ARRAY;
            }
            if (jsonToken.isValue()) {
                return jsonToken.getEvent();
            }
            throw JsonParserImpl.this.parsingException(jsonToken, "[CURLYOPEN, SQUAREOPEN, STRING, NUMBER, TRUE, FALSE, NULL]");
        }

        @Override
        void skip() {
        }

        static {
            try {
                $$$methodRef$$$2 = NoneContext.class.getDeclaredConstructor(JsonParserImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = NoneContext.class.getDeclaredMethod("skip", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = NoneContext.class.getDeclaredMethod("getNextEvent", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private abstract class Context {
        Context next;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        private Context() {
        }

        abstract OracleJsonParser.Event getNextEvent();

        abstract void skip();

        static {
            try {
                $$$methodRef$$$0 = Context.class.getDeclaredConstructor(JsonParserImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static final class Stack {
        private Context head;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private Stack() {
        }

        private void push(Context context) {
            context.next = this.head;
            this.head = context;
        }

        private Context pop() {
            if (this.head == null) {
                throw new NoSuchElementException();
            }
            Context context = this.head;
            this.head = this.head.next;
            return context;
        }

        private boolean isEmpty() {
            return this.head == null;
        }

        static {
            try {
                $$$methodRef$$$3 = Stack.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Stack.class.getDeclaredMethod("isEmpty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Stack.class.getDeclaredMethod("pop", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Stack.class.getDeclaredMethod("push", Context.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

