/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.jdbc.driver.StateSignatures;
import oracle.jdbc.driver.TemplateOverflow;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;

@DefaultLogger(value="oracle.jdbc")
class DatabaseSessionState
implements oracle.jdbc.internal.DatabaseSessionState {
    StateSignatures stateSignatures = null;
    long templateId = 0L;
    byte[] fullOverflow = null;
    List<byte[]> deltaOverflows = new ArrayList<byte[]>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    DatabaseSessionState() {
    }

    @Override
    public oracle.jdbc.internal.StateSignatures getStateSignatures() {
        return this.stateSignatures;
    }

    @Override
    public long getId() {
        return this.templateId;
    }

    @Override
    public byte[] getCheckpoint() {
        return this.fullOverflow;
    }

    @Override
    public List<byte[]> getUpdates() {
        return this.deltaOverflows;
    }

    DatabaseSessionState copy() {
        DatabaseSessionState databaseSessionState = new DatabaseSessionState();
        databaseSessionState.stateSignatures = this.stateSignatures.copy();
        databaseSessionState.templateId = this.templateId;
        if (this.fullOverflow != null && this.fullOverflow.length > 0) {
            databaseSessionState.fullOverflow = new byte[this.fullOverflow.length];
            System.arraycopy(this.fullOverflow, 0, databaseSessionState.fullOverflow, 0, this.fullOverflow.length);
        }
        databaseSessionState.deltaOverflows = new ArrayList<byte[]>();
        for (byte[] byArray : this.deltaOverflows) {
            if (byArray == null || byArray.length <= 0) continue;
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            databaseSessionState.deltaOverflows.add(byArray2);
        }
        return databaseSessionState;
    }

    final void update(StateSignatures stateSignatures, TemplateOverflow templateOverflow) {
        this.stateSignatures = stateSignatures;
        this.stateSignatures.signatureFlags &= 0xFFFFFFFFFFFFFFBFL;
        if (templateOverflow != null) {
            this.templateId = templateOverflow.getTemplateId();
            byte[] byArray = templateOverflow.getOverflow();
            boolean bl = templateOverflow.isOverflowComplete();
            if (bl && byArray != null) {
                this.fullOverflow = byArray;
            } else if (!bl && byArray != null) {
                if (this.fullOverflow == null) {
                } else {
                    this.deltaOverflows.add(byArray);
                }
            } else if (bl && byArray == null) {
                this.fullOverflow = null;
                this.deltaOverflows = new ArrayList<byte[]>();
            }
        }
    }

    @DisableTrace
    public String toString() {
        return "DatabaseSessionState[StateSignatures=" + this.stateSignatures + ", TemplateID=" + Long.toHexString(this.getId()) + ", Full-overflow: " + (this.fullOverflow == null ? 0 : 1) + ", Delta-overflow: " + this.deltaOverflows.size() + "]";
    }

    static {
        try {
            $$$methodRef$$$6 = DatabaseSessionState.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DatabaseSessionState.class.getDeclaredMethod("update", StateSignatures.class, TemplateOverflow.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DatabaseSessionState.class.getDeclaredMethod("copy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DatabaseSessionState.class.getDeclaredMethod("getUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DatabaseSessionState.class.getDeclaredMethod("getCheckpoint", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DatabaseSessionState.class.getDeclaredMethod("getId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DatabaseSessionState.class.getDeclaredMethod("getStateSignatures", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

